/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.resources.local;

import com.deltawalker.UriInfo;
import com.deltawalker.internal.resources.local.LocalFileFactory;
import com.deltawalker.internal.resources.local.LocalFileResource;
import com.deltawalker.internal.resources.local.LocalFolderResource;
import com.deltawalker.internal.resources.local.LocalResourceDialog;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.script.Role;
import com.deltawalker.ui.dialogs.ILocalResourceDialog;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileType;
import com.deltopia.io.IFile;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResourceFactory
extends ResourceFactory {
    public static final boolean caseSensitive = EFS.getLocalFileSystem().isCaseSensitive();
    private static LocalResourceFactory factory;
    private static final Logger LOG;

    static {
        LOG = LoggerFactory.getLogger(LocalResourceFactory.class);
    }

    public static LocalResourceFactory getInstance() {
        return factory;
    }

    public LocalResourceFactory() {
        factory = this;
    }

    @Override
    public IResource createResource(UriInfo uriInfo, boolean bl, boolean bl2) throws IOException {
        String string = uriInfo.uri();
        Object var5_5 = null;
        try {
            IFileSystem iFileSystem;
            FileInfo fileInfo;
            File file;
            block13: {
                file = new File(string);
                fileInfo = null;
                iFileSystem = IO.fileSystem();
                try {
                    fileInfo = iFileSystem.getFileInfo(file);
                }
                catch (IOException iOException) {
                    if (bl) break block13;
                    LOG.warn("LocalResourceFactory#createResource()", (Throwable)iOException);
                    throw iOException;
                }
            }
            if (bl && fileInfo == null) {
                boolean bl3 = false;
                bl3 = uriInfo.fileType().isFolder() ? file.mkdir() : file.createNewFile();
                if (bl3) {
                    fileInfo = iFileSystem.getFileInfo(file);
                } else {
                    throw new IOException("Cannot create " + string);
                }
            }
            if (!bl) {
                // empty if block
            }
            if (fileInfo != null && fileInfo.isDirectory()) {
                LocalFolderResource localFolderResource = new LocalFolderResource(file, bl2, false);
                return localFolderResource;
            }
            if (bl2 && iFileSystem.isReadSymbolicLinkSupported() && fileInfo.isSymbolicLink()) {
                String string2 = iFileSystem.readSymbolicLink(string);
                file = new File(string2);
            }
            LocalFileResource localFileResource = new LocalFileResource(file, uriInfo.contentType(), bl2);
            return localFileResource;
        }
        finally {
            if (var5_5 != null) {
                var5_5.allowSecureAccess(false);
                var5_5.release();
            }
        }
    }

    @Override
    public ILocalResourceDialog createResourceWindow(Role role, boolean bl, boolean bl2, String string, IPreferenceStore iPreferenceStore, UriInfo uriInfo) {
        return new LocalResourceDialog(role, bl, bl2, string, iPreferenceStore, uriInfo);
    }

    @Override
    public FileType getResourceType(UriInfo uriInfo) throws IOException {
        FileInfo fileInfo = IO.fileSystem().getFileInfo(new File(uriInfo.uri()));
        return fileInfo.isDirectory() ? FileType.FOLDER : FileType.FILE;
    }

    @Override
    public boolean isCaseSensitive() {
        return caseSensitive;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public IFile resolveFile(UriInfo uriInfo) throws NullPointerException, IOException {
        return LocalFileFactory.createFile(new File(uriInfo.uri()));
    }

    @Override
    public boolean resourceExists(UriInfo uriInfo) {
        try {
            IO.fileSystem().getFileInfo(new File(uriInfo.uri()));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

