/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.resources.local;

import com.deltawalker.LocaleUtil;
import com.deltawalker.UriInfo;
import com.deltawalker.script.Role;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.dialogs.FileDialogEx;
import com.deltawalker.ui.dialogs.ILocalResourceDialog;
import com.deltopia.StringUtil;
import com.deltopia.io.FileType;
import com.deltopia.io.TextEncoding;
import com.deltopia.util.OS;
import java.io.Serializable;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public class LocalResourceDialog
implements ILocalResourceDialog {
    final FileDialogEx dlgFile;
    private final boolean fileDialog;
    private final IPreferenceStore prefs;
    private final Role role;
    private final String title;

    public LocalResourceDialog(Role role, boolean bl, boolean bl2, String string, IPreferenceStore iPreferenceStore, UriInfo uriInfo) {
        this.role = role;
        this.fileDialog = bl;
        this.prefs = iPreferenceStore;
        this.dlgFile = new FileDialogEx(UIUtil.getActiveWindowShell(), 8192, iPreferenceStore);
        this.title = bl2 ? NLS.bind((String)UIMsg.FileDialogEx_selectTitle, (Object)string) : NLS.bind((String)UIMsg.FileDialogEx_saveTitle, (Object)string);
        this.dlgFile.setTitle(this.title);
        if (uriInfo == null) {
            throw new NullPointerException("mruUriInfo");
        }
        this.dlgFile.setFilePath(uriInfo.uri());
        if (!bl2) {
            this.dlgFile.setUseStandaloneExtensionDialog(!OS.WIN);
        }
    }

    @Override
    public String[] getFilterExtensions() {
        return this.dlgFile.getFilterExtensions();
    }

    @Override
    public String[] getFilterNames() {
        return this.dlgFile.getFilterNames();
    }

    @Override
    public String getFilterPath() {
        return this.dlgFile.getFilterPath();
    }

    @Override
    public void setFilterExtensions(String[] stringArray) {
        this.dlgFile.setFilterExtensions(stringArray);
    }

    @Override
    public void setFilterNames(String[] stringArray) {
        this.dlgFile.setFilterNames(stringArray);
    }

    @Override
    public void setFilterPath(String string) {
        this.dlgFile.setFilterPath(string);
    }

    @Override
    public void setSelectedEncoding(TextEncoding textEncoding) {
        this.dlgFile.setSelectedEncoding(textEncoding);
    }

    @Override
    public void setSelectedLineEnding(String string) {
        this.dlgFile.setSelectedLineEnding(string);
    }

    @Override
    public void setSelectedLocale(Locale locale) {
        this.dlgFile.setSelectedLocale(locale);
    }

    @Override
    public void setShowLineEnding(boolean bl) {
        this.dlgFile.setShowLineEnding(bl);
    }

    @Override
    public UriInfo show() {
        Object object;
        Serializable serializable;
        String string = this.dlgFile.open();
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        UriInfo uriInfo = new UriInfo(string, this.fileDialog ? FileType.FILE : FileType.FOLDER);
        if (this.fileDialog) {
            serializable = null;
            if (this.dlgFile.isCharsetSelected()) {
                object = this.dlgFile.getSelectedEncoding(false);
                uriInfo = uriInfo.cloneUpdateEncoding((TextEncoding)object);
            } else {
                serializable = this.dlgFile.getSelectedLocale();
                if (serializable == null) {
                    serializable = LocaleUtil.getLocale(this.prefs);
                }
                uriInfo = uriInfo.cloneUpdateLocale((Locale)serializable);
            }
            uriInfo = uriInfo.cloneUpdateLineEnding(this.dlgFile.getSelectedLineEnding());
        }
        if ((serializable = uriInfo.error()) == null) {
            object = UriInfo.constructMruName(this.role != null ? this.role.toString() : "");
            this.prefs.setValue((String)object, string);
        }
        return uriInfo;
    }
}

