/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.resources.local;

import com.deltawalker.IStorageNotifier;
import com.deltawalker.internal.resources.local.LocalFile;
import com.deltawalker.internal.resources.local.LocalFileFactory;
import com.deltawalker.internal.resources.local.LocalFolderResource;
import com.deltawalker.internal.resources.local.LocalResourceFactory;
import com.deltawalker.resources.FileResource;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResourceFactory;
import com.deltopia.io.ContentType;
import com.deltopia.io.IFile;
import com.deltopia.io.IO;
import com.deltopia.io.IStorageListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.httpclient.util.DateUtil;

public class LocalFileResource
extends FileResource
implements IStorageNotifier {
    private static final ExecutorService exec = IO.fileSystem().isStorageListenerSupported() ? Executors.newCachedThreadPool() : null;

    LocalFileResource(File file, ContentType contentType, boolean bl) throws IOException {
        this(LocalFileFactory.createFile(file), null, contentType, bl);
    }

    LocalFileResource(IFile iFile, LocalFolderResource localFolderResource, ContentType contentType, boolean bl) {
        super(iFile, localFolderResource, contentType, bl);
    }

    @Override
    public void addStorageListener(final IStorageListener iStorageListener) {
        if (exec != null) {
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    IO.fileSystem().addStorageListener(((LocalFile)LocalFileResource.this.file()).file(), iStorageListener);
                }
            });
        }
    }

    @Override
    public IResourceFactory factory() {
        return LocalResourceFactory.getInstance();
    }

    @Override
    public void refreshFromStorage(Object[] objectArray) throws IOException {
        if (objectArray != null && objectArray.length > 0) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                ((IPersistableResource)object).load(null, null);
                ++n2;
            }
            return;
        }
        this.load(null, null);
    }

    @Override
    public void removeStorageListener(final IStorageListener iStorageListener) {
        if (exec != null) {
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    IO.fileSystem().removeStorageListener(((LocalFile)LocalFileResource.this.file()).file(), iStorageListener);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean shouldFireStorageEvents() {
        long l;
        LocalFileResource localFileResource = this;
        synchronized (localFileResource) {
            l = this.getLastModifiedTime();
        }
        long l2 = new File(this.getPath()).lastModified();
        if (l != l2) {
            if (LOG_DBG) {
                LOG.debug("Detect change " + LocalFileResource.formatTime(l) + " != " + LocalFileResource.formatTime(l2));
            }
            return true;
        }
        if (LOG_DBG) {
            LOG.debug("No change " + LocalFileResource.formatTime(l));
        }
        return false;
    }

    private static final String formatTime(long l) {
        return String.valueOf(DateUtil.formatDate((Date)new Date(l))) + " (" + l + ")";
    }
}

