/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.resources.local;

import com.deltawalker.internal.resources.local.LocalChildFile;
import com.deltawalker.internal.resources.local.LocalChildFolder;
import com.deltawalker.internal.resources.local.LocalRootFile;
import com.deltopia.io.FileInfo;
import com.deltopia.io.IFile;
import com.deltopia.io.IO;
import java.io.File;
import java.io.IOException;

public class LocalFileFactory {
    public static final IFile createFile(File file) throws IOException {
        return LocalFileFactory.createFile(file, null);
    }

    static final IFile createFile(File file, IFile iFile) throws IOException {
        FileInfo fileInfo;
        try {
            fileInfo = IO.fileSystem().getFileInfo(file);
        }
        catch (IOException iOException) {
            fileInfo = FileInfo.createFromPath((File)file);
        }
        if (iFile == null) {
            return new LocalRootFile(fileInfo, file);
        }
        return LocalFileFactory.createFile(fileInfo, iFile);
    }

    static final IFile createFile(FileInfo fileInfo, IFile iFile) {
        if (fileInfo.isDirectory()) {
            return new LocalChildFolder(fileInfo, iFile);
        }
        return new LocalChildFile(fileInfo, iFile);
    }
}

