/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.resources.local;

import com.deltawalker.internal.resources.local.LocalFileFactory;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IPrincipal;
import com.deltopia.io.FileInfo;
import com.deltopia.io.FileInfoEx;
import com.deltopia.io.IFile;
import com.deltopia.io.IFileSystem;
import com.deltopia.io.IO;
import com.deltopia.io.Principal;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.UriInfoKey;
import com.deltopia.util.Checker;
import com.deltopia.util.OS;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LocalFile
implements IFile {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFile.class);
    private static final boolean LOG_DBG = LOG.isDebugEnabled();
    private static final boolean WRAP_STREAM = false;
    private FileInfo fileInfo;
    private final IFile parent;

    LocalFile(FileInfo fileInfo, IFile iFile) {
        this.fileInfo = (FileInfo)Checker.notNull((Object)fileInfo, (String)"fileInfo");
        this.parent = iFile;
    }

    private String constructPath(boolean bl) {
        String string = this.parentPath(bl);
        String string2 = this.getName();
        if (!StringUtil.isEmpty((String)string)) {
            if (!string.endsWith(File.separator)) {
                return String.valueOf(string) + File.separator + string2;
            }
            return String.valueOf(string) + string2;
        }
        return bl && this.parent == null ? "" : string2;
    }

    public long createdTime() {
        if (this.fileInfo instanceof FileInfoEx) {
            return ((FileInfoEx)this.fileInfo).createdTime();
        }
        return this.fileInfo.lastModifiedTime();
    }

    public InputStream createInputStream(boolean bl) throws IOException {
        IFileSystem iFileSystem = IO.fileSystem();
        if (iFileSystem.isReadSymbolicLinkSupported() && this.isSymbolicLink()) {
            byte[] byArray = iFileSystem.readSymbolicLinkData(this.getPath());
            return new ByteArrayInputStream(byArray);
        }
        InputStream inputStream = new FileInputStream(this.file());
        if (bl) {
            try {
                inputStream = new BufferedInputStream(inputStream);
            }
            catch (Error | RuntimeException throwable) {
                StreamUtil.closeSilently((Closeable)inputStream);
                throw throwable;
            }
        }
        return inputStream;
    }

    public void createNewFile() throws IOException {
        this.file().createNewFile();
    }

    public OutputStream createOutputStream(boolean bl) throws IOException {
        OutputStream outputStream = new FileOutputStream(this.file());
        if (bl) {
            try {
                outputStream = new BufferedOutputStream(outputStream);
            }
            catch (Error | RuntimeException throwable) {
                StreamUtil.closeSilently((Closeable)outputStream);
                throw throwable;
            }
        }
        return outputStream;
    }

    public void createSymbolicLink(IFile iFile) throws IOException {
        String string = this.getPath();
        String string2 = iFile.readSymbolicLink();
        boolean bl = iFile.isDirectory(true);
        IO.fileSystem().createSymbolicLink(new File(string), string2, bl);
        this.fileInfo = iFile.getFileInfo();
    }

    public boolean delete() {
        return this.file().delete();
    }

    public boolean exists() {
        return this.file().exists();
    }

    public File file() {
        File file = new File(this.getPath());
        return file;
    }

    public int getAttributes() {
        return this.getFileInfo().attributes();
    }

    public String getDisplayUri() {
        return this.getUri();
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public IPrincipal getGroup() {
        if (this.fileInfo instanceof FileInfoEx) {
            FileInfoEx fileInfoEx = (FileInfoEx)this.fileInfo;
            try {
                return IO.fileSystem().getGroup(fileInfoEx.getGid());
            }
            catch (IOException iOException) {
                LOG.error("Couldn't get group name from group ID", (Throwable)iOException);
                return new Principal(fileInfoEx.getGid());
            }
        }
        return null;
    }

    public long getLastModifiedTime() {
        return this.fileInfo.lastModifiedTime();
    }

    public String getName() {
        return this.fileInfo.name();
    }

    public IPrincipal getOwner() {
        if (this.fileInfo instanceof FileInfoEx) {
            FileInfoEx fileInfoEx = (FileInfoEx)this.fileInfo;
            try {
                return IO.fileSystem().getUser(fileInfoEx.getUid());
            }
            catch (IOException iOException) {
                LOG.error("Couldn't get user name from user ID", (Throwable)iOException);
                return new Principal(fileInfoEx.getUid());
            }
        }
        return null;
    }

    public String getParentUri() {
        return this.parentPath(false);
    }

    public String getPath() {
        return this.constructPath(false);
    }

    public String getUri() {
        return this.getPath();
    }

    public boolean isDirectory(boolean bl) {
        if (bl && this.isSymbolicLink()) {
            return this.file().isDirectory();
        }
        return this.fileInfo.isDirectory();
    }

    public boolean isHidden() {
        return this.fileInfo.isHidden();
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isMoveToTrashSupported() {
        return IO.fileSystem().isMoveToTrashSupported();
    }

    public boolean isReadable() {
        return this.fileInfo.isReadable();
    }

    public boolean isRoot() {
        return this.file().getParentFile() == null;
    }

    public boolean isSymbolicLink() {
        return this.fileInfo.isSymbolicLink();
    }

    public boolean isWritable() {
        return this.fileInfo.isWritable();
    }

    public long lastOpenedTime() {
        if (this.fileInfo instanceof FileInfoEx) {
            return ((FileInfoEx)this.fileInfo).lastAccessedTime();
        }
        return this.fileInfo.lastModifiedTime();
    }

    public IFile[] listFiles(int n, IProgressMonitor iProgressMonitor) throws IOException {
        IFile[] iFileArray;
        int n2;
        FileInfo[] fileInfoArray = IO.fileSystem().listFileInfos(this.file(), n, iProgressMonitor, -1);
        if (fileInfoArray == null || (n2 = fileInfoArray.length) == 0) {
            iFileArray = NO_FILES;
        } else {
            iFileArray = new IFile[n2];
            int n3 = 0;
            while (n3 < n2) {
                iFileArray[n3] = LocalFileFactory.createFile(fileInfoArray[n3], (IFile)this);
                ++n3;
            }
        }
        return iFileArray;
    }

    public void mkdir() throws IOException {
        boolean bl = this.file().mkdir();
        if (!bl) {
            throw new IOException("Couldn't create new folder: " + this.getPath());
        }
    }

    public boolean moveToTrash() {
        return IO.fileSystem().delete(this.file(), true);
    }

    public IFile parent() {
        return this.parent;
    }

    protected abstract String parentPath(boolean var1);

    public String readSymbolicLink() throws IOException {
        IFileSystem iFileSystem = IO.fileSystem();
        assert (iFileSystem.isReadSymbolicLinkSupported() && this.isSymbolicLink());
        return IO.fileSystem().readSymbolicLink(this.getPath());
    }

    public void renameTo(String string, Map<UriInfoKey, Object> map, boolean bl) throws IOException {
        boolean bl2;
        File file = new File(bl ? string : String.valueOf(this.getParentUri()) + File.separator + string);
        if (!bl && file.exists()) {
            String string2 = NLS.bind((String)"A resource named ''{0}'' already exists in this folder.\n\nPlease choose a different name.", (Object)string);
            throw new IOException(string2);
        }
        IFile iFile = bl ? LocalFileFactory.createFile(file.getParentFile()) : this.parent;
        File file2 = bl ? file : this.file();
        boolean bl3 = iFile.isWritable();
        if (!bl3) {
            iFile.setWritable(true);
        }
        if (bl2 = file2.renameTo(bl ? this.file() : file)) {
            if (bl) {
                this.updateFileInfo();
            } else {
                this.setFileInfo(this.fileInfo.cloneUsingNewName(string));
            }
        }
        if (!bl3) {
            iFile.setWritable(false);
        }
        if (!bl2) {
            throw new IOException("Couldn't rename " + this.getPath() + " to " + file);
        }
    }

    public IFile resolveFile(String string, IFile iFile, boolean bl) throws IOException {
        return LocalFileFactory.createFile(new File(this.file(), string), iFile);
    }

    public long resourceForkSize() {
        long l = 0L;
        if (OS.OSX) {
            l = new File(String.valueOf(this.getPath()) + "/..namedfork/rsrc").length();
        }
        return l;
    }

    public String rootlessPath() {
        String string = this.constructPath(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Local rootless path: " + string);
        }
        return string;
    }

    public String scheme() {
        return "";
    }

    public void setAttributes(int n) throws IOException {
        this.setFileInfo(this.fileInfo.cloneUsingNewAttributes(n));
    }

    public void setFileInfo(FileInfo fileInfo) throws IOException {
        if (fileInfo == null) {
            throw new NullPointerException("fileInfo");
        }
        File file = new File(String.valueOf(this.parentPath(false)) + File.separator + fileInfo.name());
        File file2 = file.exists() ? file : this.file();
        boolean bl = fileInfo.attributes() != 0;
        int n = bl ? 127 : 28;
        IO.fileSystem().setFileInfo(file2, fileInfo, n);
        FileInfo fileInfo2 = IO.fileSystem().getFileInfo(file2);
        if (bl && file.exists() && !fileInfo.equalsSettable(fileInfo2)) {
            LOG.warn("Desired file info differs from set '" + file2 + "': " + fileInfo + " != " + fileInfo2 + " mask=" + n);
        }
        this.fileInfo = fileInfo2;
    }

    public void setHidden(boolean bl) throws IOException {
        if (OS.WIN && this.fileInfo.isHidden() != bl) {
            int n = this.fileInfo.attributes();
            int n2 = bl ? n | 0x20 : n & 0xFFFFFFDF;
            FileInfo fileInfo = this.fileInfo.cloneUsingNewAttributes(n2);
            IO.fileSystem().setFileInfo(this.file(), fileInfo, 2);
            this.fileInfo = fileInfo;
        }
    }

    public void setLastModifiedTime(long l) throws IOException {
        FileInfo fileInfo = this.fileInfo.cloneUsingNewLastModifiedTime(l);
        IO.fileSystem().setFileInfo(this.file(), fileInfo, 4);
        this.fileInfo = fileInfo;
    }

    public void setWritable(boolean bl) throws IOException {
        if (this.fileInfo.isWritable() != bl) {
            int n = this.fileInfo.attributes();
            int n2 = bl ? n | 0x20000 : n & 0xFFFDFFFF;
            FileInfo fileInfo = this.fileInfo.cloneUsingNewAttributes(n2);
            IO.fileSystem().setFileInfo(this.file(), fileInfo, 1);
            this.fileInfo = fileInfo;
        }
    }

    public long size() {
        return this.fileInfo.size();
    }

    public String toString() {
        return this.getUri();
    }

    public void updateFileInfo() {
        FileInfo fileInfo;
        String string = this.getPath();
        File file = new File(string);
        try {
            fileInfo = IO.fileSystem().getFileInfo(file);
        }
        catch (IOException iOException) {
            LOG.warn("Couldn't get file info for " + string, (Throwable)iOException);
            fileInfo = FileInfo.createFromPath((File)file);
        }
        if (LOG_DBG) {
            LOG.debug("Update file info: " + this.fileInfo + " to " + fileInfo);
        }
        this.fileInfo = fileInfo;
    }

    private static final class InputStreamWrapper
    extends FilterInputStream {
        private final String name;

        InputStreamWrapper(InputStream inputStream) {
            super(inputStream);
            this.name = " InStream @" + System.identityHashCode(inputStream);
            LOG.warn("+++ " + this.name, (Throwable)new Exception());
        }

        @Override
        public void close() throws IOException {
            LOG.warn("--- " + this.name, (Throwable)new Exception());
            super.close();
        }
    }
}

