/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.PrefKey;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.internal.reports.HierarchyReporter;
import com.deltawalker.script.Role;
import com.deltawalker.structure.AlignFilter;
import com.deltawalker.structure.FolderFilter;
import com.deltawalker.structure.PathFilter;
import com.deltawalker.ui.IDiffSummary;
import com.deltawalker.ui.IDiffSummaryItem;
import com.deltopia.StringUtil;
import com.deltopia.io.xml.XmlWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class XmlReporter
extends HierarchyReporter {
    private XmlWriter writer;

    public XmlReporter(TagReportConfig tagReportConfig, List<IDiffModel> list, String string) throws NullPointerException {
        super(tagReportConfig, list, string);
    }

    @Override
    protected void reportConfig(IDiffModel iDiffModel) throws Exception {
        this.writer.startElement("config");
        IPreferenceStore iPreferenceStore = iDiffModel.deltaDoc().preferences();
        for (Map.Entry entry : PREF_MAP.entrySet()) {
            String string = Boolean.toString(iPreferenceStore.getBoolean(((PrefKey)((Object)entry.getKey())).toString()));
            this.writer.emptyElementAttr("prefs", "name", (String)entry.getValue(), "value", string);
        }
        this.reportFilters(iDiffModel.filters());
        this.writer.endElement("config");
    }

    @Override
    protected void reportModel(IDiffModel iDiffModel) throws Exception {
        this.writer.startElement("snapshot");
        super.reportModel(iDiffModel);
        this.writer.endElement("snapshot");
    }

    @Override
    protected void reportElement(Role role, IDiffNode iDiffNode, String string, String string2, int n) {
    }

    @Override
    protected void reportEnd() throws SAXException {
        this.writer.endElement("report");
        this.writer.endDocument();
    }

    protected void reportFilters(IFilters iFilters) throws SAXException {
        if (iFilters.getCount() > 0) {
            List<IFilter> list = iFilters.getAllAsList();
            AttributesImpl attributesImpl = new AttributesImpl();
            for (IFilter iFilter : list) {
                FolderFilter folderFilter;
                if (!iFilter.isEnabled()) continue;
                attributesImpl.addAttribute(null, null, "enabled", "CDATA", Boolean.toString(iFilter.isEnabled()));
                if (iFilter instanceof FolderFilter) {
                    folderFilter = (FolderFilter)iFilter;
                    attributesImpl.addAttribute(null, null, "action", "CDATA", folderFilter.action().toString());
                    attributesImpl.addAttribute(null, null, "target", "CDATA", folderFilter.target().toString());
                }
                if (iFilter instanceof AlignFilter) {
                    folderFilter = (AlignFilter)iFilter;
                    attributesImpl.addAttribute(null, null, "regex", "CDATA", Boolean.toString(((AlignFilter)folderFilter).isRegexType()));
                }
                if (iFilter instanceof PathFilter) {
                    folderFilter = (PathFilter)iFilter;
                    attributesImpl.addAttribute(null, null, "regex", "CDATA", Boolean.toString(((PathFilter)folderFilter).isRegexType()));
                }
                this.writer.startElement("filter", (Attributes)attributesImpl);
                this.writer.startElement("expression");
                this.writer.characters(iFilter.getDisplayExpression());
                this.writer.endElement("expression");
                this.writer.endElement("filter");
            }
            this.writer.endElement("filters");
        }
    }

    @Override
    protected void reportStart(Writer writer) throws SAXException {
        this.writer = new XmlWriter(writer, true, 3);
        this.writer.startDocument();
        this.writer.startElementAttr("report", "dt", this.formatDate(new Date()));
    }

    @Override
    protected void reportSummary(IDiffSummary iDiffSummary) throws Exception {
        String[] stringArray;
        this.writer.startElement("summary");
        String string = iDiffSummary.description();
        if (!StringUtil.isEmpty((String)string)) {
            this.writer.textElement("description", string);
        }
        String[] stringArray2 = stringArray = iDiffSummary.properties();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String object = stringArray2[n2];
            this.writer.emptyElementAttr("cc", "name", object);
            ++n2;
        }
        for (IDiffSummaryItem iDiffSummaryItem : iDiffSummary.getItems()) {
            this.reportSummaryItem(iDiffSummaryItem, stringArray);
        }
        this.writer.endElement("summary");
    }

    private void reportSummaryItem(IDiffSummaryItem iDiffSummaryItem, String[] stringArray) throws SAXException {
        String string = iDiffSummaryItem.getName();
        if (string != null) {
            this.writer.startElement("item", "name", string);
        } else {
            this.writer.startElement("item");
        }
        if (iDiffSummaryItem.itemCount() > 0) {
            IDiffSummaryItem[] iDiffSummaryItemArray = iDiffSummaryItem.items();
            int n = iDiffSummaryItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffSummaryItem iDiffSummaryItem2 = iDiffSummaryItemArray[n2];
                this.reportSummaryItem(iDiffSummaryItem2, stringArray);
                ++n2;
            }
        } else {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String string2 = stringArray2[n3];
                Object object = iDiffSummaryItem.getValue(string2);
                if (object != null) {
                    this.writer.emptyElementAttr("cc", "name", string2, "value", object.toString());
                }
                ++n3;
            }
        }
        this.writer.endElement("item");
    }
}

