/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.ITextDiffDoc;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.internal.PatchReportConfig;
import com.deltawalker.internal.reports.PatchReporter;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Point;

public class TextPatchReporter
extends PatchReporter {
    private static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.000000000 Z";
    private static DateFormat DATE_FORMATTER = new SimpleDateFormat(DATE_FORMAT);
    private ITextDiffDoc tdDoc = null;

    public TextPatchReporter(PatchReportConfig patchReportConfig, List<IDiffModel> list, String string) throws NullPointerException {
        super(patchReportConfig, list, string);
    }

    private void createHeader(PatchReportConfig patchReportConfig, PrintWriter printWriter) {
        String string;
        String string2;
        switch (patchReportConfig.kind) {
            case CONTEXT: {
                string2 = "*** ";
                string = "--- ";
                break;
            }
            case UNIFIED: {
                string2 = "--- ";
                string = "+++ ";
                break;
            }
            default: {
                return;
            }
        }
        IResource iResource = this.tdDoc.doc(0, Role.REF).resource();
        if (iResource == null) {
            printWriter.println(string2);
        } else {
            printWriter.println(String.valueOf(string2) + iResource.getPath() + " " + this.formatDate(new Date(iResource.getLastModifiedTime())));
        }
        IResource iResource2 = this.tdDoc.doc(0, Role.ONE).resource();
        if (iResource2 == null) {
            printWriter.println(string);
        } else {
            printWriter.println(String.valueOf(string) + iResource2.getPath() + " " + this.formatDate(new Date(iResource2.getLastModifiedTime())));
        }
    }

    private void createHunk(List<DiffRange> list, int n, int n2, Point[] pointArray, ITextDiffModel iTextDiffModel, PatchReportConfig.Kind kind, PrintWriter printWriter) throws BadLocationException, IOException {
        switch (kind) {
            case CONTEXT: {
                printWriter.println("***************");
                for (Role role : Relation.REF_ONE.toSet()) {
                    this.createHunkInContext(role, list, pointArray[role.toInt()], printWriter);
                }
                break;
            }
            case ED_SCRIPT: {
                this.createHunkInEdScript(list, n, n2, pointArray, iTextDiffModel, printWriter);
                break;
            }
            case NORMAL: {
                this.createHunkInNormal(list, n, n2, pointArray, iTextDiffModel, printWriter);
                break;
            }
            case UNIFIED: {
                this.createHunkInUnified(list, n, n2, pointArray, iTextDiffModel, printWriter);
            }
        }
    }

    private void createHunkInContext(Role role, List<DiffRange> list, Point point, PrintWriter printWriter) throws BadLocationException, IOException {
        boolean bl = role == Role.REF;
        int n = point.y;
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(bl ? "*** " : "--- ");
            stringBuilder.append(this.getLineRangeString(point, false));
            stringBuilder.append(bl ? " ****" : " ----");
            printWriter.println(stringBuilder.toString());
            int n2 = point.x;
            int n3 = n2 + n;
            int n4 = n2;
            while (n4 < n3) {
                String string;
                Delta.Kind kind = this.deltaKindOnLine(role, n4, list);
                if (kind == Delta.Kind.ADDED) {
                    string = "+ ";
                } else if (kind == Delta.Kind.DELETED) {
                    string = "- ";
                } else if (kind == Delta.Kind.CHANGED) {
                    string = "! ";
                } else {
                    assert (false);
                    string = "  ";
                }
                printWriter.println(String.valueOf(string) + this.getLine(role, n4));
                ++n4;
            }
        }
    }

    private void createHunkInEdScript(List<DiffRange> list, int n, int n2, Point[] pointArray, ITextDiffModel iTextDiffModel, PrintWriter printWriter) throws BadLocationException, IOException {
        if (n != n2) {
            throw new IllegalArgumentException("endIndex");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLineRangeString(pointArray[0], false));
        DiffRange diffRange = list.get(n);
        Delta.Kind kind = diffRange.getKind(Relation.REF_ONE);
        if (kind == Delta.Kind.CHANGED) {
            stringBuffer.append('c');
        } else if (kind == Delta.Kind.DELETED) {
            stringBuffer.append('d');
        } else if (kind == Delta.Kind.ADDED) {
            stringBuffer.append('a');
        } else {
            assert (false);
            return;
        }
        printWriter.println(stringBuffer.toString());
        if (kind == Delta.Kind.CHANGED || kind == Delta.Kind.ADDED) {
            Point point = pointArray[1];
            int n3 = point.x;
            int n4 = n3 + point.y;
            int n5 = n3;
            while (n5 < n4) {
                printWriter.println(this.getLine(Role.ONE, n5));
                ++n5;
            }
            printWriter.println('.');
        }
    }

    private void createHunkInNormal(List<DiffRange> list, int n, int n2, Point[] pointArray, ITextDiffModel iTextDiffModel, PrintWriter printWriter) throws BadLocationException, IOException {
        if (n != n2) {
            throw new IllegalArgumentException("endIndex");
        }
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLineRangeString(point, false));
        DiffRange diffRange = list.get(n);
        Delta.Kind kind = diffRange.getKind(Relation.REF_ONE);
        if (kind == Delta.Kind.CHANGED) {
            stringBuilder.append('c');
        } else if (kind == Delta.Kind.DELETED) {
            stringBuilder.append('d');
        } else if (kind == Delta.Kind.ADDED) {
            stringBuilder.append('a');
        } else {
            assert (false);
            return;
        }
        stringBuilder.append(this.getLineRangeString(point2, false));
        printWriter.println(stringBuilder.toString());
        if (point.y > 0) {
            this.createHunkInNormal(Role.REF, list, n, n2, point, iTextDiffModel, printWriter);
        }
        if (point2.y > 0) {
            if (point.y > 0) {
                printWriter.println("---");
            }
            this.createHunkInNormal(Role.ONE, list, n, n2, point2, iTextDiffModel, printWriter);
        }
    }

    private void createHunkInNormal(Role role, List<DiffRange> list, int n, int n2, Point point, ITextDiffModel iTextDiffModel, PrintWriter printWriter) throws BadLocationException, IOException {
        block6: {
            boolean bl = role == Role.REF;
            int n3 = point.y;
            if (n3 <= 0) break block6;
            int n4 = point.x;
            int n5 = n4 + n3;
            int n6 = n4;
            while (n6 < n5) {
                block7: {
                    String string;
                    Delta.Kind kind = this.deltaKindOnLine(role, n6, list);
                    switch (kind) {
                        case ADDED: {
                            string = "> ";
                            break;
                        }
                        case DELETED: {
                            string = "< ";
                            break;
                        }
                        case CHANGED: {
                            string = bl ? "< " : "> ";
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    printWriter.println(String.valueOf(string) + this.getLine(role, n6));
                }
                ++n6;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void createHunkInUnified(List<DiffRange> var1_1, int var2_2, int var3_3, Point[] var4_4, ITextDiffModel var5_5, PrintWriter var6_6) throws BadLocationException, IOException {
        var7_7 = var4_4[0];
        var8_8 = var4_4[1];
        var9_9 = new StringBuffer();
        var9_9.append("@@ -");
        var9_9.append(this.getLineRangeString(var7_7, true));
        var9_9.append(" +");
        var9_9.append(this.getLineRangeString(var8_8, true));
        var9_9.append(" @@");
        var6_6.println(var9_9.toString());
        var10_10 = var4_4.length;
        var11_11 = new DiffRange[var10_10][];
        var12_12 = Relation.roles(false);
        var13_13 = Relation.roles(false).toArray(new Role[var12_12.size()]);
        var14_14 = 0;
        while (var14_14 < var10_10) {
            var15_15 = var4_4[var14_14];
            var11_11[var14_14] = new DiffRange[var15_15.y];
            var16_17 = var11_11[var14_14];
            var17_19 = var15_15.x;
            var18_20 = var2_2;
            while (var18_20 <= var3_3) {
                var19_21 /* !! */  = var1_1.get(var18_20);
                var20_22 = this.getLineRange(var13_13[var14_14], (DiffRange)var19_21 /* !! */ , this.config(), false);
                var21_23 = var20_22.x - var17_19;
                var22_24 = var21_23 + var20_22.y;
                var23_25 = var21_23;
                while (var23_25 < var22_24) {
                    var16_17[var23_25] = var19_21 /* !! */ ;
                    ++var23_25;
                }
                ++var18_20;
            }
            ++var14_14;
        }
        var14_14 = var7_7.x;
        var15_16 = var8_8.x;
        var16_18 = var14_14 + var7_7.y;
        var17_19 = var15_16 + var8_8.y;
        var18_20 = var2_2;
        var19_21 /* !! */  = var11_11[0];
        var20_22 = var11_11[1];
        var21_23 = var14_14;
        var22_24 = var15_16;
        ** GOTO lbl84
        {
            var23_27 = this.getLine(var13_13[0], var21_23);
            var6_6.println(" " + var23_27);
            ++var21_23;
            ++var22_24;
            do {
                if (var21_23 < var16_18 && var19_21 /* !! */ [var21_23 - var14_14] == null && var22_24 < var17_19 && var20_22[var22_24 - var15_16] == null) continue block3;
                if (var18_20 > var3_3) break block3;
                var23_28 = var1_1.get(var18_20);
                for (Role var24_29 : var12_12) {
                    var26_31 = this.getLineRange(var24_29, var23_28, this.config(), false);
                    var27_32 = var26_31.x;
                    var28_33 = var27_32 + var26_31.y;
                    var29_34 = var27_32;
                    while (var29_34 < var28_33) {
                        var30_35 = this.getLine(var24_29, var29_34);
                        var31_36 = var23_28.getKind(Relation.REF_ONE);
                        if (var31_36 == Delta.Kind.CHANGED) {
                            var6_6.println(String.valueOf(var24_29 == Role.REF ? "-" : "+") + var30_35);
                        } else if (var31_36 == Delta.Kind.DELETED) {
                            var6_6.println("-" + var30_35);
                        } else if (var31_36 == Delta.Kind.ADDED) {
                            var6_6.println("+" + var30_35);
                        }
                        ++var29_34;
                    }
                    if (var24_29 == Role.REF) {
                        if (var29_34 <= var21_23) continue;
                        var21_23 = var29_34;
                        continue;
                    }
                    if (var29_34 <= var22_24) continue;
                    var22_24 = var29_34;
                }
                ++var18_20;
lbl84:
                // 2 sources

            } while (var21_23 < var16_18 || var22_24 < var17_19);
        }
    }

    private void createPatch(ITextDiffModel iTextDiffModel, PrintWriter printWriter) throws BadLocationException, IOException {
        List<DiffRange> list = iTextDiffModel.getTrueDiffs();
        if (list.isEmpty()) {
            return;
        }
        PatchReportConfig patchReportConfig = this.config();
        this.createHeader(patchReportConfig, printWriter);
        Set<Role> set = Relation.roles(false);
        int n = set.size();
        Role[] roleArray = Relation.roles(false).toArray(new Role[n]);
        int n2 = list.size();
        if (patchReportConfig.kind == PatchReportConfig.Kind.ED_SCRIPT) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                Point[] pointArray = new Point[n];
                DiffRange diffRange = list.get(n3);
                int n4 = 0;
                while (n4 < n) {
                    pointArray[n4] = this.getLineRange(roleArray[n4], diffRange, patchReportConfig, true);
                    ++n4;
                }
                this.createHunk(list, n3, n3, pointArray, iTextDiffModel, patchReportConfig.kind, printWriter);
                --n3;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                Point[] pointArray = new Point[n];
                DiffRange diffRange = list.get(n5);
                int n6 = 0;
                while (n6 < n) {
                    pointArray[n6] = this.getLineRange(roleArray[n6], diffRange, patchReportConfig, true);
                    ++n6;
                }
                n6 = n5;
                int n7 = n5 + 1;
                while (n7 < n2) {
                    Point point;
                    Point point2;
                    Point[] pointArray2 = new Point[n];
                    DiffRange diffRange2 = list.get(n7);
                    boolean bl = false;
                    int n8 = 0;
                    while (n8 < n) {
                        point2 = pointArray2[n8] = this.getLineRange(roleArray[n8], diffRange2, patchReportConfig, true);
                        point = pointArray[n8];
                        if (!bl && point2.x < point.x + point.y) {
                            bl = true;
                        }
                        ++n8;
                    }
                    if (!bl) break;
                    n8 = 0;
                    while (n8 < n) {
                        point2 = pointArray[n8];
                        point = pointArray2[n8];
                        point2.y = point.x + point.y - point2.x;
                        ++n8;
                    }
                    n6 = n7++;
                }
                this.createHunk(list, n5, n6, pointArray, iTextDiffModel, patchReportConfig.kind, printWriter);
                n5 = n6;
                ++n5;
            }
        }
    }

    private Delta.Kind deltaKindOnLine(Role role, int n, List<DiffRange> list) throws BadLocationException {
        IDocument iDocument = this.tdDoc.document(role);
        int n2 = iDocument.getLineOffset(n);
        for (DiffRange diffRange : list) {
            Position position = diffRange.position(role);
            if (position.offset > n2 || n2 >= position.offset + position.length) continue;
            return diffRange.getKind(Relation.REF_ONE);
        }
        return Delta.Kind.SAME;
    }

    @Override
    protected String formatDate(Date date) throws NullPointerException {
        if (date == null) {
            throw new NullPointerException("date");
        }
        return DATE_FORMATTER.format(date);
    }

    private String getLine(Role role, int n) throws BadLocationException {
        IDocument iDocument = this.tdDoc.document(role);
        IRegion iRegion = iDocument.getLineInformation(n);
        return iDocument.get(iRegion.getOffset(), iRegion.getLength());
    }

    private Point getLineRange(Role role, DiffRange diffRange, PatchReportConfig patchReportConfig, boolean bl) throws BadLocationException {
        IDocument iDocument = this.tdDoc.document(role);
        Position position = diffRange.position(role);
        int n = iDocument.getLineOfOffset(position.offset);
        int n2 = iDocument.getLineOfOffset(position.offset + position.length);
        if (bl) {
            int n3 = patchReportConfig.ctxLnCount;
            n = n >= n3 ? (n -= n3) : 0;
            int n4 = iDocument.getNumberOfLines();
            n2 = n2 + n3 >= n4 ? n4 : (n2 += n3);
        }
        return new Point(n, n2 - n);
    }

    private String getLineRangeString(Point point, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = point.y;
        stringBuffer.append(point.x + (n > 0 ? 1 : 0));
        if (bl || n > 1) {
            stringBuffer.append(',');
            stringBuffer.append(bl ? n : point.x + n);
        }
        return stringBuffer.toString();
    }

    @Override
    protected void reportModel(IDiffModel iDiffModel) throws Exception {
        ITextDiffModel iTextDiffModel = (ITextDiffModel)iDiffModel;
        this.tdDoc = iTextDiffModel.deltaDoc();
        assert (this.tdDoc != null);
        this.createPatch(iTextDiffModel, this.writer);
        IProgressMonitor iProgressMonitor = this.config.monitor;
        iProgressMonitor.worked(1);
    }
}

