/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.internal.reports.HtmlReporter;
import com.deltawalker.script.Role;
import com.deltawalker.ui.IDiffSummary;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TextHtmlReporter
extends HtmlReporter {
    public TextHtmlReporter(TagReportConfig tagReportConfig, List<IDiffModel> list, String string) throws NullPointerException {
        super(tagReportConfig, list, string);
    }

    @Override
    protected void reportModel(IDiffModel iDiffModel) throws Exception {
        ITextDiffModel iTextDiffModel = (ITextDiffModel)iDiffModel;
        IDiffSummary iDiffSummary = iTextDiffModel.summary();
        while (iDiffSummary != null) {
            this.reportSummary(iDiffSummary);
            iDiffSummary = iDiffSummary.nextSummary();
        }
        IProgressMonitor iProgressMonitor = this.config.monitor;
        this.writer.startElementAttr("table", "class", "textComparison");
        List<DiffRange> list = iTextDiffModel.getDeltas(true);
        if (list != null) {
            for (DiffRange diffRange : list) {
                if (iProgressMonitor.isCanceled()) break;
                this.reportDeltaDetail(diffRange, iTextDiffModel);
                iProgressMonitor.worked(1);
            }
        }
        this.writer.endElement("table");
        iProgressMonitor.worked(1);
    }

    @Override
    protected void reportElement(Role role, IDiffNode iDiffNode, String string, String string2, int n) throws Exception {
    }

    @Override
    protected void reportNode(IDiffNode iDiffNode, int n) throws Exception {
    }

    @Override
    protected void reportNodes(IStructDiffModel iStructDiffModel) throws Exception {
        this.writer.textElement("h3", "Details");
        super.reportNodes(iStructDiffModel);
    }
}

