/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.IStructElement;
import com.deltawalker.NullStructElement;
import com.deltawalker.Relation;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.interfaces.IElement;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.internal.ReportConfig;
import com.deltawalker.internal.reports.ReportException;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.ui.IDiffSummary;
import com.deltopia.StringUtil;
import com.deltopia.io.StreamUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Reporter {
    private static final String DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    protected final ReportConfig config;
    private final String filename;
    private FileOutputStream fos;
    private final List<IDiffModel> models;
    private Writer writer;

    protected Reporter(ReportConfig reportConfig, List<IDiffModel> list, String string) throws NullPointerException {
        if (reportConfig == null) {
            throw new NullPointerException("config");
        }
        if (list == null) {
            throw new NullPointerException("models");
        }
        if (string == null) {
            throw new NullPointerException("filename");
        }
        this.config = reportConfig;
        this.models = list;
        this.filename = string;
    }

    protected ReportConfig config() {
        return this.config;
    }

    public String filename() {
        return this.filename;
    }

    protected String formatDate(Date date) throws NullPointerException {
        if (date == null) {
            throw new NullPointerException("date");
        }
        return DATE_FORMATTER.format(date);
    }

    protected final String formatName(IElement iElement, boolean bl) {
        if (bl) {
            IResource iResource = null;
            if (iElement instanceof IResource) {
                iResource = (IResource)iElement;
            } else if (iElement instanceof IDoc) {
                iResource = ((IDoc)iElement).resource();
            }
            if (iResource != null) {
                return iResource.getUri();
            }
        }
        return iElement.getName();
    }

    public final void generateReport() throws IllegalStateException, IOException, ReportException {
        if (this.fos != null) {
            throw new IllegalStateException("Already started");
        }
        this.fos = new FileOutputStream(this.filename);
        try {
            try {
                this.writer = !StringUtil.isEmpty((String)this.config.encoding) ? new OutputStreamWriter((OutputStream)this.fos, this.config.encoding) : new OutputStreamWriter((OutputStream)this.fos, "UTF-8");
                this.writer = new BufferedWriter(this.writer, 262144);
                this.reportModels();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ReportException("Generate report failed", exception);
            }
        }
        finally {
            this.writer.flush();
            StreamUtil.closeSilently((Closeable)this.fos);
            this.writer = null;
            this.fos = null;
        }
    }

    protected void internalReportNode(IDiffNode iDiffNode, IProgressMonitor iProgressMonitor, int n) throws Exception {
        if (iProgressMonitor.isCanceled() || iDiffNode.isFilteredOut()) {
            return;
        }
        this.reportNodeBegin();
        this.reportNode(iDiffNode, n);
        iProgressMonitor.worked(1);
        IDiffNode[] iDiffNodeArray = iDiffNode.getChildren(false);
        ++n;
        if (iDiffNodeArray.length > 0) {
            this.reportChildNodesBegin();
        }
        IDiffNode[] iDiffNodeArray2 = iDiffNodeArray;
        int n2 = iDiffNodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IDiffNode iDiffNode2 = iDiffNodeArray2[n3];
            this.internalReportNode(iDiffNode2, iProgressMonitor, n);
            ++n3;
        }
        if (iDiffNodeArray.length > 0) {
            this.reportChildNodesEnd();
        }
        this.reportNodeEnd();
    }

    protected List<IDiffModel> models() {
        return this.models;
    }

    protected abstract void reportConfig(IDiffModel var1) throws Exception;

    protected abstract void reportElement(Role var1, IDiffNode var2, String var3, String var4, int var5) throws Exception;

    protected void reportEmptyTextRegion(Role role, DiffRange diffRange) throws Exception {
    }

    protected abstract void reportEnd() throws Exception;

    protected void reportModel(IDiffModel iDiffModel) throws Exception {
        IDiffSummary iDiffSummary = iDiffModel.summary();
        while (iDiffSummary != null) {
            this.reportSummary(iDiffSummary);
            iDiffSummary = iDiffSummary.nextSummary();
        }
        IProgressMonitor iProgressMonitor = this.config.monitor;
        if (iDiffModel instanceof IStructDiffModel) {
            this.reportNodes((IStructDiffModel)iDiffModel);
        }
        iProgressMonitor.worked(1);
    }

    private void reportModels() throws Exception {
        IProgressMonitor iProgressMonitor = this.config.monitor;
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        this.reportStart(this.writer);
        boolean bl = false;
        for (IDiffModel iDiffModel : this.models) {
            if (iProgressMonitor.isCanceled()) break;
            if (!bl) {
                this.reportConfig(iDiffModel);
                bl = true;
            }
            this.reportModel(iDiffModel);
        }
        this.reportEnd();
    }

    protected void reportNode(IDiffNode iDiffNode, int n) throws Exception {
        boolean bl = iDiffNode.getParent() == null;
        Set<Role> set = this.config.roles();
        for (Role role : set) {
            if (this.config.monitor.isCanceled()) break;
            IStructElement iStructElement = iDiffNode.getElement(role);
            String string = iStructElement != null && !(iStructElement instanceof NullStructElement) ? this.formatName(iStructElement, bl) : "";
            boolean bl2 = set.size() > 2;
            Relation relation = Relation.fromRole(role, bl2);
            String string2 = "";
            if (relation != null) {
                string2 = Differencer.getDeltaDetailAsString(iDiffNode, relation);
            }
            this.reportElement(role, iDiffNode, string, string2, n);
        }
    }

    protected void reportNodeBegin() throws IOException {
    }

    protected void reportChildNodesBegin() throws IOException {
    }

    protected void reportChildNodesEnd() throws IOException {
    }

    protected void reportNodeEnd() throws IOException {
    }

    protected void reportNodes(IStructDiffModel iStructDiffModel) throws Exception {
        this.internalReportNode(iStructDiffModel.getRoot(), this.config.monitor, 0);
    }

    protected abstract void reportStart(Writer var1) throws Exception;

    protected abstract void reportSummary(IDiffSummary var1) throws Exception;

    protected Writer writer() {
        return this.writer;
    }
}

