/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.Delta;
import com.deltawalker.IStructElement;
import com.deltawalker.NullStructElement;
import com.deltawalker.Relation;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.internal.ReportConfig;
import com.deltawalker.internal.reports.Reporter;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.IDiffSummary;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupReporter
extends Reporter {
    private static final String DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy");
    private static final Logger LOG = LoggerFactory.getLogger(MarkupReporter.class);

    protected MarkupReporter(ReportConfig reportConfig, List<IDiffModel> list, String string) throws NullPointerException {
        super(reportConfig, list, string);
    }

    @Override
    protected ReportConfig config() {
        return this.config;
    }

    protected final String formatColor(RGB rGB) {
        return "rgb(" + rGB.red + ',' + rGB.green + ',' + rGB.blue + ')';
    }

    @Override
    protected String formatDate(Date date) throws NullPointerException {
        if (date == null) {
            throw new NullPointerException("date");
        }
        return DATE_FORMATTER.format(date);
    }

    protected final RGB getColor(DiffRange diffRange, DeltaPart deltaPart) {
        return DeltaColor.getColor(diffRange, deltaPart, false);
    }

    @Override
    protected void internalReportNode(IDiffNode iDiffNode, IProgressMonitor iProgressMonitor, int n) throws Exception {
        if (iDiffNode.isFilteredOut()) {
            return;
        }
        this.reportNode(iDiffNode, n);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        iProgressMonitor.worked(1);
        IDiffNode[] iDiffNodeArray = iDiffNode.getChildren(false);
        ++n;
        IDiffNode[] iDiffNodeArray2 = iDiffNodeArray;
        int n2 = iDiffNodeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IDiffNode iDiffNode2 = iDiffNodeArray2[n3];
            if (iProgressMonitor.isCanceled()) break;
            this.internalReportNode(iDiffNode2, iProgressMonitor, n);
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            ++n3;
        }
    }

    @Override
    protected abstract void reportConfig(IDiffModel var1) throws Exception;

    protected void reportDeltaDetail(DiffRange diffRange, ITextDiffModel iTextDiffModel) throws Exception {
        iTextDiffModel.computeInlineDeltas(diffRange);
        DiffRange[] diffRangeArray = (DiffRange[])diffRange.getChildren();
        if (LOG.isDebugEnabled()) {
            LOG.debug("===== Diff inlines=" + (diffRangeArray != null ? Integer.valueOf(diffRangeArray.length) : "no"));
        }
        Set<Role> set = this.config.roles();
        for (Role role : set) {
            int n;
            IDocument iDocument = iTextDiffModel.deltaDoc().document(role);
            if (iDocument == null) continue;
            Position position = diffRange.position(role);
            if (LOG.isDebugEnabled()) {
                LOG.debug("== " + (Object)((Object)role) + " " + position);
            }
            if (position.length <= 0) {
                this.reportEmptyTextRegion(role, diffRange);
                continue;
            }
            int n2 = iDocument.getLineOfOffset(position.offset);
            if (n2 > (n = iDocument.getLineOfOffset(position.offset + position.length - 1))) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Empty region: " + (Object)((Object)role) + " line=" + n2);
                }
                this.reportEmptyTextRegion(role, diffRange);
                continue;
            }
            this.reportTextRegion(role, diffRange, diffRangeArray, iDocument, n2, n);
        }
    }

    @Override
    protected abstract void reportElement(Role var1, IDiffNode var2, String var3, String var4, int var5) throws Exception;

    @Override
    protected void reportEmptyTextRegion(Role role, DiffRange diffRange) throws Exception {
    }

    @Override
    protected abstract void reportEnd() throws Exception;

    @Override
    protected void reportModel(IDiffModel iDiffModel) throws Exception {
        IDiffSummary iDiffSummary = iDiffModel.summary();
        while (iDiffSummary != null) {
            this.reportSummary(iDiffSummary);
            iDiffSummary = iDiffSummary.nextSummary();
        }
        IProgressMonitor iProgressMonitor = this.config.monitor;
        if (iDiffModel instanceof IStructDiffModel) {
            this.reportNodes((IStructDiffModel)iDiffModel);
        }
        iProgressMonitor.worked(1);
    }

    @Override
    protected void reportNode(IDiffNode iDiffNode, int n) throws Exception {
        boolean bl = iDiffNode.getParent() == null;
        Set<Role> set = this.config.roles();
        for (Role role : set) {
            if (this.config.monitor.isCanceled()) break;
            IStructElement iStructElement = iDiffNode.getElement(role);
            String string = iStructElement != null && !(iStructElement instanceof NullStructElement) ? this.formatName(iStructElement, bl) : "";
            boolean bl2 = set.size() > 2;
            Relation relation = Relation.fromRole(role, bl2);
            String string2 = "";
            if (relation != null) {
                string2 = Differencer.getDeltaDetailAsString(iDiffNode, relation);
            }
            this.reportElement(role, iDiffNode, string, string2, n);
        }
    }

    @Override
    protected void reportNodes(IStructDiffModel iStructDiffModel) throws Exception {
        this.internalReportNode(iStructDiffModel.getRoot(), this.config.monitor, 0);
    }

    @Override
    protected abstract void reportStart(Writer var1) throws Exception;

    @Override
    protected abstract void reportSummary(IDiffSummary var1) throws Exception;

    protected void reportTextElement(String string, DiffRange diffRange) throws Exception {
        if (LOG.isInfoEnabled()) {
            if (diffRange != null) {
                LOG.info("\t\tDiff Part: '" + string + "' " + (Object)((Object)diffRange.getKind(Relation.REF_ONE)));
            } else {
                LOG.info("\t\tPart: '" + string + "'");
            }
        }
    }

    protected void reportTextLine(Role role, int n, int n2, String string, DiffRange diffRange, DiffRange[] diffRangeArray) throws Exception {
        int n3;
        if (LOG.isInfoEnabled()) {
            LOG.info("\tLine " + n + " " + (Object)((Object)role) + ": '" + string + '\'');
        }
        if ((n3 = string.length()) <= 0) {
            return;
        }
        if (diffRangeArray != null && diffRangeArray.length > 0) {
            Object object;
            int n4 = 0;
            DiffRange[] diffRangeArray2 = diffRangeArray;
            int n5 = diffRangeArray.length;
            int n6 = 0;
            while (n6 < n5) {
                object = diffRangeArray2[n6];
                if (((Delta)object).isSame()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("\t\tSkip same inline dif");
                    }
                } else {
                    Position position = ((DiffRange)object).position(role);
                    if (position.length > 0) {
                        String string2;
                        int n7 = Math.min(Math.max(0, position.offset - n2), n3);
                        int n8 = Math.min(Math.max(0, position.offset + position.length - n2), n3);
                        if (n4 < n7 && n7 < n3) {
                            string2 = string.substring(n4, n7);
                            this.reportTextElement(string2, null);
                        }
                        if (n8 > n7) {
                            boolean bl;
                            string2 = string.substring(n7, n8);
                            boolean bl2 = true;
                            boolean bl3 = bl = this.config.roles().size() > 2;
                            if (((Delta)object).isPseudoConflict()) {
                                bl2 = this.config.showPseudo;
                            } else if (bl) {
                                if (!((Delta)object).isSame(Relation.REF_ONE)) {
                                    bl2 = Relation.REF_ONE.contains(role);
                                } else if (!((Delta)object).isSame(Relation.REF_TWO)) {
                                    bl2 = Relation.REF_TWO.contains(role);
                                } else if (((Delta)object).isConflict()) {
                                    bl2 = true;
                                } else {
                                    throw new IllegalStateException("Unknown Delta.Kind: " + object);
                                }
                            }
                            this.reportTextElement(string2, (DiffRange)(bl2 ? object : null));
                            n4 = n8;
                        }
                    }
                }
                ++n6;
            }
            if (n4 < n3) {
                object = string.substring(n4);
                this.reportTextElement((String)object, null);
            }
        } else {
            this.reportTextElement(string, null);
        }
    }

    protected void reportTextRegion(Role role, DiffRange diffRange, DiffRange[] diffRangeArray, IDocument iDocument, int n, int n2) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info("Region: " + (Object)((Object)role) + " lines=" + n + "-" + n2);
        }
        int n3 = n;
        while (n3 <= n2) {
            IRegion iRegion = iDocument.getLineInformation(n3);
            int n4 = iRegion.getOffset();
            String string = iDocument.get(n4, iRegion.getLength());
            this.reportTextLine(role, n3 + 1, n4, string, diffRange, diffRangeArray);
            ++n3;
        }
    }
}

