/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.script.ReportLink;
import java.util.HashMap;
import java.util.Map;

public enum Linked {
    ALL(1, Msg.Reporter_Linked_allFiles),
    DIFFERENT(2, Msg.Reporter_Linked_changedFiles),
    NONE(0, Msg.Reporter_Linked_noFiles),
    SELECTED(3, Msg.Reporter_Linked_selectedFiles);

    private static final Map<Integer, Linked> int2Enum;
    private int intValue;
    private final String text;

    static {
        int2Enum = new HashMap<Integer, Linked>(4);
        Linked[] linkedArray = Linked.values();
        int n = linkedArray.length;
        int n2 = 0;
        while (n2 < n) {
            Linked linked = linkedArray[n2];
            int2Enum.put(linked.intValue, linked);
            ++n2;
        }
    }

    public static Linked fromInt(int n) {
        return int2Enum.get(n);
    }

    public static Linked fromPrefs() {
        int n = PrefUtil.getGlobalPrefs().getInt(PrefKey.D_LINKED_REPORTS.toString());
        return Linked.fromInt(n);
    }

    public static Linked fromScript(ReportLink reportLink) {
        if (reportLink == null) {
            throw new NullPointerException("'link' cannot be null.");
        }
        switch (reportLink) {
            case ALL: {
                return ALL;
            }
            case CHANGED: {
                return DIFFERENT;
            }
            case NONE: {
                return NONE;
            }
        }
        throw new IllegalArgumentException("link");
    }

    private Linked(int n2, String string2) {
        this.intValue = n2;
        this.text = string2;
    }

    public int toInt() {
        return this.intValue;
    }

    public void toPrefs() {
        PrefUtil.getGlobalPrefs().setValue(PrefKey.D_LINKED_REPORTS.toString(), this.intValue);
    }

    public String toString() {
        return this.text;
    }
}

