/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.App;
import com.deltawalker.IStructElement;
import com.deltawalker.NullStructElement;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.internal.reports.HierarchyReporter;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltawalker.ui.IDiffSummary;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.interfaces.IPrincipal;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;

public class JsonReporter
extends HierarchyReporter {
    protected JsonWriter jw;
    protected JsonReader jr;

    public JsonReporter(TagReportConfig tagReportConfig, List<IDiffModel> list, String string) {
        super(tagReportConfig, list, string);
    }

    @Override
    protected void reportConfig(IDiffModel iDiffModel) throws Exception {
        IDiffDoc iDiffDoc = iDiffModel.deltaDoc();
        ((IJsonState)iDiffDoc).toJson(this.jw);
    }

    @Override
    protected void reportElement(Role role, IDiffNode iDiffNode, String string, String string2, int n) throws IOException {
        IResource iResource = (IResource)iDiffNode.getElement(role);
        if (iResource == null) {
            return;
        }
        this.jw.name("el");
        this.jw.beginObject();
        this.jw.name("rl").value((long)role.toInt());
        boolean bl = n == 0;
        this.jw.name("nm").value(this.formatName(iResource, bl));
        this.jw.name("at").value((long)iResource.attributes());
        this.jw.name("sz").value(iResource.getSize());
        this.jw.name("lm").value(iResource.getLastModifiedTime());
        IPrincipal iPrincipal = iResource.getOwner();
        IPrincipal iPrincipal2 = iResource.getGroup();
        if (iPrincipal != null && iPrincipal2 != null) {
            Object object = iPrincipal.getId();
            Object object2 = iPrincipal2.getId();
            if (object instanceof Integer) {
                this.jw.name("ou").value((long)((Integer)object).intValue());
                this.jw.name("og").value((long)((Integer)object2).intValue());
            } else if (object instanceof String) {
                this.jw.name("ou").value(object.toString());
                this.jw.name("og").value(object2.toString());
            } else assert (false);
            this.jw.name("dt").value(iResource.createdTime());
            this.jw.name("lo").value(iResource.lastOpenedTime());
        }
        this.jw.endObject();
    }

    @Override
    protected void reportNode(IDiffNode iDiffNode, int n) throws Exception {
        boolean bl = iDiffNode.getParent() == null;
        Set<Role> set = this.config.roles();
        for (Role role : set) {
            if (this.config.monitor.isCanceled()) break;
            IStructElement iStructElement = iDiffNode.getElement(role);
            String string = iStructElement != null && !(iStructElement instanceof NullStructElement) ? this.formatName(iStructElement, bl) : "";
            this.reportElement(role, iDiffNode, string, "", n);
        }
    }

    @Override
    protected void reportModel(IDiffModel iDiffModel) throws Exception {
        this.jw.name("snapshot");
        this.jw.beginObject();
        this.jw.name("roles");
        this.jw.beginArray();
        for (Role role : this.config.roles()) {
            this.jw.value(role.toString());
        }
        this.jw.endArray();
        super.reportModel(iDiffModel);
        this.jw.endObject();
    }

    @Override
    protected void reportEnd() throws Exception {
        this.jw.endObject();
    }

    @Override
    protected void reportStart(Writer writer) throws Exception {
        this.jw = new JsonWriter(writer);
        this.jw.beginObject();
        this.jw.name("ver").value(App.instance().version());
    }

    @Override
    protected void reportNodeBegin() throws IOException {
        this.jw.name("nd");
        this.jw.beginObject();
    }

    @Override
    protected void reportNodeEnd() throws IOException {
        this.jw.endObject();
    }

    @Override
    protected void reportSummary(IDiffSummary iDiffSummary) throws Exception {
    }
}

