/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.Delta;
import com.deltawalker.DocType;
import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.UriInfo;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.internal.reports.MarkupReporter;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltawalker.ui.IDiffSummary;
import com.deltopia.StringUtil;
import com.deltopia.io.xml.XmlWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.html.HTML;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class HtmlReporter
extends MarkupReporter {
    private static final String CSS = "        /*\n         * The general styles for content including, but not limited to, structure\n         * and text comparison i.e. they set the styles of the titles of the\n         * sections, the descriptive texts outside any of the structure and text\n         * comparison tables, the tables listing the configuration preferences\n         * and the summaries, etc.  \n         */\n\n        body, th, td {\n          font-family: Verdana, Arial, Helvetica, sans-serif;\n          font-size: 70%;\n        }\n        h1 {\n        font-size: 1.3em;\n        }\n        h2 {\n          font-size: 1.1em;\n        }\n        h3 {\n          font-size: 1em;\n        }\n        table {\n          border-collapse: collapse;\n        }\n        table, th, td {\n          border: 1px solid black;\n        }\n        th {\n          background-color: rgb(136,136,136);\n          color: white;\n        }\n        th, td {\n          padding-left: 5px;\n          padding-right: 5px;\n        }\n\n        /*\n         * The styles for the top-level tables displaying the structure and\n         * text comparisons.\n         */\n\n        table.structureComparison {\n          width: 100%;\n        }\n        table.structureComparison td {\n          border: 0 none;\n        }\n        table.textComparison {\n          width: 100%;\n        }\n        table.textComparison td {\n          vertical-align: top;\n        }\n\n        table.textComparison div {\n          white-space: pre-wrap;\n        }\n\n        /*\n         * As the main tables that represent the Details section of the report\n         * have been styled above, the styles for the individual role-specific\n         * cells of structure comparison and the role-specific blocks of text\n         * comparison follow bellow.\n         */\n\n        /*\n         * If the text of the individual cells of the structure comparison trees\n         * is to have a specific font, it should be defined here.\n         */\n        td.structureContent {\n          white-space: nowrap;\n        }\n\n        /* The style of the text in the line-number ruler only. */\n        .ln {\n          width: 40px;\n          float: left;\n          padding-right: 5px;\n        }\n        /* The style of the line-number ruler and the text comparison itself. */\n        img {\n            margin-left: 0px;\n            margin-right: 5px;\n            vertical-align: middle;\n        }\n";
    private static final Logger LOG = LoggerFactory.getLogger((String)"com.deltawalker.internal.report.HtmlReporter");
    private static final String TITLE = "Deltopia DeltaWalker Comparison Report";
    protected final AttributesImpl attrImpl = new AttributesImpl();
    private final Map<RGB, String> rgb2CssClass = new HashMap<RGB, String>();
    protected XmlWriter writer;

    @Override
    protected TagReportConfig config() {
        return (TagReportConfig)super.config();
    }

    public HtmlReporter(TagReportConfig tagReportConfig, List<IDiffModel> list, String string) throws NullPointerException {
        super(tagReportConfig, list, string);
    }

    protected void addColorToElementAttributes(RGB rGB) {
        if (rGB != null) {
            String string = this.rgb2CssClass.get(rGB);
            if (string != null) {
                this.attrImpl.addAttribute(null, null, HTML.Attribute.CLASS.toString(), "CDATA", string);
            } else {
                LOG.warn("No cached color for " + rGB);
                String string2 = this.formatColor(rGB);
                this.attrImpl.addAttribute(null, null, HTML.Tag.STYLE.toString(), HTML.Attribute.CLASS.toString(), "background-color: " + string2);
            }
        }
    }

    protected void createTable(boolean bl, String[][] stringArray) throws SAXException {
        this.writer.startElement(HTML.Tag.TABLE.toString());
        String[][] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray3 = stringArray2[n2];
            if (bl) {
                this.tableHeader(stringArray3);
                bl = false;
            } else {
                this.tableRow(stringArray3);
            }
            ++n2;
        }
        this.writer.endElement(HTML.Tag.TABLE.toString());
    }

    private String getDiffColorCss() {
        RGB rGB = DeltaColor.getColor(new Delta(), DeltaPart.BG, false);
        String string = this.formatColor(rGB);
        RGB rGB2 = DeltaColor.rgbForAddition(DeltaPart.BG);
        RGB rGB3 = DeltaColor.rgbForAddition(DeltaPart.FG);
        String string2 = this.formatColor(rGB2);
        String string3 = this.formatColor(rGB3);
        RGB rGB4 = DeltaColor.rgbForDeletion(DeltaPart.BG);
        RGB rGB5 = DeltaColor.rgbForDeletion(DeltaPart.FG);
        String string4 = this.formatColor(rGB4);
        String string5 = this.formatColor(rGB5);
        RGB rGB6 = DeltaColor.rgbForChange(DeltaPart.BG);
        RGB rGB7 = DeltaColor.rgbForChange(DeltaPart.FG);
        String string6 = this.formatColor(rGB6);
        String string7 = this.formatColor(rGB7);
        RGB rGB8 = DeltaColor.rgbForConflict(DeltaPart.BG);
        RGB rGB9 = DeltaColor.rgbForConflict(DeltaPart.FG);
        String string8 = this.formatColor(rGB8);
        String string9 = this.formatColor(rGB9);
        this.rgb2CssClass.put(rGB, "sm");
        this.rgb2CssClass.put(rGB2, "ad");
        this.rgb2CssClass.put(rGB3, "adf");
        this.rgb2CssClass.put(rGB4, "dl");
        this.rgb2CssClass.put(rGB5, "dlf");
        this.rgb2CssClass.put(rGB6, "df");
        this.rgb2CssClass.put(rGB7, "dff");
        this.rgb2CssClass.put(rGB8, "ct");
        this.rgb2CssClass.put(rGB9, "ctf");
        String string10 = "                .sm {\n          background-color: " + string + ";\n" + "        }\n" + "        .ad {\n" + "          background-color: " + string2 + ";\n" + "        }\n" + "        .adf {\n" + "          background-color: " + string3 + ";\n" + "        }\n" + "        .dl {\n" + "          background-color: " + string4 + ";\n" + "        }\n" + "        .dlf {\n" + "          background-color: " + string5 + ";\n" + "        }\n" + "        .df {\n" + "          background-color: " + string6 + ";\n" + "        }\n" + "        .dff {\n" + "          background-color: " + string7 + ";\n" + "        }\n" + "        .ct {\n" + "          background-color: " + string8 + ";\n" + "        }\n" + "        .ctf {\n" + "          background-color: " + string9 + ";\n" + "        }\n";
        return string10;
    }

    protected String getIndentCss() {
        return "";
    }

    private String getTextTableCss() {
        boolean bl = this.config.roles().size() > 2;
        String string = "        table.textComparison td {\n          border: 0 none;\n          font-family: monospace;\n          font-size: 11px;\n          width: " + (bl ? "33%" : "50%") + ";\n" + "        }\n";
        return string;
    }

    private void link(String string, String string2) throws SAXException {
        this.writer.textElement(HTML.Tag.A.toString(), HTML.Attribute.HREF.toString(), string, string2);
    }

    @Override
    protected void reportConfig(IDiffModel iDiffModel) throws Exception {
        Object object;
        Role role2;
        this.writer.textElement(HTML.Tag.H2.toString(), "Compared");
        Set<Role> set = Relation.roles(iDiffModel.isThreeWay());
        String[][] stringArray = new String[set.size() + 1][2];
        int n = 0;
        stringArray[n][0] = this.resourceDisplayName();
        stringArray[n][1] = Msg.HtmlReporter_path;
        IDiffDoc iDiffDoc = iDiffModel.deltaDoc();
        for (Role role2 : set) {
            stringArray[++n][0] = role2.getDisplayName(iDiffModel.isThreeWay());
            object = iDiffDoc.uriInfo(role2);
            stringArray[n][1] = ((UriInfo)object).uri();
        }
        this.createTable(true, stringArray);
        this.writer.textElement(HTML.Tag.H2.toString(), Msg.HtmlReporter_prefs);
        role2 = iDiffModel.deltaDoc().preferences();
        Boolean bl = role2.getBoolean(PrefKey.C_IGNORE_CHAR_CASE.toString());
        object = role2.getBoolean(PrefKey.C_IGNORE_LINE_ENDINGS.toString());
        Boolean bl2 = role2.getBoolean(PrefKey.C_IGNORE_WHITESPACE.toString());
        Boolean bl3 = role2.getBoolean(PrefKey.T_DO_INLINE_DELTAS.toString());
        this.createTable(false, new String[][]{{Msg.TextPrefPage_ignoreWhitespace, bl2.toString()}, {Msg.TextPrefPage_ignoreCharCase, bl.toString()}, {Msg.TextPrefPage_ignoreLineEndings, ((Boolean)object).toString()}, {Msg.TextPrefPage_showInlineDiffs, bl3.toString()}});
        this.reportFilters(iDiffModel);
    }

    @Override
    protected void reportDeltaDetail(DiffRange diffRange, ITextDiffModel iTextDiffModel) throws Exception {
        this.writer.startElement(HTML.Tag.TR.toString());
        super.reportDeltaDetail(diffRange, iTextDiffModel);
        this.writer.endElement(HTML.Tag.TR.toString());
        if (LOG.isInfoEnabled()) {
            this.writer.characters("\n");
        }
    }

    @Override
    protected void reportModel(IDiffModel iDiffModel) throws Exception {
        this.writer.textElement(HTML.Tag.H2.toString(), "Comparison");
        this.writer.textElement(HTML.Tag.H3.toString(), "Summaries");
        super.reportModel(iDiffModel);
    }

    @Override
    protected void reportEmptyTextRegion(Role role, DiffRange diffRange) throws Exception {
        super.reportEmptyTextRegion(role, diffRange);
        RGB rGB = DeltaColor.getColor(diffRange, DeltaPart.BG, false);
        this.addColorToElementAttributes(rGB);
        this.writer.emptyElement(HTML.Tag.TD.toString(), (Attributes)this.attrImpl);
    }

    @Override
    protected void reportEnd() throws Exception {
        this.writer.endElement(HTML.Tag.BODY.toString());
        this.writer.endElement(HTML.Tag.HTML.toString());
    }

    protected void reportFilters(IDiffModel iDiffModel) throws Exception {
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        List<IFilter> list = iDiffModel.filters().getAllAsList();
        boolean bl = true;
        for (IFilter object2 : list) {
            if (!object2.isEnabled() || object2.docType() != DocType.TEXT) continue;
            if (bl) {
                linkedList.add(object2.toStringArray(bl));
                bl = false;
            }
            linkedList.add(object2.toStringArray(bl));
        }
        this.writer.textElement(HTML.Tag.H2.toString(), Msg.HtmlReporter_textFilters);
        if (!linkedList.isEmpty()) {
            String[][] stringArray = (String[][])linkedList.toArray((T[])new String[linkedList.size()][]);
            this.createTable(true, stringArray);
        } else {
            this.writer.textElement(HTML.Tag.P.toString(), Msg.HtmlReporter_noTextFilters);
        }
        this.writer.textElement(HTML.Tag.H2.toString(), Msg.HtmlReporter_folderFilters);
        bl = true;
        linkedList.clear();
        for (IFilter iFilter : list) {
            if (!iFilter.isEnabled() || iFilter.docType() != DocType.FOLDER) continue;
            if (bl) {
                linkedList.add(iFilter.toStringArray(bl));
                bl = false;
            }
            linkedList.add(iFilter.toStringArray(bl));
        }
        if (!linkedList.isEmpty()) {
            String[][] stringArray = (String[][])linkedList.toArray((T[])new String[linkedList.size()][]);
            this.createTable(true, stringArray);
        } else {
            this.writer.textElement(HTML.Tag.P.toString(), Msg.HtmlReporter_noFolderFilters);
        }
    }

    @Override
    protected void reportStart(Writer writer) throws Exception {
        this.writer = new XmlWriter(writer, false, 0);
        this.writer.startElement(HTML.Tag.HTML.toString());
        this.writer.startElement(HTML.Tag.HEAD.toString());
        this.writer.emptyElementAttr("meta", "http-equiv", "Content-Type", "content", "text/html; charset=UTF-8");
        this.writer.startElementAttr(HTML.Tag.STYLE.toString(), "type", "text/css");
        String string = CSS + this.getTextTableCss() + this.getDiffColorCss() + this.getIndentCss();
        this.writer.characters(string);
        this.writer.endElement(HTML.Tag.STYLE.toString());
        this.writer.textElement(HTML.Tag.TITLE.toString(), TITLE);
        this.writer.endElement(HTML.Tag.HEAD.toString());
        this.writer.startElement(HTML.Tag.BODY.toString());
        this.writer.textElement(HTML.Tag.H1.toString(), TITLE);
        this.writer.startElement(HTML.Tag.P.toString());
        this.writer.characters("Produced by ");
        this.writer.textElement(HTML.Tag.STRONG.toString(), "Deltopia DeltaWalker");
        this.writer.characters(" on ");
        this.writer.textElement(HTML.Tag.STRONG.toString(), this.formatDate(new Date()));
        this.writer.characters(". See ");
        this.link("http://www.deltawalker.com", "www.deltawalker.com");
        this.writer.characters(" for information about DeltaWalker.");
        this.writer.endElement(HTML.Tag.P.toString());
    }

    @Override
    protected void reportSummary(IDiffSummary iDiffSummary) throws Exception {
        String string = iDiffSummary.description();
        if (!StringUtil.isEmpty((String)string)) {
            this.writer.textElement(HTML.Tag.H4.toString(), string);
        }
        this.createTable(true, iDiffSummary.tableData());
        this.writer.emptyElement(HTML.Tag.P.toString(), null);
    }

    @Override
    protected void reportTextElement(String string, DiffRange diffRange) throws Exception {
        super.reportTextElement(string, diffRange);
        if (diffRange != null) {
            RGB rGB = this.getColor(diffRange, DeltaPart.FG);
            this.attrImpl.clear();
            this.addColorToElementAttributes(rGB);
            this.writer.startElement(HTML.Tag.SPAN.toString(), (Attributes)this.attrImpl);
            this.writer.characters(string);
            this.writer.endElement(HTML.Tag.SPAN.toString());
        } else {
            this.writer.characters(string);
        }
    }

    @Override
    protected void reportTextLine(Role role, int n, int n2, String string, DiffRange diffRange, DiffRange[] diffRangeArray) throws Exception {
        this.writer.startElement(HTML.Tag.DIV.toString());
        this.writer.textElement(HTML.Tag.SPAN.toString(), HTML.Attribute.CLASS.toString(), "ln", String.valueOf(n));
        super.reportTextLine(role, n, n2, string, diffRange, diffRangeArray);
        if (string.length() <= 0) {
            this.writer.characters(" ");
        }
        this.writer.endElement(HTML.Tag.DIV.toString());
        if (LOG.isInfoEnabled()) {
            this.writer.characters("\n");
        }
    }

    @Override
    protected void reportTextRegion(Role role, DiffRange diffRange, DiffRange[] diffRangeArray, IDocument iDocument, int n, int n2) throws Exception {
        this.attrImpl.clear();
        RGB rGB = DeltaColor.getColor(diffRange, DeltaPart.BG, false);
        this.addColorToElementAttributes(rGB);
        this.writer.startElement(HTML.Tag.TD.toString(), (Attributes)this.attrImpl);
        super.reportTextRegion(role, diffRange, diffRangeArray, iDocument, n, n2);
        this.writer.endElement(HTML.Tag.TD.toString());
    }

    protected String resourceDisplayName() {
        return "File";
    }

    private void tableHeader(String[] stringArray) throws SAXException {
        this.writer.startElement(HTML.Tag.TR.toString());
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.writer.textElement(HTML.Tag.TH.toString(), string);
            ++n2;
        }
        this.writer.endElement(HTML.Tag.TR.toString());
    }

    private void tableRow(String[] stringArray) throws SAXException {
        this.writer.startElement(HTML.Tag.TR.toString());
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.writer.textElement(HTML.Tag.TD.toString(), string);
            ++n2;
        }
        this.writer.endElement(HTML.Tag.TR.toString());
    }
}

