/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.reports;

import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.StructProperty;
import com.deltawalker.differencer.Differencer;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IStructDiffModel;
import com.deltawalker.interfaces.ITextDiffModel;
import com.deltawalker.internal.TagReportConfig;
import com.deltawalker.internal.reports.HtmlReporter;
import com.deltawalker.internal.reports.Linked;
import com.deltawalker.internal.reports.ReportException;
import com.deltawalker.internal.reports.ReportUtil;
import com.deltawalker.internal.reports.TextHtmlReporter;
import com.deltawalker.resources.AbstractResource;
import com.deltawalker.script.Role;
import com.deltawalker.ui.DeltaColor;
import com.deltawalker.ui.DeltaPart;
import com.deltopia.io.FileUtil;
import java.io.File;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.html.HTML;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class FolderHtmlReporter
extends HtmlReporter {
    private static final Logger LOG = LoggerFactory.getLogger(FolderHtmlReporter.class);
    private static final int MAX_LEVEL_CLASS_INDENT = 20;
    private static final String PREFIX_CLASS_INDENT = "i";
    private long bbbThreshold;
    private final File folder;
    private final Map<Image, String> img2File = new HashMap<Image, String>();
    private final int indent;
    private int linkedReportCount = 0;
    private String linkedReportPath = null;
    private final boolean showIcons;

    public FolderHtmlReporter(TagReportConfig tagReportConfig, List<IDiffModel> list, String string, boolean bl) throws NullPointerException {
        super(tagReportConfig, list, string);
        this.showIcons = bl;
        this.indent = bl ? 8 : 16;
        File file = new File(string).getParentFile();
        String string2 = String.valueOf(FileUtil.getFileName((String)string, (boolean)false)) + "_files";
        this.folder = new File(file, string2);
    }

    private String generateLinkedReport(IDiffNode iDiffNode) throws Exception {
        Linked linked = this.config().linked;
        ITextDiffModel iTextDiffModel = null;
        if (linked == Linked.ALL || linked == Linked.DIFFERENT || linked == Linked.SELECTED && iDiffNode.isSelected()) {
            iTextDiffModel = iDiffNode.createTextDiffModel();
        }
        if (iTextDiffModel == null) {
            return null;
        }
        if (this.config().linked == Linked.DIFFERENT) {
            List<DiffRange> list = iTextDiffModel.getDeltas(true);
            boolean bl = true;
            for (DiffRange object2 : list) {
                if (object2.isSame()) continue;
                bl = false;
                break;
            }
            if (bl) {
                return null;
            }
        }
        int n = this.linkedReportCount++;
        String string = String.valueOf(n) + "." + this.config().extension.toString();
        File file = new File(this.folder, string);
        if (LOG.isInfoEnabled()) {
            LOG.info("Creating child report in file: " + file);
        }
        TextHtmlReporter textHtmlReporter = new TextHtmlReporter(this.config(), Arrays.asList(iTextDiffModel), file.getPath());
        textHtmlReporter.generateReport();
        return String.valueOf(this.folder.getName()) + '/' + file.getName();
    }

    private String getImageName(Image image) throws ReportException {
        String string = this.img2File.get(image);
        if (string == null) {
            string = String.valueOf(this.img2File.size()) + ".png";
            this.img2File.put(image, string);
        }
        return string;
    }

    @Override
    protected String getIndentCss() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        while (n <= 20) {
            stringBuilder.append("        .").append(PREFIX_CLASS_INDENT).append(n).append(" { ");
            stringBuilder.append("margin-left: ").append(n * this.indent).append("px;}\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    private void reportDiffs(Role role, String string) throws Exception {
        boolean bl = this.config.roles().size() > 2;
        Role role2 = Relation.lastRole(bl);
        if (role != role2) {
            this.writer.textElement(HTML.Tag.TD.toString(), string, (Attributes)this.attrImpl);
        }
    }

    @Override
    protected void reportElement(Role role, IDiffNode iDiffNode, String string, String string2, int n) throws Exception {
        this.attrImpl.clear();
        RGB rGB = DeltaColor.getColor(role, iDiffNode, DeltaPart.BG);
        this.addColorToElementAttributes(rGB);
        this.reportName(role, iDiffNode, string, n);
        this.attrImpl.clear();
        this.addColorToElementAttributes(rGB);
        for (StructProperty structProperty : AbstractResource.umPROPS) {
            if (structProperty == StructProperty.NAME || !this.config().isTreeColumnVisible(structProperty)) continue;
            this.reportProperty(role, iDiffNode, structProperty);
        }
        this.reportDiffs(role, string2);
    }

    @Override
    protected void reportEnd() throws Exception {
        super.reportEnd();
        if (this.showIcons) {
            this.writeImages();
        }
    }

    private void reportName(Role role, IDiffNode iDiffNode, String string, int n) throws Exception {
        Image image;
        this.writer.startElement(HTML.Tag.TD.toString(), (Attributes)this.attrImpl);
        this.attrImpl.clear();
        if (n > 0) {
            if (n > 20) {
                this.attrImpl.addAttribute(null, null, HTML.Tag.STYLE.toString(), "CDATA", "margin-left: " + n * this.indent + "px;");
            } else {
                this.attrImpl.addAttribute(null, null, HTML.Attribute.CLASS.toString(), "CDATA", PREFIX_CLASS_INDENT + n);
            }
        }
        IDiffDoc iDiffDoc = iDiffNode.model().deltaDoc();
        Image image2 = image = this.showIcons ? iDiffNode.image(role) : null;
        if (image != null) {
            if (iDiffNode.isSame()) {
                image = iDiffDoc.dimImage(image);
            }
            String string2 = String.valueOf(this.folder.getName()) + "/" + this.getImageName(image);
            this.attrImpl.addAttribute(null, null, HTML.Attribute.SRC.toString(), "CDATA", string2);
            this.writer.emptyElement(HTML.Tag.IMG.toString(), (Attributes)this.attrImpl);
        } else if (this.attrImpl.getLength() > 0) {
            this.writer.emptyElement(HTML.Tag.SPAN.toString(), (Attributes)this.attrImpl);
        }
        if (this.linkedReportPath != null) {
            this.writer.textElement(HTML.Tag.A.toString(), HTML.Attribute.HREF.toString(), this.linkedReportPath, string);
        } else {
            this.writer.characters(string);
        }
        this.writer.endElement(HTML.Tag.TD.toString());
    }

    @Override
    protected void reportNode(IDiffNode iDiffNode, int n) throws Exception {
        if (!ReportUtil.shouldCompareByteByByte(iDiffNode, this.bbbThreshold)) {
            this.linkedReportPath = this.generateLinkedReport(iDiffNode);
        }
        this.writer.startElement(HTML.Tag.TR.toString());
        super.reportNode(iDiffNode, n);
        this.writer.endElement(HTML.Tag.TR.toString());
        this.linkedReportPath = null;
    }

    @Override
    protected void reportNodes(IStructDiffModel iStructDiffModel) throws Exception {
        this.bbbThreshold = 1024L * (long)iStructDiffModel.deltaDoc().preferences().getInt(PrefKey.D_COMP_BBB_THRESHOLD.toString());
        this.writer.textElement(HTML.Tag.H3.toString(), "Details");
        this.writer.startElementAttr(HTML.Tag.TABLE.toString(), HTML.Attribute.CLASS.toString(), "structureComparison");
        super.reportNodes(iStructDiffModel);
        this.writer.endElement(HTML.Tag.TABLE.toString());
    }

    private void reportProperty(Role role, IDiffNode iDiffNode, StructProperty structProperty) throws Exception {
        String string = Differencer.getPropertyValueAsString(iDiffNode.getElement(role), structProperty);
        this.writer.textElement(HTML.Tag.TD.toString(), string, (Attributes)this.attrImpl);
    }

    @Override
    protected void reportStart(Writer writer) throws Exception {
        if (this.showIcons && !this.folder.isDirectory() && !this.folder.mkdir() && this.folder.isDirectory()) {
            throw new ReportException("Coudn''t create directory " + this.folder);
        }
        super.reportStart(writer);
    }

    @Override
    protected String resourceDisplayName() {
        return "Folder";
    }

    private void writeImages() {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[1];
        boolean bl = LOG.isDebugEnabled();
        for (Map.Entry<Image, String> entry : this.img2File.entrySet()) {
            Object object;
            boolean bl2;
            Image image = entry.getKey();
            ImageData imageData = image.getImageData();
            boolean bl3 = bl2 = imageData.alphaData == null || imageData.alphaData.length >= imageData.width * imageData.height;
            if (imageData.width != 16 && imageData.height != 16) {
                if (bl2) {
                    imageData = imageData.scaledTo(16, 16);
                } else {
                    object = imageData.alphaData;
                    imageData.alphaData = null;
                    imageData = imageData.scaledTo(16, 16);
                    if (object != null) {
                        if (((Object)object).length == 256) {
                            imageData.alphaData = (byte[])object;
                        } else {
                            LOG.warn("Lost alpha after scale for image: " + entry);
                        }
                    }
                }
            }
            imageLoader.data[0] = imageData;
            object = new File(this.folder, entry.getValue());
            imageLoader.save(((File)object).getPath(), 5);
            if (!bl) continue;
            LOG.debug("Save image " + ((File)object).getName() + ": " + imageData.width + "x" + imageData.height + "  " + image.getBounds());
        }
    }
}

