/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.content;

public class MagicNumber {
    private byte[] mgBytes;
    private int minLength;
    private int offset = 0;

    public MagicNumber(byte ... byArray) {
        this(byArray, 0);
    }

    public MagicNumber(byte[] byArray, int n) {
        if (byArray == null) {
            throw new IllegalArgumentException("magicBytes");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        this.mgBytes = byArray;
        this.offset = n;
        this.minLength = byArray.length + n;
    }

    public MagicNumber(int ... nArray) {
        this(nArray, 0);
    }

    public MagicNumber(int[] nArray, int n) {
        if (nArray == null) {
            throw new IllegalArgumentException("magicBytes");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset < 0");
        }
        this.mgBytes = new byte[nArray.length];
        int n2 = 0;
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray2[n4];
            this.mgBytes[n2++] = (byte)n5;
            ++n4;
        }
        this.offset = n;
        this.minLength = this.mgBytes.length + n;
    }

    public byte[] magicBytes() {
        return this.mgBytes;
    }

    public boolean matches(byte[] byArray, int n) {
        if (byArray.length < this.minLength + n) {
            return false;
        }
        int n2 = this.offset + n;
        int n3 = 0;
        while (n3 < this.mgBytes.length) {
            if (this.mgBytes[n3] != byArray[n3 + n2]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public int minLength() {
        return this.minLength;
    }

    public int offset() {
        return this.offset;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray = this.mgBytes;
        int n = this.mgBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            stringBuilder.append(Integer.toHexString(by));
            ++n2;
        }
        return stringBuilder.toString();
    }
}

