/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.content;

import com.deltawalker.App;
import com.deltawalker.ContentTypeEntry;
import com.deltawalker.DocType;
import com.deltawalker.Pre;
import com.deltawalker.Relation;
import com.deltawalker.StateBoss;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IContentTypeBoss;
import com.deltawalker.internal.content.ContentInfo;
import com.deltawalker.internal.content.MagicNumber;
import com.deltawalker.internal.content.MagicString;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.script.Role;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.io.BomDetector;
import com.deltopia.io.BomHeader;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.io.IStreamProvider;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.TextEncoding;
import com.deltopia.util.Const;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContentTypeBoss
extends Enum<ContentTypeBoss>
implements IContentTypeBoss,
IJsonState {
    public static final /* enum */ ContentTypeBoss INSTANCE = new ContentTypeBoss();
    public static final String ENTRIES = "ENTRIES";
    private static final Map<String, ContentTypeEntry> ext2ctEntry;
    private static final Logger LOG;
    private static final String[] OPEN_OFFICE_EXTENSIONS;
    private static final int PLAIN_TEXT_MIN_BYTE_COUNT = 4096;
    private static long TEXT_COMPARE_MAX_FILE_SIZE;
    private ArrayList<ContentInfo> ctInfos;
    private final ListenerList listeners = new ListenerList();
    private int minByteCount;
    private final CharsetDecoder utf8Decoder = Charset.forName("UTF-8").newDecoder();
    private static final /* synthetic */ ContentTypeBoss[] ENUM$VALUES;

    static {
        ENUM$VALUES = new ContentTypeBoss[]{INSTANCE};
        ext2ctEntry = new HashMap<String, ContentTypeEntry>();
        LOG = LoggerFactory.getLogger(ContentTypeBoss.class);
        OPEN_OFFICE_EXTENSIONS = new String[]{"odt", "ott", "sxw", "stw", "ods", "ots", "odp", "otp"};
        TEXT_COMPARE_MAX_FILE_SIZE = 0x6400000L;
        String[] stringArray = OPEN_OFFICE_EXTENSIONS;
        int n = OPEN_OFFICE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ext2ctEntry.put(string, new ContentTypeEntry(string, DocType.OFFICE, "", ContentTypeEntry.Change.ADDED));
            ++n2;
        }
    }

    public static List<String> createExtensions(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            arrayList.add(string);
            ++n2;
        }
        return arrayList;
    }

    public static List<MagicNumber> createMagicNumbers(int ... nArray) {
        return ContentTypeBoss.createMagicNumbers(nArray, 0);
    }

    public static List<MagicNumber> createMagicNumbers(int[] nArray, int n) {
        ArrayList<MagicNumber> arrayList = new ArrayList<MagicNumber>(1);
        arrayList.add(new MagicNumber(nArray, n));
        return arrayList;
    }

    public static List<MagicNumber> createMagicNumbers(String string) {
        return ContentTypeBoss.createMagicNumbers(string, 0);
    }

    public static List<MagicNumber> createMagicNumbers(String string, int n) {
        ArrayList<MagicNumber> arrayList = new ArrayList<MagicNumber>(1);
        try {
            arrayList.add(new MagicNumber(string.getBytes("UTF-8"), n));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.error(null, (Throwable)unsupportedEncodingException);
        }
        return arrayList;
    }

    public static List<MagicString> createMagicStrings(List<MagicNumber> list, String ... stringArray) {
        ArrayList<MagicString> arrayList = new ArrayList<MagicString>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            arrayList.add(new MagicString(string.toCharArray()));
            try {
                byte[] byArray = string.getBytes("UTF-8");
                byte[] byArray2 = BomDetector.findMatchingBOM((byte[])byArray);
                if (byArray2 != null) {
                    int n3 = byArray.length - byArray2.length;
                    byte[] byArray3 = new byte[n3];
                    System.arraycopy(byArray, byArray2.length, byArray3, 0, n3);
                    byArray = byArray3;
                }
                list.add(new MagicNumber(byArray, 0));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOG.error(null, (Throwable)unsupportedEncodingException);
            }
            ++n2;
        }
        return arrayList;
    }

    private ContentTypeBoss() {
        this.initializeContentTypes();
        this.registerUsingTypes();
        this.determineMinArrayLength();
    }

    @Override
    public void addEntry(ContentTypeEntry contentTypeEntry) {
        if (contentTypeEntry == null) {
            throw new NullPointerException("entry");
        }
        this.replaceEntry(null, contentTypeEntry);
    }

    @Override
    public void addListener(IContentTypeBoss.IChangeListener iChangeListener) {
        if (iChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add((Object)iChangeListener);
    }

    private ContentType detect(byte[] byArray, String string, boolean bl) {
        BomHeader bomHeader;
        block16: {
            TextEncoding textEncoding;
            String string2;
            block15: {
                ContentTypeEntry contentTypeEntry;
                if (!StringUtil.isEmpty((String)string) && (contentTypeEntry = ext2ctEntry.get(string)) != null) {
                    return contentTypeEntry.docType().contentType();
                }
                contentTypeEntry = this.detect(byArray, string, false, this.ctInfos);
                if (contentTypeEntry != null && contentTypeEntry.isArchive() && !StringUtil.isEmpty((String)string)) {
                    List<String> list = this.getExtensionsFor(ContentType.IWORK);
                    return list.contains(string) ? ContentType.IWORK : ContentType.ARCHIVE;
                }
                if (contentTypeEntry != null) {
                    return contentTypeEntry;
                }
                string2 = null;
                bomHeader = null;
                textEncoding = null;
                if (byArray != null) {
                    textEncoding = this.detectEncoding(byArray);
                    if (textEncoding != null) {
                        bomHeader = textEncoding.bom();
                    }
                    int n = bomHeader == null ? 0 : bomHeader.length();
                    byte[] byArray2 = byArray;
                    if (n > 0) {
                        int n2 = byArray.length - n;
                        if ((n2 & 1) == 1) {
                            --n2;
                        }
                        byArray2 = new byte[n2];
                        System.arraycopy(byArray, n, byArray2, 0, n2);
                    }
                    if (textEncoding != null) {
                        try {
                            string2 = new String(byArray2, textEncoding.charset());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            if (!LOG.isInfoEnabled()) break block15;
                            LOG.info("UnsupportedEncodingException: Couldn't create string from bytes using " + textEncoding + " charset", (Object)unsupportedEncodingException.getMessage());
                        }
                    }
                }
            }
            if (!StringUtil.isEmpty(string2)) {
                return ContentType.TEXT;
            }
            if (bomHeader != null && textEncoding != null) {
                try {
                    CharsetDecoder charsetDecoder = Charset.forName(textEncoding.charset()).newDecoder();
                    charsetDecoder.decode(ByteBuffer.wrap(byArray));
                    return ContentType.TEXT;
                }
                catch (CharacterCodingException characterCodingException) {
                    if (!LOG.isInfoEnabled()) break block16;
                    LOG.info("The CharsetDecoder found a symbol not present in the specified charset" + textEncoding + " charset", (Object)characterCodingException.getMessage());
                }
            }
        }
        if (bomHeader == null && (!this.hasNonUtf8Chars(byArray) || this.isReadableAscii(byArray))) {
            return ContentType.TEXT;
        }
        return ContentType.UNKNOWN;
    }

    private ContentType detect(byte[] byArray, String string, boolean bl, List<ContentInfo> list) {
        if (byArray != null) {
            for (ContentInfo contentInfo : list) {
                if (!contentInfo.matches(byArray, string)) continue;
                List<ContentInfo> list2 = contentInfo.usingTypes();
                ContentType contentType = this.detect(byArray, string, true, list2);
                return contentType == null ? contentInfo.type() : contentType;
            }
        }
        if (bl) {
            for (ContentInfo contentInfo : list) {
                if (!contentInfo.containsExtension(string)) continue;
                return contentInfo.type();
            }
        }
        return null;
    }

    private TextEncoding detectEncoding(byte[] byArray) {
        assert (byArray != null && byArray.length > 0);
        TextEncoding textEncoding = null;
        if (byArray != null && byArray.length > 0) {
            BomHeader bomHeader = BomDetector.getBomHeader((byte[])byArray);
            if (bomHeader == null) {
                String string;
                block9: {
                    string = null;
                    try {
                        this.utf8Decoder.decode(ByteBuffer.wrap(byArray));
                        string = "UTF-8";
                    }
                    catch (CharacterCodingException characterCodingException) {
                        CharsetDetector charsetDetector = new CharsetDetector();
                        charsetDetector.setText(byArray);
                        CharsetMatch charsetMatch = charsetDetector.detect();
                        if (charsetMatch == null) break block9;
                        int n = charsetMatch.getConfidence();
                        if (n >= 50) {
                            string = charsetMatch.getName();
                        }
                        if (!LOG.isInfoEnabled()) break block9;
                        LOG.info("charset: " + string + "   confidence: " + charsetMatch.getConfidence());
                    }
                }
                if (!StringUtil.isEmpty((String)string)) {
                    textEncoding = TextEncoding.fromCharset((String)string);
                }
            } else {
                textEncoding = TextEncoding.fromBomHeader((BomHeader)bomHeader);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Detect text encoding: " + textEncoding);
        }
        return textEncoding;
    }

    @Override
    public TextEncoding detectEncoding(InputStream inputStream, long l) throws IOException {
        return this.detectEncoding(this.readFirstBytes(inputStream, l));
    }

    @Override
    public TextEncoding detectEncoding(IResource iResource) throws IOException {
        if (iResource instanceof IStreamProvider) {
            TextEncoding textEncoding;
            InputStream inputStream = null;
            try {
                inputStream = ((IStreamProvider)iResource).createInputStream(false);
                textEncoding = this.detectEncoding(inputStream, iResource.getSize());
            }
            catch (Throwable throwable) {
                StreamUtil.closeSilently(inputStream);
                throw throwable;
            }
            StreamUtil.closeSilently((Closeable)inputStream);
            return textEncoding;
        }
        return null;
    }

    @Override
    public ContentType detectType(InputStream inputStream, String string, long l) throws IOException {
        return this.detectType(inputStream, string, l, false);
    }

    @Override
    public ContentType detectType(InputStream inputStream, String string, long l, boolean bl) throws IOException {
        byte[] byArray = this.readFirstBytes(inputStream, l);
        if (byArray.length == 0) {
            return ContentType.UNKNOWN;
        }
        ContentType contentType = this.detect(byArray, string, false);
        if (contentType.isUnknown()) {
            contentType = this.detect(byArray, string, true);
        }
        if (!contentType.isUnknown()) {
            if (!bl && l > TEXT_COMPARE_MAX_FILE_SIZE && contentType.isText(false)) {
                contentType = ContentType.BINARY;
            }
            if (!bl && contentType.isImage()) {
                return ContentType.BINARY;
            }
            return contentType;
        }
        return ContentType.BINARY;
    }

    @Override
    public ContentType detectType(IResource iResource) throws IOException {
        return this.detectType(iResource, true);
    }

    @Override
    public ContentType detectType(IResource iResource, boolean bl) throws IOException {
        if (iResource instanceof IStreamProvider) {
            InputStream inputStream = ((IStreamProvider)iResource).createInputStream(false);
            try {
                ContentType contentType = this.detectType(inputStream, iResource.getExtension(), iResource.getSize(), bl);
                return contentType;
            }
            finally {
                StreamUtil.closeSilently((Closeable)inputStream);
            }
        }
        return ContentType.FOLDER;
    }

    @Override
    public ContentType detectType(Map<Role, UriInfo> map, FileType fileType) {
        ContentType contentType = UriInfoUtil.guessContentType(map);
        if (!contentType.isUnknown()) {
            return contentType;
        }
        if (fileType == null) {
            fileType = UriInfoUtil.guessFileType(map);
        }
        contentType = ContentType.TEXT;
        if (fileType == FileType.FOLDER) {
            contentType = ContentType.FOLDER;
        } else {
            Set<Role> set = Relation.roles(false);
            for (Role role : set) {
                UriInfo uriInfo = map.get((Object)role);
                if (uriInfo.isEmpty()) continue;
                try {
                    ContentType contentType2 = this.detectType(uriInfo);
                    map.put(role, uriInfo.cloneUpdateContentType(contentType2));
                    return contentType2;
                }
                catch (IOException iOException) {
                    map.put(role, map.get((Object)role).cloneUpdateError(iOException));
                }
            }
        }
        return contentType;
    }

    @Override
    public ContentType detectType(UriInfo uriInfo) throws IOException {
        ContentType contentType = uriInfo.contentType();
        if (!contentType.isUnknown()) {
            return contentType;
        }
        contentType = this.detectType(ResourceFactory.staticCreateResource(uriInfo, false, false));
        return contentType;
    }

    private void determineMinArrayLength() {
        this.minByteCount = 4096;
        for (ContentInfo contentInfo : this.ctInfos) {
            List<MagicNumber> list = contentInfo.magicNumbers();
            for (MagicNumber magicNumber : list) {
                this.minByteCount = Math.max(this.minByteCount, magicNumber.minLength());
            }
            List<MagicString> object2 = contentInfo.magicStrings();
            for (Object object : object2) {
                this.minByteCount = Math.max(this.minByteCount, ((MagicString)object).minLength() * 2 + 2);
            }
        }
    }

    protected void fireChanged() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            ((IContentTypeBoss.IChangeListener)object).changed();
            ++n2;
        }
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
        this.restoreDefaults();
        if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
        }
        while (jsonReader.hasNext()) {
            this.readEntry(jsonReader);
        }
        if (jsonReader.peek() == JsonToken.END_ARRAY) {
            jsonReader.endArray();
        }
    }

    @Override
    public int getBOMLength(InputStream inputStream, long l) {
        if (l == 0L) {
            return 0;
        }
        byte[] byArray = null;
        try {
            byte[] byArray2 = this.readFirstBytes(inputStream, l);
            byArray = BomDetector.findMatchingBOM((byte[])byArray2);
        }
        catch (IOException iOException) {
            LOG.error("Cannot get BOM length", (Throwable)iOException);
        }
        return byArray != null ? byArray.length : 0;
    }

    public List<String> getExtensionsFor(ContentType contentType) {
        return this.getExtensionsFor(contentType, this.ctInfos);
    }

    private List<String> getExtensionsFor(ContentType contentType, List<ContentInfo> list) {
        assert (contentType != null);
        for (ContentInfo contentInfo : list) {
            if (contentInfo.type() == contentType) {
                return contentInfo.extensions();
            }
            List<String> list2 = this.getExtensionsFor(contentType, contentInfo.usingTypes());
            if (list2 == null) continue;
            return list2;
        }
        return null;
    }

    private boolean hasNonUtf8Chars(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        try {
            this.utf8Decoder.decode(ByteBuffer.wrap(byArray));
            return false;
        }
        catch (CharacterCodingException characterCodingException) {
            return true;
        }
    }

    private void initializeContentTypes() {
        this.ctInfos = new ArrayList();
        this.ctInfos.add(new ContentInfo(ContentType.ARCHIVE_ZIP, ContentTypeBoss.createExtensions("zip", "jar", "war", "ear", "air"), ContentTypeBoss.createMagicNumbers("PK")));
        this.ctInfos.add(new ContentInfo(ContentType.ARCHIVE_GZ, ContentTypeBoss.createExtensions("gz, tgz"), ContentTypeBoss.createMagicNumbers(31, 139, 8)));
        this.ctInfos.add(new ContentInfo(ContentType.ARCHIVE_BZ2, ContentTypeBoss.createExtensions("bz2", "tbz2"), ContentTypeBoss.createMagicNumbers(66, 90, 104, 57, 49)));
        this.ctInfos.add(new ContentInfo(ContentType.ARCHIVE_TAR, ContentTypeBoss.createExtensions("tar"), ContentTypeBoss.createMagicNumbers("ustar", 257)));
        ArrayList<MagicNumber> arrayList = new ArrayList<MagicNumber>();
        this.ctInfos.add(new ContentInfo(ContentType.TEXT_HTML, ContentTypeBoss.createExtensions("html", "htm", "htc", "shtml", "jsp", "jspf", "php", "asp", "xhtml"), arrayList, ContentTypeBoss.createMagicStrings(arrayList, "<html", "<head", "<body", "<!doctype html", "<!", "<title", "<h1"), null, true, false));
        arrayList = new ArrayList();
        this.ctInfos.add(new ContentInfo(ContentType.TEXT_XML, ContentTypeBoss.createExtensions("xml", "xsl", "xslt", "wml", "svg"), arrayList, ContentTypeBoss.createMagicStrings(arrayList, "<?xml")));
        this.ctInfos.add(new ContentInfo(ContentType.OFFICE, ContentTypeBoss.createExtensions("doc", "dot", "xls", "xlt", "ppt", "pot"), ContentTypeBoss.createMagicNumbers(208, 207, 17, 224, 161, 177, 26, 225, 0, 0, 0, 0, 0, 0, 0, 0), Collections.emptyList(), null, false, true));
        this.ctInfos.add(new ContentInfo(ContentType.OFFICE2007, ContentTypeBoss.createExtensions("docx", "dotx", "xlsx", "xltx", "pptx", "potx"), ContentType.ARCHIVE_ZIP));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PNG, ContentTypeBoss.createExtensions("png"), ContentTypeBoss.createMagicNumbers(137, 80, 78, 71, 13, 10, 26)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_BMP, ContentTypeBoss.createExtensions("bmp"), ContentTypeBoss.createMagicNumbers("BM")));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_GIF, ContentTypeBoss.createExtensions("gif"), ContentTypeBoss.createMagicNumbers("GIF8")));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_JPEG, ContentTypeBoss.createExtensions("jpg", "jpeg", "jpe", "jif", "jfif", "jfi"), ContentTypeBoss.createMagicNumbers(255, 216, 255)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_J2K, ContentTypeBoss.createExtensions("jpg", "jp2", "j2k", "jpf", "jpx", "jpm", "mj2"), ContentTypeBoss.createMagicNumbers(255, 216)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_TIFF, ContentTypeBoss.createExtensions("tif", "tiff"), ContentTypeBoss.createMagicNumbers(73, 32, 73)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_TIFF, ContentTypeBoss.createExtensions("tif", "tiff"), ContentTypeBoss.createMagicNumbers(73, 73, 42, 0)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_TIFF, ContentTypeBoss.createExtensions("tif", "tiff"), ContentTypeBoss.createMagicNumbers(77, 77, 0, 42)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_TIFF, ContentTypeBoss.createExtensions("tif", "tiff"), ContentTypeBoss.createMagicNumbers(77, 77, 0, 43)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_ICO, ContentTypeBoss.createExtensions("ico"), ContentTypeBoss.createMagicNumbers(0, 0, 1, 0)));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PSD, ContentTypeBoss.createExtensions("psd"), ContentTypeBoss.createMagicNumbers("8BPS")));
        arrayList = new ArrayList();
        this.ctInfos.add(new ContentInfo(ContentType.TEXT_RTF, ContentTypeBoss.createExtensions("rtf"), arrayList, ContentTypeBoss.createMagicStrings(arrayList, "{\\rtf")));
        arrayList = new ArrayList();
        this.ctInfos.add(new ContentInfo(ContentType.PDF, ContentTypeBoss.createExtensions("pdf"), arrayList, ContentTypeBoss.createMagicStrings(arrayList, "%PDF")));
        this.ctInfos.add(new ContentInfo(ContentType.IWORK, ContentTypeBoss.createExtensions("pages", "key", "numbers"), ContentTypeBoss.createMagicNumbers(80, 75, 3, 4)));
        String[] stringArray = new String[]{"ppm", "pgm", "pbm", "pnm"};
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PGM, ContentTypeBoss.createExtensions(stringArray), ContentTypeBoss.createMagicNumbers("P1")));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PGM, ContentTypeBoss.createExtensions(stringArray), ContentTypeBoss.createMagicNumbers("P2")));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PGM, ContentTypeBoss.createExtensions(stringArray), ContentTypeBoss.createMagicNumbers("P3")));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PGM, ContentTypeBoss.createExtensions(stringArray), ContentTypeBoss.createMagicNumbers("P4")));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PGM, ContentTypeBoss.createExtensions(stringArray), ContentTypeBoss.createMagicNumbers("P5")));
        this.ctInfos.add(new ContentInfo(ContentType.IMAGE_PGM, ContentTypeBoss.createExtensions(stringArray), ContentTypeBoss.createMagicNumbers("P6")));
        this.ctInfos.add(new ContentInfo(ContentType.TEXT, ContentTypeBoss.createExtensions("txt", "1st", "me", "text", "ans", "asc", "csv", "tsv", "faq", "c", "h", "tex", "latex", "pv", "log", "nt")));
    }

    private boolean isReadableAscii(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (!this.isReadableAscii(byArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isReadableAscii(int n) {
        return n == 9 || n == 10 || n == 13 || n >= 32 && n <= 126;
    }

    protected ArrayList<ContentInfo> mimeInfos() {
        return this.ctInfos;
    }

    private void readEntry(JsonReader jsonReader) throws IOException {
        Object object;
        DocType docType = null;
        String string = null;
        String string2 = null;
        ContentTypeEntry.Change change = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            if (StateBoss.is(Pre.V_21) && ((String)object).equals("tp") || ((String)object).equals("dtp")) {
                docType = DocType.fromString(jsonReader.nextString());
                continue;
            }
            if (((String)object).equals("ext")) {
                string = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("dsc")) {
                string2 = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("cng")) {
                change = ContentTypeEntry.Change.fromString(jsonReader.nextString());
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + (String)object);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        object = ext2ctEntry.get(string);
        ContentTypeEntry contentTypeEntry = null;
        if (change != ContentTypeEntry.Change.DELETED) {
            contentTypeEntry = new ContentTypeEntry(string, docType, string2, change);
        }
        this.replaceEntry((ContentTypeEntry)object, contentTypeEntry, false);
    }

    private byte[] readFirstBytes(InputStream inputStream, long l) throws IOException {
        int n;
        if (inputStream == null) {
            throw new NullPointerException("is");
        }
        if (l < -1L) {
            throw new IllegalArgumentException("Negative file size:" + l);
        }
        int n2 = l == -1L ? 4096 : (int)Math.min((long)this.minByteCount, l);
        if (n2 <= 0) {
            return Const.EMPTY_BYTE_ARRAY;
        }
        OutputStream outputStream = null;
        byte[] byArray = new byte[n2];
        while ((n = inputStream.read(byArray, 0, n2)) != -1 && n < n2) {
            if (outputStream == null) {
                outputStream = new ByteArrayOutputStream(n2);
            }
            ((ByteArrayOutputStream)outputStream).write(byArray, 0, n);
        }
        if (outputStream == null) {
            return byArray;
        }
        outputStream.flush();
        return ((ByteArrayOutputStream)outputStream).toByteArray();
    }

    private void registerUsingTypes() {
        HashMap<ContentType, ContentInfo> hashMap = new HashMap<ContentType, ContentInfo>();
        for (ContentInfo object2 : this.ctInfos) {
            hashMap.put(object2.type(), object2);
        }
        Iterator<ContentInfo> iterator = this.ctInfos.iterator();
        while (iterator.hasNext()) {
            ContentInfo contentInfo = iterator.next();
            ContentType contentType = contentInfo.parentType();
            if (contentType == null) continue;
            iterator.remove();
            ContentInfo contentInfo2 = (ContentInfo)hashMap.get(contentType);
            if (contentInfo2 == null) {
                LOG.warn("unable to retrieve parent type info for " + contentInfo.type());
                continue;
            }
            contentInfo2.addUsingType(contentInfo);
        }
    }

    @Override
    public void removeEntry(ContentTypeEntry contentTypeEntry) {
        this.replaceEntry(contentTypeEntry, null);
    }

    @Override
    public void removeListener(IContentTypeBoss.IChangeListener iChangeListener) {
        if (iChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.remove((Object)iChangeListener);
    }

    @Override
    public boolean replaceEntry(ContentTypeEntry contentTypeEntry, ContentTypeEntry contentTypeEntry2) {
        return this.replaceEntry(contentTypeEntry, contentTypeEntry2, true);
    }

    private boolean replaceEntry(ContentTypeEntry contentTypeEntry, ContentTypeEntry contentTypeEntry2, boolean bl) {
        String string;
        ContentTypeEntry contentTypeEntry3;
        ContentTypeEntry.Change change = null;
        if (contentTypeEntry != null && (contentTypeEntry3 = ext2ctEntry.get(string = contentTypeEntry.extension().toLowerCase())) != null) {
            change = contentTypeEntry2 == null ? ContentTypeEntry.Change.DELETED : (contentTypeEntry3.equals(contentTypeEntry2) ? ContentTypeEntry.Change.SAME : ContentTypeEntry.Change.CHANGED);
            if (change == ContentTypeEntry.Change.DELETED || change == ContentTypeEntry.Change.CHANGED) {
                ext2ctEntry.remove(string);
            }
            if (change == ContentTypeEntry.Change.DELETED) {
                ext2ctEntry.put(string, new ContentTypeEntry(contentTypeEntry3, ContentTypeEntry.Change.DELETED));
            }
        }
        if (contentTypeEntry2 != null) {
            string = contentTypeEntry2.extension().toLowerCase();
            if (change == ContentTypeEntry.Change.CHANGED) {
                ext2ctEntry.put(string, new ContentTypeEntry(contentTypeEntry2, change));
            } else {
                assert (change == null);
                change = ContentTypeEntry.Change.ADDED;
                ext2ctEntry.put(string, new ContentTypeEntry(contentTypeEntry2, change));
            }
        }
        if (change != ContentTypeEntry.Change.SAME) {
            if (bl) {
                App.instance().stateBoss().saveState();
                this.fireChanged();
            }
            return true;
        }
        return false;
    }

    @Override
    public void restoreDefaults() {
        if (!ext2ctEntry.isEmpty()) {
            ext2ctEntry.clear();
        }
    }

    @Override
    public long textCompareMaxFileSize() {
        return TEXT_COMPARE_MAX_FILE_SIZE;
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        Set<String> set = ext2ctEntry.keySet();
        jsonWriter.beginArray();
        for (String string : set) {
            ContentTypeEntry contentTypeEntry = ext2ctEntry.get(string);
            if (contentTypeEntry.changed() == ContentTypeEntry.Change.SAME) continue;
            jsonWriter.beginObject();
            jsonWriter.name("dtp").value(contentTypeEntry.docType().toString());
            jsonWriter.name("ext").value(contentTypeEntry.extension());
            jsonWriter.name("dsc").value(contentTypeEntry.description());
            jsonWriter.name("cng").value(contentTypeEntry.changed().toString());
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }

    @Override
    public List<ContentTypeEntry> userContentTypeEntries() {
        ArrayList<ContentTypeEntry> arrayList = new ArrayList<ContentTypeEntry>(ext2ctEntry.values());
        int n = arrayList.size() - 1;
        while (n >= 0) {
            ContentTypeEntry contentTypeEntry = (ContentTypeEntry)arrayList.get(n);
            if (contentTypeEntry.changed() == ContentTypeEntry.Change.DELETED) {
                arrayList.remove(contentTypeEntry);
            }
            --n;
        }
        return arrayList;
    }

    public static ContentTypeBoss[] values() {
        ContentTypeBoss[] contentTypeBossArray = ENUM$VALUES;
        int n = contentTypeBossArray.length;
        ContentTypeBoss[] contentTypeBossArray2 = new ContentTypeBoss[n];
        System.arraycopy(ENUM$VALUES, 0, contentTypeBossArray2, 0, n);
        return contentTypeBossArray2;
    }

    public static ContentTypeBoss valueOf(String string) {
        return Enum.valueOf(ContentTypeBoss.class, string);
    }
}

