/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal.content;

import com.deltawalker.internal.content.MagicNumber;
import com.deltawalker.internal.content.MagicString;
import com.deltopia.io.ContentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContentInfo {
    private ContentType cType;
    private final List<String> extensions;
    private final boolean leadingWS;
    private final List<MagicNumber> mgNumbers;
    private final List<MagicString> mgStrings;
    private final ContentType parentType;
    private final List<ContentInfo> usingTypes;
    private final boolean confirm;

    public ContentInfo(ContentType contentType, List<String> list) {
        this(contentType, list, Collections.emptyList(), Collections.emptyList(), null, false, false);
    }

    public ContentInfo(ContentType contentType, List<String> list, ContentType contentType2) {
        this(contentType, list, Collections.emptyList(), Collections.emptyList(), contentType2, false, false);
    }

    public ContentInfo(ContentType contentType, List<String> list, List<MagicNumber> list2) {
        this(contentType, list, list2, Collections.emptyList(), null, false, false);
    }

    public ContentInfo(ContentType contentType, List<String> list, List<MagicNumber> list2, boolean bl) {
        this(contentType, list, list2, Collections.emptyList(), null, bl, false);
    }

    public ContentInfo(ContentType contentType, List<String> list, List<MagicNumber> list2, ContentType contentType2, boolean bl) {
        this(contentType, list, list2, Collections.emptyList(), contentType2, bl, false);
    }

    public ContentInfo(ContentType contentType, List<String> list, List<MagicNumber> list2, List<MagicString> list3) {
        this(contentType, list, list2, Collections.emptyList(), null, false, false);
    }

    public ContentInfo(ContentType contentType, List<String> list, List<MagicNumber> list2, List<MagicString> list3, ContentType contentType2, boolean bl, boolean bl2) {
        this.cType = contentType;
        this.parentType = contentType2;
        this.extensions = list;
        this.mgStrings = list3;
        this.mgNumbers = list2;
        this.leadingWS = bl;
        this.confirm = bl2;
        this.usingTypes = new ArrayList<ContentInfo>(0);
    }

    public void addUsingType(ContentInfo contentInfo) {
        this.usingTypes.add(contentInfo);
    }

    public boolean containsExtension(String string) {
        return this.extensions.contains(string);
    }

    public List<String> extensions() {
        return this.extensions;
    }

    public List<MagicNumber> magicNumbers() {
        return this.mgNumbers;
    }

    public List<MagicString> magicStrings() {
        return this.mgStrings;
    }

    public boolean matches(byte[] byArray, String string) {
        if (byArray != null && this.mgNumbers != null && !this.mgNumbers.isEmpty()) {
            int n = 0;
            if (this.leadingWS) {
                int n2 = 0;
                while (n2 < byArray.length) {
                    char c = (char)byArray[n2];
                    if (!Character.isWhitespace(c) && c != '\u0000' && c != '\u00ff' && c != '\u00fe' && c != '\u00ef' && c != '\u00bb' && c != '\u00bf') break;
                    ++n;
                    ++n2;
                }
            }
            for (MagicNumber magicNumber : this.mgNumbers) {
                if (!magicNumber.matches(byArray, n)) continue;
                if (this.confirm) {
                    return this.containsExtension(string);
                }
                return true;
            }
        }
        return false;
    }

    public boolean matches(char[] cArray, String string) {
        if (cArray != null && this.mgStrings != null && !this.mgStrings.isEmpty()) {
            int n;
            int n2;
            int n3 = 0;
            if (this.leadingWS) {
                n2 = 0;
                while (n2 < cArray.length) {
                    n = cArray[n2];
                    if (!Character.isWhitespace((char)n)) break;
                    ++n3;
                    ++n2;
                }
            }
            n2 = this.mgStrings.size();
            n = 0;
            while (n < n2) {
                MagicString magicString = this.mgStrings.get(n);
                if (magicString.matches(cArray, n3)) {
                    if (this.confirm) {
                        return this.containsExtension(string);
                    }
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public ContentType parentType() {
        return this.parentType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ").append(this.cType);
        if (this.parentType != null) {
            stringBuilder.append(" | parentType: ").append(this.parentType);
        }
        if (!this.extensions.isEmpty()) {
            stringBuilder.append(" | extensions:");
            for (String object : this.extensions) {
                stringBuilder.append(' ').append(object);
            }
        }
        if (!this.mgStrings.isEmpty()) {
            stringBuilder.append(" | magic strings:");
            for (MagicString magicString : this.mgStrings) {
                stringBuilder.append(' ').append(magicString);
            }
        }
        if (!this.mgNumbers.isEmpty()) {
            stringBuilder.append(" | magic numbers:");
            for (MagicNumber magicNumber : this.mgNumbers) {
                stringBuilder.append(' ').append(magicNumber.toString());
            }
        }
        if (!this.usingTypes.isEmpty()) {
            stringBuilder.append(" | used by:");
            for (ContentInfo contentInfo : this.usingTypes) {
                stringBuilder.append(' ').append(contentInfo);
            }
        }
        return stringBuilder.toString();
    }

    public ContentType type() {
        return this.cType;
    }

    public List<ContentInfo> usingTypes() {
        return this.usingTypes;
    }
}

