/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal;

import com.deltawalker.DocType;
import com.deltawalker.StructProperty;
import com.deltawalker.internal.ReportConfig;
import com.deltawalker.internal.reports.Linked;
import com.deltawalker.script.Role;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;

public class TagReportConfig
extends ReportConfig {
    private static final Set<Format> SUPPORTED_FORMATS;
    private final ConcurrentMap<StructProperty, Boolean> col2visible = new ConcurrentHashMap<StructProperty, Boolean>();
    public final Format extension;
    public final Linked linked;

    static {
        LinkedHashSet<Format> linkedHashSet = new LinkedHashSet<Format>(1);
        linkedHashSet.add(Format.HTML);
        SUPPORTED_FORMATS = Collections.unmodifiableSet(linkedHashSet);
    }

    public static final Set<Format> getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public TagReportConfig(DocType docType, Format format, Set<Role> set, Linked linked, String string, boolean bl, IProgressMonitor iProgressMonitor) {
        super(docType, set, string, bl, iProgressMonitor);
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.extension = format;
        this.linked = linked;
    }

    public boolean isTreeColumnVisible(StructProperty structProperty) {
        Boolean bl;
        if (structProperty == null) {
            throw new NullPointerException("prop");
        }
        Boolean bl2 = (Boolean)this.col2visible.get((Object)structProperty);
        if (bl2 == null && (bl2 = this.col2visible.putIfAbsent(structProperty, bl = Boolean.valueOf(structProperty.isVisible()))) == null) {
            bl2 = bl;
        }
        return bl2;
    }

    public static enum Format {
        HTML("html"),
        JSON("dwss"),
        XML("xml");

        private final String extension;

        private Format(String string2) {
            this.extension = string2;
        }

        public String toString() {
            return this.extension;
        }
    }
}

