/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal;

import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltopia.ObjectUtil;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class SessionPrefStore
implements IPreferenceStore {
    private final IPreferenceStore globalPrefs;
    private final ListenerList listeners = new ListenerList(1);
    private final IPropertyChangeListener onProperty = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            if (!SessionPrefStore.this.contains(string) || SessionPrefStore.this.props.getProperty(string) == null) {
                SessionPrefStore.this.firePropertyChangeEvent(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    };
    private Properties props = new Properties();

    public SessionPrefStore() {
        this.globalPrefs = PrefUtil.getGlobalPrefs();
        List<PrefKey> list = PrefKey.sessionKeys();
        for (PrefKey prefKey : list) {
            this.props.put(prefKey.toString(), this.globalPrefs.getString(prefKey.toString()));
        }
    }

    public SessionPrefStore(IPreferenceStore iPreferenceStore) {
        this.globalPrefs = PrefUtil.getGlobalPrefs();
        List<PrefKey> list = PrefKey.sessionKeys();
        for (PrefKey prefKey : list) {
            this.props.put(prefKey.toString(), iPreferenceStore.getString(prefKey.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            boolean bl = this.listeners.isEmpty();
            this.listeners.add((Object)iPropertyChangeListener);
            if (bl && !this.listeners.isEmpty()) {
                this.globalPrefs.addPropertyChangeListener(this.onProperty);
            }
        }
    }

    public boolean contains(String string) {
        return this.props.containsKey(string) || this.globalPrefs.contains(string);
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        Object[] objectArray2 = objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object3 = objectArray2[n2];
            ((IPropertyChangeListener)object3).propertyChange(propertyChangeEvent);
            ++n2;
        }
    }

    public boolean getBoolean(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return this.globalPrefs.getBoolean(string);
    }

    public boolean getDefaultBoolean(String string) {
        return this.contains(string) ? this.globalPrefs.getBoolean(string) : this.globalPrefs.getDefaultBoolean(string);
    }

    public double getDefaultDouble(String string) {
        return this.contains(string) ? this.globalPrefs.getDouble(string) : this.globalPrefs.getDefaultDouble(string);
    }

    public float getDefaultFloat(String string) {
        return this.contains(string) ? this.globalPrefs.getFloat(string) : this.globalPrefs.getDefaultFloat(string);
    }

    public int getDefaultInt(String string) {
        return this.contains(string) ? this.globalPrefs.getInt(string) : this.globalPrefs.getDefaultInt(string);
    }

    public long getDefaultLong(String string) {
        return this.contains(string) ? this.globalPrefs.getLong(string) : this.globalPrefs.getDefaultLong(string);
    }

    public String getDefaultString(String string) {
        return this.contains(string) ? this.globalPrefs.getString(string) : this.globalPrefs.getDefaultString(string);
    }

    public double getDouble(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.globalPrefs.getDouble(string);
    }

    public float getFloat(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.globalPrefs.getFloat(string);
    }

    public int getInt(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.globalPrefs.getInt(string);
    }

    public long getLong(String string) {
        String string2 = this.props.getProperty(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.globalPrefs.getLong(string);
    }

    public String getString(String string) {
        String string2 = this.props.getProperty(string);
        return string2 != null ? string2 : this.globalPrefs.getString(string);
    }

    public boolean isDefault(String string) {
        if (this.props.containsKey(string)) {
            return this.props.getProperty(string).equals(PrefKey.fromString(string).defaultValue());
        }
        return this.globalPrefs.isDefault(string);
    }

    public boolean needsSaving() {
        return false;
    }

    private void putSessionValue(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    public void putValue(String string, String string2) {
        if (this.props.containsKey(string)) {
            this.putSessionValue(string, string2);
        } else {
            this.globalPrefs.putValue(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            boolean bl = !this.listeners.isEmpty();
            this.listeners.remove((Object)iPropertyChangeListener);
            if (bl && this.listeners.isEmpty()) {
                this.globalPrefs.removePropertyChangeListener(this.onProperty);
            }
        }
    }

    public void setDefault(String string, boolean bl) {
        if (this.props.containsKey(string)) {
            this.globalPrefs.setValue(string, bl);
        } else {
            this.globalPrefs.setDefault(string, bl);
        }
    }

    public void setDefault(String string, double d) {
        if (this.props.containsKey(string)) {
            this.globalPrefs.setValue(string, d);
        } else {
            this.globalPrefs.setDefault(string, d);
        }
    }

    public void setDefault(String string, float f) {
        if (this.props.containsKey(string)) {
            this.globalPrefs.setValue(string, f);
        } else {
            this.globalPrefs.setDefault(string, f);
        }
    }

    public void setDefault(String string, int n) {
        if (this.props.containsKey(string)) {
            this.globalPrefs.setValue(string, n);
        } else {
            this.globalPrefs.setDefault(string, n);
        }
    }

    public void setDefault(String string, long l) {
        if (this.props.containsKey(string)) {
            this.globalPrefs.setValue(string, l);
        } else {
            this.globalPrefs.setDefault(string, l);
        }
    }

    public void setDefault(String string, String string2) {
        if (this.props.containsKey(string)) {
            this.globalPrefs.setValue(string, string2);
        } else {
            this.globalPrefs.setDefault(string, string2);
        }
    }

    private void setSessionValue(String string, String string2) {
        String string3 = this.getString(string);
        this.props.setProperty(string, string2);
        String string4 = this.getString(string);
        if (!ObjectUtil.areEqual((Object)string3, (Object)string4)) {
            this.firePropertyChangeEvent(string, string3, string4);
        }
    }

    public void setToDefault(String string) {
        if (this.props.containsKey(string)) {
            String string2 = this.getString(string);
            this.props.remove(string);
            String string3 = this.getString(string);
            if (!ObjectUtil.areEqual((Object)string2, (Object)string3)) {
                this.firePropertyChangeEvent(string, string2, string3);
            }
        } else {
            this.globalPrefs.setToDefault(string);
        }
    }

    public void setValue(String string, boolean bl) {
        if (this.props.containsKey(string)) {
            this.setSessionValue(string, Boolean.toString(bl));
        } else {
            this.globalPrefs.setValue(string, bl);
        }
    }

    public void setValue(String string, double d) {
        if (this.props.containsKey(string)) {
            this.setSessionValue(string, Double.toString(d));
        } else {
            this.globalPrefs.setValue(string, d);
        }
    }

    public void setValue(String string, float f) {
        if (this.props.containsKey(string)) {
            this.setSessionValue(string, Float.toString(f));
        } else {
            this.globalPrefs.setValue(string, f);
        }
    }

    public void setValue(String string, int n) {
        if (this.props.containsKey(string)) {
            this.setSessionValue(string, Integer.toString(n));
        } else {
            this.globalPrefs.setValue(string, n);
        }
    }

    public void setValue(String string, long l) {
        if (this.props.containsKey(string)) {
            this.setSessionValue(string, Long.toString(l));
        } else {
            this.globalPrefs.setValue(string, l);
        }
    }

    public void setValue(String string, String string2) {
        if (this.props.containsKey(string)) {
            this.setSessionValue(string, string2);
        } else {
            this.globalPrefs.setValue(string, string2);
        }
    }
}

