/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal;

import com.deltopia.io.StreamUtil;
import com.deltopia.util.Const;
import com.deltopia.util.OS;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmIntegrator {
    private static final String APPDATA = String.valueOf(System.getenv("APPDATA")) + File.separator;
    public static final String DW_SCRIPTS_PATH;
    public static final String EMPTY = "";
    private static final Logger LOG;
    public static final String NO_DEFAULT_CONFIG = "No config file in default location. Click 'Browse' to locate.";
    private static Map<String, String[]> sec2pairs;
    private static final String USER_HOME;

    static {
        LOG = LoggerFactory.getLogger(ScmIntegrator.class);
        sec2pairs = new HashMap<String, String[]>();
        USER_HOME = String.valueOf(Const.USER_HOME) + File.separator;
        String string = Platform.getInstallLocation().getURL().getPath();
        if (!string.endsWith("/")) {
            string = String.valueOf(string) + "/";
        }
        if (OS.WIN) {
            DW_SCRIPTS_PATH = string.startsWith("/") ? string.substring(1) : string;
            String[] stringArray = new String[]{"external_merge = \"" + DW_SCRIPTS_PATH + "bzr-merge.bat %t %o %b %r\""};
            sec2pairs.put(Scm.BZ.section(0), stringArray);
            stringArray = new String[]{"dwdiff = 'diff --using \"" + DW_SCRIPTS_PATH + "bzr-diff.bat\"'"};
            sec2pairs.put(Scm.BZ.section(1), stringArray);
            stringArray = new String[]{"\ttool = deltawalker"};
            sec2pairs.put(Scm.GIT.section(0), stringArray);
            stringArray = new String[]{"\tprompt = false"};
            sec2pairs.put(Scm.GIT.section(1), stringArray);
            stringArray = new String[]{"\tcmd = '" + DW_SCRIPTS_PATH.replace('\\', '/') + "git-diff'" + " \"$LOCAL\" \"$REMOTE\""};
            sec2pairs.put(Scm.GIT.section(2), stringArray);
            stringArray = new String[]{"\ttool = deltawalker"};
            sec2pairs.put(Scm.GIT.section(3), stringArray);
            stringArray = new String[]{"\tkeepBackup = false"};
            sec2pairs.put(Scm.GIT.section(4), stringArray);
            stringArray = new String[]{"\tcmd = '" + DW_SCRIPTS_PATH.replace('\\', '/') + "git-merge'" + " \"$LOCAL\" \"$REMOTE\" \"$BASE\" \"$MERGED\""};
            sec2pairs.put(Scm.GIT.section(5), stringArray);
            stringArray = new String[]{"merge = dw"};
            sec2pairs.put(Scm.HG.section(0), stringArray);
            stringArray = new String[]{"hgext.extdiff ="};
            sec2pairs.put(Scm.HG.section(1), stringArray);
            stringArray = new String[]{"cmd.dw = " + DW_SCRIPTS_PATH + "hg.bat"};
            sec2pairs.put(Scm.HG.section(2), stringArray);
            stringArray = new String[]{"dw.executable = " + DW_SCRIPTS_PATH.replace('\\', '/') + "hg.bat", "dw.args = $local $other $base $output"};
            sec2pairs.put(Scm.HG.section(3), stringArray);
            stringArray = new String[]{"diff-cmd = \"" + DW_SCRIPTS_PATH.replace('/', '\\') + "svn-diff.bat\"", "merge-tool-cmd = \"" + DW_SCRIPTS_PATH.replace('/', '\\') + "svn-merge.bat\""};
            sec2pairs.put(Scm.SVN.section(0), stringArray);
        } else if (OS.OSX) {
            int n = string.lastIndexOf("Contents/Java/");
            if (n != -1) {
                string = string.substring(0, n);
            }
            DW_SCRIPTS_PATH = String.valueOf(string) + "Contents/Resources/";
            String[] stringArray = new String[]{"external_merge = " + DW_SCRIPTS_PATH + "bzr-merge %t %o %b %r"};
            sec2pairs.put(Scm.BZ.section(0), stringArray);
            stringArray = new String[]{"dwdiff = diff --using \"" + DW_SCRIPTS_PATH.replaceAll(" ", "\\\\ ") + "bzr-diff\""};
            sec2pairs.put(Scm.BZ.section(1), stringArray);
            stringArray = new String[]{"\ttool = deltawalker"};
            sec2pairs.put(Scm.GIT.section(0), stringArray);
            stringArray = new String[]{"\tprompt = false"};
            sec2pairs.put(Scm.GIT.section(1), stringArray);
            stringArray = new String[]{"\tcmd = '" + DW_SCRIPTS_PATH + "git-diff'" + " \"$LOCAL\" \"$REMOTE\""};
            sec2pairs.put(Scm.GIT.section(2), stringArray);
            stringArray = new String[]{"\ttool = deltawalker"};
            sec2pairs.put(Scm.GIT.section(3), stringArray);
            stringArray = new String[]{"\tkeepBackup = false"};
            sec2pairs.put(Scm.GIT.section(4), stringArray);
            stringArray = new String[]{"\tcmd = '" + DW_SCRIPTS_PATH + "git-merge'" + " \"$LOCAL\" \"$REMOTE\" \"$BASE\" \"$MERGED\""};
            sec2pairs.put(Scm.GIT.section(5), stringArray);
            stringArray = new String[]{"merge = dw"};
            sec2pairs.put(Scm.HG.section(0), stringArray);
            stringArray = new String[]{"hgext.extdiff ="};
            sec2pairs.put(Scm.HG.section(1), stringArray);
            stringArray = new String[]{"cmd.dw = " + DW_SCRIPTS_PATH + "hg"};
            sec2pairs.put(Scm.HG.section(2), stringArray);
            stringArray = new String[]{"dw.executable = " + DW_SCRIPTS_PATH + "hg", "dw.args = $local $other $base $output"};
            sec2pairs.put(Scm.HG.section(3), stringArray);
            stringArray = new String[]{"diff-cmd = " + DW_SCRIPTS_PATH + "svn-diff", "merge-tool-cmd = " + DW_SCRIPTS_PATH + "svn-merge"};
            sec2pairs.put(Scm.SVN.section(0), stringArray);
        } else {
            DW_SCRIPTS_PATH = string;
            String[] stringArray = new String[]{"external_merge = " + DW_SCRIPTS_PATH + "bzr-merge %t %o %b %r"};
            sec2pairs.put(Scm.BZ.section(0), stringArray);
            stringArray = new String[]{"dwdiff = diff --using \"" + DW_SCRIPTS_PATH.replaceAll(" ", "\\\\ ") + "bzr-diff\""};
            sec2pairs.put(Scm.BZ.section(1), stringArray);
            stringArray = new String[]{"\ttool = deltawalker"};
            sec2pairs.put(Scm.GIT.section(0), stringArray);
            stringArray = new String[]{"\tprompt = false"};
            sec2pairs.put(Scm.GIT.section(1), stringArray);
            stringArray = new String[]{"\tcmd = '" + DW_SCRIPTS_PATH + "git-diff'" + " \"$LOCAL\" \"$REMOTE\""};
            sec2pairs.put(Scm.GIT.section(2), stringArray);
            stringArray = new String[]{"\ttool = deltawalker"};
            sec2pairs.put(Scm.GIT.section(3), stringArray);
            stringArray = new String[]{"\tkeepBackup = false"};
            sec2pairs.put(Scm.GIT.section(4), stringArray);
            stringArray = new String[]{"\tcmd = '" + DW_SCRIPTS_PATH + "git-merge'" + " \"$LOCAL\" \"$REMOTE\" \"$BASE\" \"$MERGED\""};
            sec2pairs.put(Scm.GIT.section(5), stringArray);
            stringArray = new String[]{"merge = dw"};
            sec2pairs.put(Scm.HG.section(0), stringArray);
            stringArray = new String[]{"hgext.extdiff ="};
            sec2pairs.put(Scm.HG.section(1), stringArray);
            stringArray = new String[]{"cmd.dw = " + DW_SCRIPTS_PATH + "hg"};
            sec2pairs.put(Scm.HG.section(2), stringArray);
            stringArray = new String[]{"dw.executable = " + DW_SCRIPTS_PATH + "hg", "dw.args = $local $other $base $output"};
            sec2pairs.put(Scm.HG.section(3), stringArray);
            stringArray = new String[]{"diff-cmd = " + DW_SCRIPTS_PATH + "svn-diff", "merge-tool-cmd = " + DW_SCRIPTS_PATH + "svn-merge"};
            sec2pairs.put(Scm.SVN.section(0), stringArray);
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (file == null) {
            throw new NullPointerException("srcFile");
        }
        if (file2 == null) {
            throw new NullPointerException("dstFile");
        }
        if (!file2.exists()) {
            file2.createNewFile();
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private static File createTempFile() throws IOException {
        return File.createTempFile("$_dw_scm_$", ".tmp");
    }

    public static String getConfigFileDefaultLocation(Scm scm) {
        switch (scm) {
            case BZ: {
                if (OS.WIN) {
                    return String.valueOf(APPDATA) + "bazaar\\2.0\\bazaar.conf";
                }
                return String.valueOf(USER_HOME) + ".bazaar/bazaar.conf";
            }
            case GIT: {
                return String.valueOf(USER_HOME) + ".gitconfig";
            }
            case HG: {
                return String.valueOf(USER_HOME) + ".hgrc";
            }
            case SVN: {
                if (OS.WIN) {
                    return String.valueOf(APPDATA) + "subversion\\config";
                }
                return String.valueOf(USER_HOME) + ".subversion/config";
            }
        }
        assert (false);
        return EMPTY;
    }

    private static boolean isName(String string, String string2) {
        string = string.replaceAll(" ", EMPTY);
        string = string.replaceAll("\\t", EMPTY);
        string2 = string2.replaceAll(" ", EMPTY);
        string2 = string2.replaceAll("\\t", EMPTY);
        String string3 = string2.substring(0, string2.indexOf("="));
        int n = string.indexOf("=");
        if (n < 0) {
            return false;
        }
        String string4 = string.substring(0, n);
        return string4.equalsIgnoreCase(string3);
    }

    public void cofigureWithDW(Scm scm, File file) {
        if (!this.isConfiguredWithDW(scm, file)) {
            Object object;
            String[] stringArray = null;
            boolean bl = true;
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            boolean bl2 = false;
            if (scm.name.equalsIgnoreCase("Subversion")) {
                bl2 = true;
            }
            String[] stringArray2 = scm.sections;
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray2[n2];
                hashMap.put((String)object, sec2pairs.get(object));
                ++n2;
            }
            try {
                File file2;
                block32: {
                    String string;
                    block30: {
                        object = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                        try {
                            try {
                                block11: while ((string = ((BufferedReader)object).readLine()) != null) {
                                    string = string.replaceAll("#", EMPTY);
                                    string = string.replaceAll(";", EMPTY);
                                    string = string.replaceAll(" ", EMPTY);
                                    string = string.replaceAll("\\t", EMPTY);
                                    String[] stringArray3 = scm.sections;
                                    int n3 = stringArray3.length;
                                    n = 0;
                                    while (n < n3) {
                                        String string2 = stringArray3[n];
                                        if (string.equalsIgnoreCase(string2.replaceAll(" ", EMPTY)) && string2.length() > 0) {
                                            hashMap.remove(string2);
                                            continue block11;
                                        }
                                        ++n;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                LOG.error(NLS.bind((String)"Couldn''t integrate DeltaWalker with ''{0}'': {1}", (Object)file, (Object)throwable));
                                StreamUtil.closeSilently((Closeable)object);
                                break block30;
                            }
                        }
                        catch (Throwable throwable) {
                            StreamUtil.closeSilently((Closeable)object);
                            throw throwable;
                        }
                        StreamUtil.closeSilently((Closeable)object);
                    }
                    file2 = ScmIntegrator.createTempFile();
                    object = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file2)));
                    try {
                        try {
                            String string3;
                            int n4;
                            int n5;
                            String[] stringArray4;
                            int n6;
                            String[] stringArray5;
                            while ((string = ((BufferedReader)object).readLine()) != null) {
                                String string4;
                                String string5 = string;
                                bl = true;
                                string = string.replaceAll("#", EMPTY);
                                string = string.replaceAll(";", EMPTY);
                                string = string.replaceAll(" ", EMPTY);
                                string = string.replaceAll("\\t", EMPTY);
                                stringArray5 = scm.sections;
                                n6 = stringArray5.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    string4 = stringArray5[n7];
                                    if (string.equalsIgnoreCase(string4.replaceAll(" ", EMPTY)) && string4.length() > 0) {
                                        stringArray = sec2pairs.get(string4);
                                        printWriter.println(string4);
                                        bl = false;
                                        if (stringArray == null) break;
                                        stringArray4 = stringArray;
                                        n5 = stringArray.length;
                                        n4 = 0;
                                        while (n4 < n5) {
                                            string3 = stringArray4[n4];
                                            printWriter.println(string3);
                                            ++n4;
                                        }
                                        break;
                                    }
                                    ++n7;
                                }
                                if (stringArray != null) {
                                    stringArray5 = stringArray;
                                    n6 = stringArray.length;
                                    n7 = 0;
                                    while (n7 < n6) {
                                        string4 = stringArray5[n7];
                                        if (string.equalsIgnoreCase(string4.replaceAll(" ", EMPTY))) {
                                            bl = false;
                                            break;
                                        }
                                        if (ScmIntegrator.isName(string5, string4)) {
                                            printWriter.println("# " + string5);
                                            bl = false;
                                            break;
                                        }
                                        ++n7;
                                    }
                                }
                                if (bl2 && ScmIntegrator.isName(string5, "diff3-cmd = ")) {
                                    printWriter.println("# " + string5);
                                    bl = false;
                                }
                                if (!bl) continue;
                                printWriter.println(string5);
                            }
                            if (!hashMap.isEmpty()) {
                                stringArray5 = scm.sections;
                                n6 = stringArray5.length;
                                int n8 = 0;
                                while (n8 < n6) {
                                    String string6 = stringArray5[n8];
                                    stringArray = (String[])hashMap.get(string6);
                                    if (stringArray != null) {
                                        printWriter.println(string6);
                                        stringArray4 = stringArray;
                                        n5 = stringArray.length;
                                        n4 = 0;
                                        while (n4 < n5) {
                                            string3 = stringArray4[n4];
                                            printWriter.println(string3);
                                            ++n4;
                                        }
                                    }
                                    ++n8;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            LOG.error(NLS.bind((String)"Couldn''t integrate DeltaWalker with ''{0}'': {1}", (Object)file, (Object)throwable));
                            StreamUtil.closeSilently((Closeable)object);
                            printWriter.flush();
                            StreamUtil.closeSilently((Closeable)printWriter);
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        StreamUtil.closeSilently((Closeable)object);
                        printWriter.flush();
                        StreamUtil.closeSilently((Closeable)printWriter);
                        throw throwable;
                    }
                    StreamUtil.closeSilently((Closeable)object);
                    printWriter.flush();
                    StreamUtil.closeSilently((Closeable)printWriter);
                }
                ScmIntegrator.copyFile(file2, file);
                file2.deleteOnExit();
            }
            catch (Throwable throwable) {
                LOG.error(NLS.bind((String)"Couldn''t integrate DeltaWalker with ''{0}'': {1}", (Object)file, (Object)throwable));
            }
        }
    }

    private String extractValue(String string) {
        return string.substring(string.indexOf("=") + 1).trim();
    }

    private int getPairCount(Scm scm) {
        String[] stringArray;
        int n = 0;
        String[] stringArray2 = stringArray = scm.sections();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            if (string.length() > 0) {
                String[] stringArray3 = sec2pairs.get(string);
                n += stringArray3.length;
            }
            ++n3;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConfiguredWithDW(Scm scm, File file) {
        String[] stringArray = null;
        int n = scm.sections.length;
        int n2 = this.getPairCount(scm);
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (scm.name.equalsIgnoreCase("Subversion")) {
            bl = true;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                String string;
                block9: while ((string = bufferedReader.readLine()) != null) {
                    String string2;
                    String string3 = string;
                    string = string.replaceAll(" ", EMPTY);
                    string = string.replaceAll("\\t", EMPTY);
                    if (bl && ScmIntegrator.isName(string, "diff3-cmd = ")) {
                        return false;
                    }
                    String[] stringArray2 = scm.sections;
                    int n5 = stringArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        string2 = stringArray2[n6];
                        if (!string2.isEmpty() && string.equalsIgnoreCase(string2.replaceAll(" ", EMPTY))) {
                            stringArray = sec2pairs.get(string2);
                            ++n3;
                            break;
                        }
                        ++n6;
                    }
                    if (stringArray == null) continue;
                    stringArray2 = stringArray;
                    n5 = stringArray.length;
                    n6 = 0;
                    while (n6 < n5) {
                        String string4;
                        string2 = stringArray2[n6];
                        String string5 = this.extractValue(string3);
                        if (string5.equalsIgnoreCase(string4 = this.extractValue(string2)) && ScmIntegrator.isName(string3, string2)) {
                            if (++n4 != n2 || n3 != n) continue block9;
                            return true;
                        }
                        ++n6;
                    }
                }
                return false;
            }
            catch (Throwable throwable) {
                LOG.error(NLS.bind((String)"Couldn''t integrate DeltaWalker with ''{0}'': {1}", (Object)file, (Object)throwable));
                return false;
            }
            finally {
                StreamUtil.closeSilently((Closeable)bufferedReader);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.error(fileNotFoundException.getMessage());
        }
        return false;
    }

    public void uncofigureDW(Scm scm, File file) {
        if (this.isConfiguredWithDW(scm, file)) {
            String[] stringArray = null;
            boolean bl = false;
            try {
                File file2 = ScmIntegrator.createTempFile();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file2)));
                try {
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            String string2;
                            String string3 = string;
                            string = string.replaceAll(" ", EMPTY);
                            string = string.replaceAll("\\t", EMPTY);
                            String[] stringArray2 = scm.sections;
                            int n = stringArray2.length;
                            int n2 = 0;
                            while (n2 < n) {
                                string2 = stringArray2[n2];
                                if (!string2.isEmpty() && string.equalsIgnoreCase(string2.replaceAll(" ", EMPTY))) {
                                    stringArray = sec2pairs.get(string2);
                                    break;
                                }
                                ++n2;
                            }
                            if (stringArray != null) {
                                stringArray2 = stringArray;
                                n = stringArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    string2 = stringArray2[n2];
                                    if (string.equalsIgnoreCase(string2.replaceAll(" ", EMPTY))) {
                                        printWriter.println("# " + string3);
                                        bl = true;
                                        break;
                                    }
                                    ++n2;
                                }
                            }
                            if (!bl) {
                                printWriter.println(string3);
                                continue;
                            }
                            bl = false;
                        }
                    }
                    catch (Throwable throwable) {
                        LOG.error(NLS.bind((String)"Couldn''t unconfigure ''{0}'': {1}", (Object)file, (Object)throwable));
                        StreamUtil.closeSilently((Closeable)bufferedReader);
                        printWriter.flush();
                        StreamUtil.closeSilently((Closeable)printWriter);
                        ScmIntegrator.copyFile(file2, file);
                        file2.deleteOnExit();
                    }
                }
                finally {
                    StreamUtil.closeSilently((Closeable)bufferedReader);
                    printWriter.flush();
                    StreamUtil.closeSilently((Closeable)printWriter);
                    ScmIntegrator.copyFile(file2, file);
                    file2.deleteOnExit();
                }
            }
            catch (Throwable throwable) {
                LOG.error(NLS.bind((String)"Couldn''t unconfigure ''{0}'': {1}", (Object)file, (Object)throwable));
            }
        }
    }

    public static enum Scm {
        BZ("Bazaar", "[DEFAULT]", "[ALIASES]"),
        GIT("Git", "[diff]", "[difftool]", "[difftool  \"deltawalker\"]", "[merge]", "[mergetool]", "[mergetool  \"deltawalker\"]"),
        HG("Mercurial", "[ui]", "[extensions]", "[extdiff]", "[merge-tools]"),
        SVN("Subversion", "[helpers]");

        private final String name;
        private final String[] sections;

        private Scm(String string2, String ... stringArray) {
            this.name = string2;
            this.sections = stringArray;
        }

        public String displayName() {
            return this.name;
        }

        public String section(int n) {
            return this.sections[n];
        }

        public String[] sections() {
            return this.sections;
        }
    }
}

