/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.ImageCache;
import com.deltawalker.Msg;
import com.deltawalker.interfaces.IFilterBoss;
import com.deltawalker.text.Filters;
import com.deltawalker.text.TextFilter;
import com.deltawalker.ui.CursorRegistry;
import com.deltopia.io.TempFileBoss;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DeltaWalkerPlugin
extends AbstractUIPlugin {
    private static DeltaWalkerPlugin plugin;
    private CursorRegistry cursorRegistry;

    public static DeltaWalkerPlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return DeltaWalkerPlugin.getDefault().getId();
    }

    public DeltaWalkerPlugin() {
        plugin = this;
        TempFileBoss.getInstance().revalidate(0L);
    }

    protected ImageRegistry createImageRegistry() {
        return ImageCache.getImageRegistry();
    }

    public CursorRegistry getCursorRegistry() {
        if (this.cursorRegistry == null) {
            this.cursorRegistry = new CursorRegistry();
        }
        return this.cursorRegistry;
    }

    public String getId() {
        return this.getBundle().getSymbolicName();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        ArrayList<TextFilter> arrayList = new ArrayList<TextFilter>(5);
        arrayList.add(new TextFilter("^[ \t\\x0B\f]*$", TextFilter.Target.LINES, false, Msg.RegexFilter_blankLines, "t1"));
        arrayList.add(new TextFilter("//.*$", TextFilter.Target.CHARS, false, Msg.RegexFilter_cppComments, "t2"));
        arrayList.add(new TextFilter("\\$(Author|Date|Header|Id|Locker|Name|RCSfile|Revision|Source|State):[^$]*\\$", TextFilter.Target.CHARS, false, Msg.RegexFilter_cvsComments, "t3"));
        arrayList.add(new TextFilter("[\\n\\r\\f\\x0B]$", TextFilter.Target.CHARS, true, Msg.RegexFilter_ignoreEndings, "ti1"));
        arrayList.add(new TextFilter("[ \\t]*", TextFilter.Target.CHARS, false, Msg.RegexFilter_ignoreWhitespace, "ti2"));
        IFilterBoss iFilterBoss = App.instance().filterBoss();
        iFilterBoss.setFactoryDefaultFilters(new Filters(arrayList, DocType.TEXT));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.cursorRegistry != null) {
                this.cursorRegistry.dispose();
                this.cursorRegistry = null;
            }
        }
        finally {
            super.stop(bundleContext);
        }
    }
}

