/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.internal;

import com.deltawalker.internal.DeltaWalkerPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ChainedPrefStore
implements IPreferenceStore {
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ChainedPrefStore.this.firePropertyChangeEvent(propertyChangeEvent.getProperty(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    };
    private final ListenerList listeners = new ListenerList(1);
    private final List<StoreEntry> storeEntries = new ArrayList<StoreEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceStore(IPreferenceStore iPreferenceStore, String string) {
        StoreEntry storeEntry = new StoreEntry(iPreferenceStore, string);
        List<StoreEntry> list = this.storeEntries;
        synchronized (list) {
            if (!this.storeEntries.contains(storeEntry) && this.storeEntries.add(storeEntry)) {
                iPreferenceStore.addPropertyChangeListener(this.listener);
            }
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add((Object)iPropertyChangeListener);
    }

    public boolean contains(String string) {
        return this.getReadStore(string) != null;
    }

    public void firePropertyChangeEvent(String string, Object object, Object object2) {
        Object[] objectArray = this.listeners.getListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object3 = objectArray2[n2];
            ((IPropertyChangeListener)object3).propertyChange(propertyChangeEvent);
            ++n2;
        }
    }

    public boolean getBoolean(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? false : iPreferenceStore.getBoolean(string);
    }

    public boolean getDefaultBoolean(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? false : iPreferenceStore.getDefaultBoolean(string);
    }

    public double getDefaultDouble(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0.0 : iPreferenceStore.getDefaultDouble(string);
    }

    public float getDefaultFloat(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0.0f : iPreferenceStore.getDefaultFloat(string);
    }

    public int getDefaultInt(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0 : iPreferenceStore.getDefaultInt(string);
    }

    public long getDefaultLong(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0L : iPreferenceStore.getDefaultLong(string);
    }

    public String getDefaultString(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? "" : iPreferenceStore.getDefaultString(string);
    }

    public double getDouble(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0.0 : iPreferenceStore.getDouble(string);
    }

    public float getFloat(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0.0f : iPreferenceStore.getFloat(string);
    }

    public int getInt(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0 : iPreferenceStore.getInt(string);
    }

    public long getLong(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? 0L : iPreferenceStore.getLong(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPreferenceStore getReadStore(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name");
        }
        List<StoreEntry> list = this.storeEntries;
        synchronized (list) {
            for (StoreEntry storeEntry : this.storeEntries) {
                IPreferenceStore iPreferenceStore = storeEntry.store;
                if (!iPreferenceStore.contains(string)) continue;
                return iPreferenceStore;
            }
        }
        return null;
    }

    public String getString(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null ? "" : iPreferenceStore.getString(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPreferenceStore getWriteStore(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        if (iPreferenceStore == null) {
            StoreEntry[] storeEntryArray;
            int n = 0;
            List<StoreEntry> list = this.storeEntries;
            synchronized (list) {
                storeEntryArray = new StoreEntry[this.storeEntries.size()];
                for (StoreEntry storeEntry : this.storeEntries) {
                    if (!string.contains(storeEntry.scope)) continue;
                    storeEntryArray[n++] = storeEntry;
                }
            }
            if (n > 0) {
                Arrays.sort(storeEntryArray, 0, n, new Comparator<StoreEntry>(){

                    @Override
                    public int compare(StoreEntry storeEntry, StoreEntry storeEntry2) {
                        return storeEntry.scope.compareTo(storeEntry2.scope);
                    }
                });
                iPreferenceStore = storeEntryArray[n - 1].store;
            } else {
                iPreferenceStore = DeltaWalkerPlugin.getDefault().getPreferenceStore();
            }
        }
        return iPreferenceStore;
    }

    public boolean isDefault(String string) {
        IPreferenceStore iPreferenceStore = this.getReadStore(string);
        return iPreferenceStore == null || iPreferenceStore.isDefault(string);
    }

    public boolean needsSaving() {
        return false;
    }

    public void putValue(String string, String string2) {
        this.getWriteStore(string).putValue(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceStore(IPreferenceStore iPreferenceStore, String string) {
        StoreEntry storeEntry = new StoreEntry(iPreferenceStore, string);
        List<StoreEntry> list = this.storeEntries;
        synchronized (list) {
            if (this.storeEntries.remove(storeEntry)) {
                iPreferenceStore.removePropertyChangeListener(this.listener);
            }
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove((Object)iPropertyChangeListener);
    }

    public void setDefault(String string, boolean bl) {
        this.getWriteStore(string).setDefault(string, bl);
    }

    public void setDefault(String string, double d) {
        this.getWriteStore(string).setDefault(string, d);
    }

    public void setDefault(String string, float f) {
        this.getWriteStore(string).setDefault(string, f);
    }

    public void setDefault(String string, int n) {
        this.getWriteStore(string).setDefault(string, n);
    }

    public void setDefault(String string, long l) {
        this.getWriteStore(string).setDefault(string, l);
    }

    public void setDefault(String string, String string2) {
        this.getWriteStore(string).setDefault(string, string2);
    }

    public void setToDefault(String string) {
        this.getWriteStore(string).setToDefault(string);
    }

    public void setValue(String string, boolean bl) {
        this.getWriteStore(string).setValue(string, bl);
    }

    public void setValue(String string, double d) {
        this.getWriteStore(string).setValue(string, d);
    }

    public void setValue(String string, float f) {
        this.getWriteStore(string).setValue(string, f);
    }

    public void setValue(String string, int n) {
        this.getWriteStore(string).setValue(string, n);
    }

    public void setValue(String string, long l) {
        this.getWriteStore(string).setValue(string, l);
    }

    public void setValue(String string, String string2) {
        this.getWriteStore(string).setValue(string, string2);
    }

    private static class StoreEntry {
        public final String scope;
        public final IPreferenceStore store;

        public StoreEntry(IPreferenceStore iPreferenceStore, String string) {
            assert (iPreferenceStore != null);
            assert (string != null);
            this.store = iPreferenceStore;
            this.scope = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || !object.getClass().equals(this.getClass())) {
                return false;
            }
            StoreEntry storeEntry = (StoreEntry)object;
            return storeEntry.store.equals(this.store) && storeEntry.scope.equals(this.scope);
        }

        public int hashCode() {
            return (this.store.hashCode() << 16) + (this.scope.hashCode() >> 16);
        }
    }
}

