/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.differencer.range;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatMonitor
implements IProgressMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(StatMonitor.class);
    private static int ID = 0;
    private final int id;
    private final IProgressMonitor pm;
    private final long timeout;
    private int countBegin = 0;
    private int countDone = 0;
    private int countInternalWorked = 0;
    private int countTaskName = 0;
    private int countSubTask = 0;
    private int countWorked = 0;
    private volatile boolean cancel = false;
    private long last = 0L;

    StatMonitor(IProgressMonitor iProgressMonitor, long l) {
        this.pm = iProgressMonitor;
        this.timeout = l > 0L ? l : 2000L;
        this.id = ID++;
    }

    public void beginTask(String string, int n) {
        ++this.countBegin;
        if (this.pm != null) {
            this.pm.beginTask(string, n);
        }
    }

    public void done() {
        ++this.countDone;
        if (this.pm != null) {
            this.pm.done();
        }
    }

    void dump(long l) {
        LOG.warn(String.valueOf(l != 0L ? "At " + new Date(l) : "Finished") + " " + this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCheck() {
        long l = System.currentTimeMillis();
        boolean bl = false;
        StatMonitor statMonitor = this;
        synchronized (statMonitor) {
            if (l - this.last > this.timeout) {
                bl = true;
                this.last = l;
            }
        }
        if (bl) {
            this.dump(l);
        }
    }

    public void internalWorked(double d) {
        ++this.countInternalWorked;
        this.dumpCheck();
        if (this.pm != null) {
            this.pm.internalWorked(d);
        }
    }

    public boolean isCanceled() {
        if (this.pm != null) {
            return this.pm.isCanceled();
        }
        return this.cancel;
    }

    public void setCanceled(boolean bl) {
        this.cancel = true;
        if (this.pm != null) {
            this.pm.setCanceled(bl);
        }
    }

    public void setTaskName(String string) {
        ++this.countTaskName;
        if (this.pm != null) {
            this.pm.setTaskName(string);
        }
    }

    public void subTask(String string) {
        ++this.countSubTask;
        if (this.pm != null) {
            this.pm.subTask(string);
        }
    }

    public String toString() {
        return String.valueOf(this.id) + " countBegin=" + this.countBegin + ", countDone=" + this.countDone + ", countInternalWorked=" + this.countInternalWorked + ", countTaskName=" + this.countTaskName + ", countSubTask=" + this.countSubTask + ", countWorked=" + this.countWorked + ", cancel=" + this.cancel;
    }

    public void worked(int n) {
        ++this.countWorked;
        this.dumpCheck();
        if (this.pm != null) {
            this.pm.worked(n);
        }
    }
}

