/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.differencer.range;

import com.deltawalker.Msg;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.differencer.range.DiffRange;
import com.deltawalker.differencer.range.IRangeComparator;
import com.deltawalker.differencer.range.RangeDiff;
import com.deltawalker.differencer.range.RangeDifferencer;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.text.CharSequenceCharComparator;
import com.deltawalker.text.DocumentLineComparator;
import com.deltawalker.text.ITokenComparator;
import com.deltopia.IAsyncResult;
import com.deltopia.WorkerPool;
import com.deltopia.util.MemoryUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeDifferencerJob
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(RangeDifferencerJob.class);
    private static final DiffRange[] NO_DELTAS = new DiffRange[0];
    private volatile boolean computeInlines;
    private final List<DiffRange> dCache = new ArrayList<DiffRange>();
    private DiffRange[] deltas;
    private final RangeDifferencer differencer;
    private final Map<Role, IDocument> documents;
    private WorkerPool dThreadPool = new WorkerPool(1, 500L);
    private final List<ITextFilter> filters = new ArrayList<ITextFilter>();
    private final boolean ignoreCase;
    private final IProgressMonitor pm = new NullProgressMonitor();
    private final Map<Role, Position> ranges;
    private final boolean threeWay;

    public static IRegion getRegion(Position position) {
        Region region = null;
        if (position != null) {
            region = new Region(position.offset, position.length);
        }
        return region;
    }

    private static Position getTokenRangePosition(ITokenComparator iTokenComparator, int n, int n2) {
        int n3;
        int n4 = iTokenComparator.getTokenStart(n);
        if (n2 - n == 0) {
            n3 = 0;
        } else {
            int n5 = n2 - 1;
            n3 = iTokenComparator.getTokenStart(n5) + iTokenComparator.getTokenLength(n5) - n4;
        }
        return new Position(n4, n3);
    }

    public RangeDifferencerJob(Map<Role, IDocument> map, Map<Role, Position> map2, boolean bl, IPreferenceStore iPreferenceStore, IFilters iFilters) {
        super(Msg.Differencer_comparing);
        if (map == null) {
            throw new NullPointerException("documents");
        }
        if (iPreferenceStore == null) {
            throw new NullPointerException("prefs");
        }
        if (iFilters == null) {
            throw new NullPointerException("filters");
        }
        this.documents = new EnumMap<Role, IDocument>(map);
        this.ranges = map2 != null ? new EnumMap<Role, Position>(map2) : new EnumMap(Role.class);
        this.threeWay = bl;
        this.computeInlines = iPreferenceStore.getBoolean(PrefKey.T_DO_INLINE_DELTAS.toString());
        this.ignoreCase = iPreferenceStore.getBoolean(PrefKey.C_IGNORE_CHAR_CASE.toString());
        List<IFilter> list = iFilters.getAllAsList();
        for (IFilter iFilter : list) {
            if (!(iFilter instanceof ITextFilter) || !iFilter.isEnabled()) continue;
            this.filters.add((ITextFilter)iFilter);
        }
        this.differencer = new RangeDifferencer(iPreferenceStore);
        this.setUser(false);
    }

    public IAsyncResult beginInlineDeltaUpdate(DiffRange[] diffRangeArray) {
        Object object;
        if (this.dThreadPool == null || this.pm.isCanceled()) {
            return null;
        }
        boolean bl = false;
        DiffRange[] diffRangeArray2 = diffRangeArray;
        int n = diffRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = diffRangeArray2[n2];
            if (bl) break;
            bl = this.shouldRecomputeInlineDeltas((DiffRange)object);
            ++n2;
        }
        if (!bl) {
            return null;
        }
        object = new InlineDiffUpdateRunnable(diffRangeArray);
        this.dThreadPool.queueAssignment((Runnable)object);
        return object;
    }

    private void computeInlineDiffCreationData(DiffRange diffRange, List<InlineDiffCreationData> list) {
        EnumMap<Role, ITokenComparator> enumMap = new EnumMap<Role, ITokenComparator>(Role.class);
        RangeDiff[] rangeDiffArray = this.findInlineRangeDiffs(diffRange, enumMap);
        int n = 0;
        RangeDiff[] rangeDiffArray2 = rangeDiffArray;
        int n2 = rangeDiffArray.length;
        int n3 = 0;
        while (n3 < n2) {
            RangeDiff rangeDiff = rangeDiffArray2[n3];
            if (!rangeDiff.isSame()) {
                EnumMap<Role, Integer> enumMap2 = new EnumMap<Role, Integer>(Role.class);
                EnumMap<Role, Integer> enumMap3 = new EnumMap<Role, Integer>(Role.class);
                Set<Role> set = Relation.roles(this.threeWay);
                for (Role role : set) {
                    Position position = RangeDifferencerJob.getTokenRangePosition((ITokenComparator)enumMap.get((Object)role), rangeDiff.start(role), rangeDiff.end(role));
                    position.offset += diffRange.position((Role)role).offset;
                    enumMap2.put(role, position.offset);
                    enumMap3.put(role, position.offset + position.length);
                }
                Position object2 = diffRange.position(Role.REF);
                Position position = diffRange.position(Role.ONE);
                int n4 = object2.offset;
                int n5 = object2.offset + object2.length;
                int n6 = position.offset;
                int n7 = position.offset + position.length;
                if ((Integer)enumMap2.get((Object)Role.REF) != n4 || (Integer)enumMap3.get((Object)Role.REF) != n5 || (Integer)enumMap2.get((Object)Role.ONE) != n6 || (Integer)enumMap3.get((Object)Role.ONE) != n7) {
                    list.add(new InlineDiffCreationData(diffRange, rangeDiff.getKinds(), enumMap2, enumMap3));
                    ++n;
                }
            }
            ++n3;
        }
        if (n == 0) {
            diffRange.disposeChildren();
        }
    }

    protected ITokenComparator createComparator(IDocument iDocument, IRegion iRegion) {
        return new DocumentLineComparator(iDocument, iRegion, this.filters, this.ignoreCase);
    }

    private DiffRange[] createDiffs(RangeDiff[] rangeDiffArray, Map<Role, IRangeComparator> map) {
        DiffRange[] diffRangeArray;
        EnumMap<Role, Integer> enumMap = new EnumMap<Role, Integer>(Role.class);
        EnumMap<Role, Integer> enumMap2 = new EnumMap<Role, Integer>(Role.class);
        Set<Role> set = Relation.roles(this.threeWay);
        if (rangeDiffArray == null) {
            for (Role role : set) {
                enumMap.put(role, 0);
                enumMap2.put(role, this.documents.get((Object)role).getLength());
            }
            diffRangeArray = new DiffRange[]{new DiffRange(null, this.documents, this.ranges, enumMap, enumMap2)};
        } else {
            int n = rangeDiffArray.length;
            diffRangeArray = new DiffRange[n];
            int n2 = 0;
            while (n2 < n) {
                RangeDiff rangeDiff = rangeDiffArray[n2];
                for (Role role : set) {
                    ITokenComparator iTokenComparator = (ITokenComparator)map.get((Object)role);
                    Position position = RangeDifferencerJob.getTokenRangePosition(iTokenComparator, rangeDiff.start(role), rangeDiff.end(role));
                    enumMap.put(role, position.offset);
                    enumMap2.put(role, position.offset + position.length);
                }
                diffRangeArray[n2] = new DiffRange(rangeDiff.getKinds(), this.documents, this.ranges, enumMap, enumMap2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(diffRangeArray[n2].toString());
                }
                ++n2;
            }
        }
        return diffRangeArray;
    }

    protected DiffRange[] createInlineDiffs(InlineDiffCreationData[] inlineDiffCreationDataArray) {
        DiffRange[] diffRangeArray = new DiffRange[inlineDiffCreationDataArray.length];
        int n = 0;
        while (n < inlineDiffCreationDataArray.length) {
            InlineDiffCreationData inlineDiffCreationData = inlineDiffCreationDataArray[n];
            EnumMap<Role, Position> enumMap = new EnumMap<Role, Position>(Role.class);
            diffRangeArray[n] = new DiffRange(inlineDiffCreationData.parent, inlineDiffCreationData.kinds, this.documents, enumMap, inlineDiffCreationData.starts, inlineDiffCreationData.ends);
            ++n;
        }
        return diffRangeArray;
    }

    public void dispose() {
        this.pm.setCanceled(true);
        if (this.dThreadPool != null) {
            this.dThreadPool.beginShutdown();
            this.dThreadPool = null;
        }
        this.cancel();
    }

    private RangeDiff[] findInlineRangeDiffs(DiffRange diffRange, Map<Role, ITokenComparator> map) {
        Position position;
        assert (map != null);
        EnumMap<Role, Position> enumMap = new EnumMap<Role, Position>(Role.class);
        int n = 0;
        Set<Role> set = Relation.roles(this.threeWay);
        for (Role object2 : set) {
            position = diffRange.position(object2);
            enumMap.put(object2, position);
            if (position.length == 0) continue;
            ++n;
        }
        if (n < 2) {
            return RangeDiff.EMPTY_ARRAY;
        }
        n = 0;
        for (Role role : set) {
            String string;
            position = (Position)enumMap.get((Object)role);
            if (position == null) continue;
            try {
                string = this.documents.get((Object)role).get(position.offset, position.length);
                ++n;
            }
            catch (BadLocationException badLocationException) {
                string = "";
            }
            map.put(role, new CharSequenceCharComparator(string, this.filters, this.ignoreCase));
        }
        if (n < 2) {
            return RangeDiff.EMPTY_ARRAY;
        }
        RangeDiff[] rangeDiffArray = this.differencer.findTrueDeltas(this.pm, map, RangeDifferencer.Target.CHARS);
        MemoryUtil.dumpMemoryUsage((Logger)LOG, (String)"<- findInlineRangeDiffs");
        return rangeDiffArray;
    }

    public DiffRange[] getDeltas() {
        return this.deltas != null ? this.deltas : NO_DELTAS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guardedUpdateInlineDiffs(DiffRange[] diffRangeArray) {
        block17: {
            if (this.pm.isCanceled()) {
                return;
            }
            List<DiffRange> list = this.dCache;
            synchronized (list) {
                int n = this.dCache.size();
                DiffRange[] diffRangeArray2 = diffRangeArray;
                int n2 = diffRangeArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    DiffRange diffRange = diffRangeArray2[n3];
                    if (!this.dCache.contains(diffRange)) {
                        this.dCache.add(diffRange);
                    }
                    ++n3;
                }
                if (n == this.dCache.size()) {
                    return;
                }
            }
            try {
                this.unguardedUpdateInlineDiffs(diffRangeArray);
                break block17;
            }
            catch (Throwable throwable) {
                List<DiffRange> list2 = this.dCache;
                synchronized (list2) {
                    int n = 0;
                    while (n < diffRangeArray.length) {
                        this.dCache.remove(diffRangeArray[n]);
                        ++n;
                    }
                }
            }
            throw throwable;
        }
        List<DiffRange> list = this.dCache;
        synchronized (list) {
            int n = 0;
            while (n < diffRangeArray.length) {
                this.dCache.remove(diffRangeArray[n]);
                ++n;
            }
        }
    }

    public IStatus run() {
        return this.run(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        MemoryUtil.dumpMemoryUsage((Logger)LOG, (String)"Start RangeDiffJob");
        Class<OutOfMemoryError> clazz = OutOfMemoryError.class;
        synchronized (OutOfMemoryError.class) {
            EnumMap<Role, IRangeComparator> enumMap = new EnumMap<Role, IRangeComparator>(Role.class);
            for (Role rangeDiffArray2 : Relation.roles(this.threeWay)) {
                enumMap.put(rangeDiffArray2, this.createComparator(this.documents.get((Object)rangeDiffArray2), RangeDifferencerJob.getRegion(this.ranges.get((Object)rangeDiffArray2))));
            }
            MemoryUtil.dumpMemoryUsage((Logger)LOG, (String)"Before findAllDeltas");
            RangeDiff[] rangeDiffArray = this.differencer.findAllDeltas((IProgressMonitor)(this.isUser() ? iProgressMonitor : null), enumMap, RangeDifferencer.Target.LINES);
            MemoryUtil.dumpMemoryUsage((Logger)LOG, (String)"Before createDiffs");
            this.deltas = this.createDiffs(rangeDiffArray, enumMap);
            MemoryUtil.dumpMemoryUsage((Logger)LOG, (String)"Finish RangeDiffJob");
            // ** MonitorExit[clazz] (shouldn't be in output)
            return Status.OK_STATUS;
        }
    }

    public void setComputeInlineDeltas(boolean bl) {
        this.computeInlines = bl;
    }

    public boolean shouldComputeInlineDeltas() {
        return this.computeInlines;
    }

    private boolean shouldRecomputeInlineDeltas(DiffRange diffRange) {
        if (!this.computeInlines || diffRange.isSame()) {
            return false;
        }
        return !diffRange.hasChildren();
    }

    private void unguardedUpdateInlineDiffs(DiffRange[] diffRangeArray) {
        ArrayList<InlineDiffCreationData> arrayList = new ArrayList<InlineDiffCreationData>();
        DiffRange[] diffRangeArray2 = diffRangeArray;
        int n = diffRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiffRange diffRange = diffRangeArray2[n2];
            if (this.pm.isCanceled()) break;
            if (this.shouldRecomputeInlineDeltas(diffRange)) {
                this.computeInlineDiffCreationData(diffRange, arrayList);
            }
            ++n2;
        }
        if (!this.pm.isCanceled()) {
            this.createInlineDiffs(arrayList.toArray(new InlineDiffCreationData[arrayList.size()]));
        }
    }

    public static class InlineDiffCreationData {
        public final Map<Role, Integer> ends;
        Map<Relation, Delta.Kind> kinds;
        public final DiffRange parent;
        public final Map<Role, Integer> starts;

        public InlineDiffCreationData(DiffRange diffRange, Map<Relation, Delta.Kind> map, Map<Role, Integer> map2, Map<Role, Integer> map3) {
            this.parent = diffRange;
            this.kinds = map;
            this.starts = new EnumMap<Role, Integer>(map2);
            this.ends = new EnumMap<Role, Integer>(map3);
        }
    }

    private class InlineDiffUpdateRunnable
    implements IAsyncResult,
    Runnable {
        private static final int RUN_TIMEOUT = 100;
        private final DiffRange[] dRanges;
        private boolean run;

        public InlineDiffUpdateRunnable(DiffRange[] diffRangeArray) {
            this.dRanges = diffRangeArray;
        }

        public synchronized void join() throws InterruptedException {
            while (!this.run) {
                this.wait(100L);
            }
        }

        @Override
        public synchronized void run() {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("-> guardedUpdateInlineDiffs ranges: " + (this.dRanges.length == 1 ? this.dRanges[0] : Integer.valueOf(this.dRanges.length)));
                }
                RangeDifferencerJob.this.guardedUpdateInlineDiffs(this.dRanges);
                MemoryUtil.dumpMemoryUsage((Logger)LOG, (String)"<- guardedUpdateInlineDiffs");
            }
            finally {
                this.run = true;
                this.notifyAll();
            }
        }

        public String toString() {
            return "InlineDiffUpdate " + System.identityHashCode(this);
        }
    }
}

