/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.differencer.range;

import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.differencer.range.IRangeComparator;
import com.deltawalker.differencer.range.RangeDiff;
import com.deltawalker.internal.DiffIterator;
import com.deltawalker.internal.SuboptimalDifferencer;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public final class RangeDifferencer {
    public static final RangeDiff[] EMPTY_RESULT = new RangeDiff[0];
    private final boolean useOptimal;

    private static RangeDiff create3WayDiffRange(DiffIterator diffIterator, DiffIterator diffIterator2, List<RangeDiff> list, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, int n, int n2) {
        int n3;
        int n4;
        RangeDiff rangeDiff;
        RangeDiff rangeDiff2;
        int n5;
        int n6;
        int n7 = n2 - n;
        Delta.Kind kind = Delta.Kind.SAME;
        Relation relation = null;
        EnumMap<Relation, Delta.Kind> enumMap = new EnumMap<Relation, Delta.Kind>(Relation.class);
        RangeDiff rangeDiff3 = list.get(list.size() - 1);
        assert (diffIterator.count() != 0 || diffIterator2.count() != 0);
        if (diffIterator.count() == 0) {
            relation = Relation.REF_ONE;
            n6 = Math.abs(n - rangeDiff3.end0() + rangeDiff3.end2());
            n5 = Math.abs(n2 - rangeDiff3.end0() + rangeDiff3.end2());
        } else {
            rangeDiff2 = diffIterator.diffs.get(0);
            rangeDiff = diffIterator.diffs.get(diffIterator.diffs.size() - 1);
            n6 = Math.abs(n - rangeDiff2.start1() + rangeDiff2.start2());
            n5 = Math.abs(n2 - rangeDiff.end1() + rangeDiff.end2());
        }
        int n8 = n5 - n6;
        if (diffIterator2.count() == 0) {
            relation = Relation.REF_TWO;
            n4 = Math.abs(n - rangeDiff3.end0() + rangeDiff3.end1());
            n3 = Math.abs(n2 - rangeDiff3.end0() + rangeDiff3.end1());
        } else {
            rangeDiff2 = diffIterator2.diffs.get(0);
            rangeDiff = diffIterator2.diffs.get(diffIterator2.diffs.size() - 1);
            n4 = Math.abs(n - rangeDiff2.start1() + rangeDiff2.start2());
            n3 = Math.abs(n2 - rangeDiff.end1() + rangeDiff.end2());
        }
        int n9 = n3 - n4;
        kind = n7 == 0 ? Delta.Kind.ADDED : (n9 == 0 || n8 == 0 ? Delta.Kind.DELETED : Delta.Kind.CHANGED);
        if (relation == null) {
            enumMap.put(Relation.REF_ONE, kind);
            enumMap.put(Relation.REF_TWO, kind);
            if (RangeDifferencer.rangeSpansEqual(iRangeComparator, n6, n8, iRangeComparator2, n4, n9)) {
                enumMap.put(Relation.ONE_TWO, Delta.Kind.SAME);
            } else {
                enumMap.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
            }
        } else {
            enumMap.put(relation, kind);
            if (relation == Relation.REF_ONE) {
                enumMap.put(Relation.REF_TWO, Delta.Kind.SAME);
            } else if (relation == Relation.REF_TWO) {
                enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
            }
            enumMap.put(Relation.ONE_TWO, Delta.Kind.SAME);
        }
        return new RangeDiff(enumMap, n6, n8, n4, n9, n, n7);
    }

    private static boolean rangeSpansEqual(IRangeComparator iRangeComparator, int n, int n2, IRangeComparator iRangeComparator2, int n3, int n4) {
        if (n2 == n4) {
            int n5 = 0;
            n5 = 0;
            while (n5 < n2) {
                if (!iRangeComparator.rangesEqual(n + n5, iRangeComparator2, n3 + n5)) break;
                ++n5;
            }
            if (n5 == n2) {
                return true;
            }
        }
        return false;
    }

    public RangeDifferencer(IPreferenceStore iPreferenceStore) {
        this.useOptimal = iPreferenceStore.getBoolean(PrefKey.C_USE_OPTIMAL_DIFFERENCER.toString());
    }

    public RangeDiff[] findAll2WayDeltas(IProgressMonitor iProgressMonitor, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2) {
        RangeDiff rangeDiff;
        RangeDiff[] rangeDiffArray = this.findTrue2WayDeltas(iProgressMonitor, iRangeComparator, iRangeComparator2, false);
        ArrayList<RangeDiff> arrayList = new ArrayList<RangeDiff>();
        int n = 0;
        int n2 = 0;
        RangeDiff[] rangeDiffArray2 = rangeDiffArray;
        int n3 = rangeDiffArray.length;
        int n4 = 0;
        while (n4 < n3) {
            RangeDiff rangeDiff2 = rangeDiffArray2[n4];
            rangeDiff = new RangeDiff(Relation.REF_ONE, Delta.Kind.SAME, 0, 0, n2, rangeDiff2.start1() - n2, n, rangeDiff2.start0() - n);
            if (rangeDiff.maxLength() != 0) {
                arrayList.add(rangeDiff);
            }
            arrayList.add(rangeDiff2);
            n2 = rangeDiff2.end1();
            n = rangeDiff2.end0();
            ++n4;
        }
        rangeDiff = new RangeDiff(Relation.REF_ONE, Delta.Kind.SAME, 0, 0, n2, iRangeComparator2.getRangeCount() - n2, n, iRangeComparator.getRangeCount() - n);
        if (rangeDiff.maxLength() > 0) {
            arrayList.add(rangeDiff);
        }
        return arrayList.toArray(EMPTY_RESULT);
    }

    public RangeDiff[] findAllDeltas(IProgressMonitor iProgressMonitor, Map<Role, IRangeComparator> map, Target target) {
        RangeDiff rangeDiff;
        int n;
        int n2;
        int n3;
        IRangeComparator iRangeComparator = map.get((Object)Role.REF);
        IRangeComparator iRangeComparator2 = map.get((Object)Role.ONE);
        IRangeComparator iRangeComparator3 = map.get((Object)Role.TWO);
        if (iRangeComparator3 == null) {
            return this.findAll2WayDeltas(iProgressMonitor, iRangeComparator, iRangeComparator2);
        }
        RangeDiff[] rangeDiffArray = this.findTrueDeltas(iProgressMonitor, map, target);
        ArrayList<RangeDiff> arrayList = new ArrayList<RangeDiff>();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        EnumMap<Relation, Delta.Kind> enumMap = new EnumMap<Relation, Delta.Kind>(Relation.class);
        enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
        enumMap.put(Relation.REF_TWO, Delta.Kind.SAME);
        enumMap.put(Relation.ONE_TWO, Delta.Kind.SAME);
        RangeDiff[] rangeDiffArray2 = rangeDiffArray;
        int n7 = rangeDiffArray.length;
        int n8 = 0;
        while (n8 < n7) {
            RangeDiff rangeDiff2 = rangeDiffArray2[n8];
            n3 = rangeDiff2.start2() - n6;
            rangeDiff = new RangeDiff(enumMap, n6, n3, n5, n2 = rangeDiff2.start1() - n5, n4, n = rangeDiff2.start0() - n4);
            if (rangeDiff.maxLength() > 0) {
                arrayList.add(rangeDiff);
            }
            arrayList.add(rangeDiff2);
            n6 = rangeDiff2.end2();
            n5 = rangeDiff2.end1();
            n4 = rangeDiff2.end0();
            ++n8;
        }
        n3 = iRangeComparator3.getRangeCount() - n6;
        rangeDiff = new RangeDiff(enumMap, n6, n3, n5, n2 = iRangeComparator2.getRangeCount() - n5, n4, n = iRangeComparator.getRangeCount() - n4);
        if (rangeDiff.maxLength() > 0) {
            arrayList.add(rangeDiff);
        }
        return arrayList.toArray(EMPTY_RESULT);
    }

    public RangeDiff[] findTrue2WayDeltas(IProgressMonitor iProgressMonitor, IRangeComparator iRangeComparator, IRangeComparator iRangeComparator2, boolean bl) {
        assert (iRangeComparator2.getClass().equals(iRangeComparator.getClass()));
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        return SuboptimalDifferencer.findDiffs(iProgressMonitor, iRangeComparator, iRangeComparator2, bl);
    }

    public RangeDiff[] findTrueDeltas(IProgressMonitor iProgressMonitor, Map<Role, ? extends IRangeComparator> map, Target target) {
        IRangeComparator iRangeComparator = map.get((Object)Role.REF);
        IRangeComparator iRangeComparator2 = map.get((Object)Role.ONE);
        IRangeComparator iRangeComparator3 = map.get((Object)Role.TWO);
        if (iRangeComparator3 == null) {
            return this.findTrue2WayDeltas(iProgressMonitor, iRangeComparator, iRangeComparator2, false);
        }
        RangeDiff[] rangeDiffArray = null;
        RangeDiff[] rangeDiffArray2 = this.findTrue2WayDeltas(iProgressMonitor, iRangeComparator, iRangeComparator3, true);
        if (rangeDiffArray2 != null) {
            rangeDiffArray = this.findTrue2WayDeltas(iProgressMonitor, iRangeComparator, iRangeComparator2, true);
        }
        if (rangeDiffArray2 == null || rangeDiffArray == null) {
            return RangeDiff.EMPTY_ARRAY;
        }
        DiffIterator diffIterator = new DiffIterator(rangeDiffArray);
        DiffIterator diffIterator2 = new DiffIterator(rangeDiffArray2);
        LinkedList<RangeDiff> linkedList = new LinkedList<RangeDiff>();
        linkedList.add(new RangeDiff());
        int n = 0;
        int n2 = 0;
        while (diffIterator2.diff != null || diffIterator.diff != null) {
            DiffIterator diffIterator3;
            boolean bl = true;
            diffIterator2.removeAll();
            diffIterator.removeAll();
            if (diffIterator2.diff == null) {
                diffIterator3 = diffIterator;
            } else if (diffIterator.diff == null) {
                diffIterator3 = diffIterator2;
            } else if (target == Target.CHARS && diffIterator.diff.length1() > 0 && diffIterator.diff.isDeleted(Role.TWO)) {
                diffIterator3 = diffIterator2;
                bl = false;
            } else if (target == Target.CHARS && diffIterator2.diff.length1() > 0 && diffIterator2.diff.isDeleted(Role.TWO)) {
                diffIterator3 = diffIterator;
                bl = false;
            } else if (diffIterator2.diff.start1() < diffIterator.diff.start1()) {
                diffIterator3 = diffIterator2;
            } else if (diffIterator.diff.start1() < diffIterator2.diff.start1()) {
                diffIterator3 = diffIterator;
            } else {
                if (diffIterator2.diff.length1() == 0 && diffIterator.diff.length1() == 0) {
                    n = diffIterator2.diff.start1();
                    n2 = diffIterator2.diff.end1();
                    diffIterator2.next();
                    diffIterator.next();
                    linkedList.add(RangeDifferencer.create3WayDiffRange(diffIterator2, diffIterator, linkedList, iRangeComparator3, iRangeComparator2, n, n2));
                    continue;
                }
                diffIterator3 = diffIterator2.diff.length1() == 0 ? diffIterator2 : (diffIterator.diff.length1() == 0 ? diffIterator : diffIterator2);
            }
            n = diffIterator3.diff.start1();
            n2 = diffIterator3.diff.end1();
            diffIterator3.next();
            DiffIterator diffIterator4 = diffIterator3.other(diffIterator2, diffIterator);
            while (diffIterator4.diff != null && diffIterator4.diff.start1() <= n2) {
                int n3 = diffIterator4.diff.end1();
                diffIterator4.next();
                if (!bl || n3 <= n2) continue;
                n2 = n3;
                diffIterator4 = diffIterator4.other(diffIterator2, diffIterator);
            }
            linkedList.add(RangeDifferencer.create3WayDiffRange(diffIterator2, diffIterator, linkedList, iRangeComparator3, iRangeComparator2, n, n2));
        }
        linkedList.remove(0);
        return linkedList.toArray(EMPTY_RESULT);
    }

    public static enum Target {
        CHARS,
        LINES;

    }
}

