/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.differencer.range;

import com.deltawalker.Delta;
import com.deltawalker.Relation;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import java.util.Map;

public class RangeDiff
extends Delta {
    public static RangeDiff[] EMPTY_ARRAY = new RangeDiff[0];
    private final int length0;
    private final int length1;
    private final int length2;
    private final int start0;
    private final int start1;
    private final int start2;

    RangeDiff() {
        this.start2 = 0;
        this.length2 = 0;
        this.start1 = 0;
        this.length1 = 0;
        this.start0 = 0;
        this.length0 = 0;
    }

    public RangeDiff(Delta.Kind kind, int n, int n2, int n3, int n4) {
        super(Relation.REF_ONE, kind);
        this.validate(0, 0, n, n2, n3, n4);
        this.start2 = 0;
        this.length2 = 0;
        this.start1 = n;
        this.length1 = n2;
        this.start0 = n3;
        this.length0 = n4;
    }

    RangeDiff(Map<Relation, Delta.Kind> map, int n, int n2, int n3, int n4, int n5, int n6) {
        super(map);
        this.validate(n, n2, n3, n4, n5, n6);
        this.start2 = n;
        this.length2 = n2;
        this.start1 = n3;
        this.length1 = n4;
        this.start0 = n5;
        this.length0 = n6;
    }

    public RangeDiff(Relation relation, Delta.Kind kind, int n, int n2, int n3, int n4, int n5, int n6) {
        super(relation, kind);
        this.validate(n, n2, n3, n4, n5, n6);
        this.start2 = n;
        this.length2 = n2;
        this.start1 = n3;
        this.length1 = n4;
        this.start0 = n5;
        this.length0 = n6;
    }

    public int end(Role role) {
        switch (role) {
            case REF: {
                return this.start0 + this.length0;
            }
            case ONE: {
                return this.start1 + this.length1;
            }
            case TWO: {
                return this.start2 + this.length2;
            }
        }
        throw new IllegalStateException();
    }

    public int end0() {
        return this.start0 + this.length0;
    }

    public int end1() {
        return this.start1 + this.length1;
    }

    public int end2() {
        return this.start2 + this.length2;
    }

    public boolean isDeleted(Role role) {
        switch (role) {
            case REF: {
                return this.start0 == 0 && this.length0 == 0;
            }
            case ONE: {
                return this.start1 == 0 && this.length1 == 0;
            }
            case TWO: {
                return this.start2 == 0 && this.length2 == 0;
            }
        }
        throw new IllegalStateException();
    }

    public int length(Role role) {
        switch (role) {
            case REF: {
                return this.length0;
            }
            case ONE: {
                return this.length1;
            }
            case TWO: {
                return this.length2;
            }
        }
        throw new IllegalStateException();
    }

    public int length0() {
        return this.length0;
    }

    public int length1() {
        return this.length1;
    }

    public int length2() {
        return this.length2;
    }

    public int maxLength() {
        return Math.max(this.length1, Math.max(this.length2, this.length0));
    }

    public int start(Role role) {
        switch (role) {
            case REF: {
                return this.start0;
            }
            case ONE: {
                return this.start1;
            }
            case TWO: {
                return this.start2;
            }
        }
        throw new IllegalArgumentException("role");
    }

    public int start0() {
        return this.start0;
    }

    public int start1() {
        return this.start1;
    }

    public int start2() {
        return this.start2;
    }

    @Override
    public String toString() {
        String string = String.valueOf(super.toString()) + " s0=" + this.start0 + ", l0=" + this.length0 + ", s1=" + this.start1 + ", l1=" + this.length1 + ", s2=" + this.start2 + ", l2=" + this.length2;
        return string;
    }

    private void validate(int n, int n2, int n3, int n4, int n5, int n6) {
        assert (n5 >= 0);
        assert (n6 >= 0);
        assert (n3 >= 0);
        assert (n >= 0);
    }
}

