/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.differencer.range;

import com.deltawalker.Delta;
import com.deltawalker.Relation;
import com.deltawalker.script.Delta;
import com.deltawalker.script.DeltaRange;
import com.deltawalker.script.Role;
import com.deltopia.util.Checker;
import com.deltopia.util.LifecycleUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class DiffRange
extends Delta
implements DeltaRange {
    public static DiffRange[] EMPTY_ARRAY = new DiffRange[0];
    private Set<DiffRange> children;
    private final Position[] ranges;
    private boolean resolved;

    public DiffRange(DiffRange diffRange, Map<Relation, Delta.Kind> map, Map<Role, IDocument> map2, Map<Role, Position> map3, Map<Role, Integer> map4, Map<Role, Integer> map5) {
        this(map, map2, map3, map4, map5);
        if (diffRange != null) {
            this.parent = diffRange;
            diffRange.addChild(this);
        }
    }

    public DiffRange(Map<Relation, Delta.Kind> map, Map<Role, IDocument> map2, Map<Role, Position> map3, Map<Role, Integer> map4, Map<Role, Integer> map5) {
        super(map);
        this.ranges = new Position[map2.size()];
        Set<Role> set = map2.keySet();
        for (Role role : set) {
            Position position;
            this.ranges[role.toInt()] = position = this.createPosition(map2.get((Object)role), map3.get((Object)role), map4.get((Object)role), map5.get((Object)role));
        }
    }

    private synchronized void addChild(DiffRange diffRange) {
        if (this.children == null) {
            this.children = Collections.newSetFromMap(new ConcurrentHashMap());
        }
        this.children.add(diffRange);
    }

    public synchronized Set<DiffRange> children() {
        return this.children != null ? Collections.unmodifiableSet(this.children) : null;
    }

    @Override
    public synchronized boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    private Position createPosition(IDocument iDocument, Position position, int n, int n2) {
        int n3;
        int n4;
        if (iDocument == null) {
            return null;
        }
        if (position != null) {
            n4 = position.offset;
            n3 = n4 + position.length;
        } else {
            n4 = 0;
            n3 = n4 + iDocument.getLength();
        }
        if (n < n4) {
            n = n4;
        } else if (n3 < n) {
            n = n3;
        }
        if (n2 < n4) {
            n2 = n4;
        } else if (n3 < n2) {
            n2 = n3;
        }
        Position position2 = new Position(n, n2 - n);
        try {
            iDocument.addPosition("DocumentRangeCategory", position2);
        }
        catch (BadLocationException | BadPositionCategoryException throwable) {}
        return position2;
    }

    @Override
    public void dispose() {
        Set<DiffRange> set;
        DiffRange diffRange = this.getParent();
        super.dispose();
        this.disposeChildren();
        if (diffRange != null && (set = diffRange.children) != null) {
            set.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeChildren() {
        Set<DiffRange> set;
        DiffRange diffRange = this;
        synchronized (diffRange) {
            set = this.children;
            this.children = null;
        }
        LifecycleUtil.disposeAll(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeltaRange[] getChildren() {
        Set<DiffRange> set;
        DiffRange diffRange = this;
        synchronized (diffRange) {
            set = this.children;
        }
        return set != null ? set.toArray(new DiffRange[set.size()]) : EMPTY_ARRAY;
    }

    @Override
    public DiffRange getParent() {
        return (DiffRange)this.parent;
    }

    private boolean hasTrueDeltaForRole(Role role) {
        Map<Relation, Delta.Kind> map = this.getKinds();
        for (Map.Entry<Relation, Delta.Kind> entry : map.entrySet()) {
            Relation relation;
            Delta.Kind kind = entry.getValue();
            if (kind == Delta.Kind.SAME || !(relation = entry.getKey()).contains(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public boolean isThreeWay() {
        return this.ranges.length >= 3;
    }

    @Override
    public int length(Role role) {
        if (role == null) {
            throw new NullPointerException("'role' cannot be null.");
        }
        return this.position((Role)role).length;
    }

    @Override
    public int offset(Role role) {
        if (role == null) {
            throw new NullPointerException("'role' cannot be null.");
        }
        return this.position((Role)role).offset;
    }

    public Position position(Role role) {
        Checker.notNull((Object)((Object)role), (String)"role");
        int n = role.toInt();
        if (n >= this.ranges.length) {
            throw new IllegalArgumentException("Try to use invalid role " + (Object)((Object)role) + " in range: " + this);
        }
        return this.ranges[n];
    }

    public void setResolved(boolean bl) {
        this.resolved = bl;
        if (this.resolved) {
            this.dispose();
        }
    }

    public boolean shouldSkipPaint(Role role) {
        if (this.isSame()) {
            return true;
        }
        return this.isThreeWay() && (role == Role.ONE && !this.hasTrueDeltaForRole(Role.ONE) || role == Role.TWO && !this.hasTrueDeltaForRole(Role.TWO));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append(" : ");
        Set<Role> set = Relation.roles(this.isThreeWay());
        for (Role role : set) {
            Position position = this.ranges[role.toInt()];
            stringBuilder.append((Object)role).append(": ").append(position).append(" ");
        }
        return stringBuilder.toString();
    }
}

