/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker.differencer;

import com.deltawalker.App;
import com.deltawalker.DeltaNodeDetail;
import com.deltawalker.DiffMethodUtil;
import com.deltawalker.EncodingUtil;
import com.deltawalker.IStreamContentAccessor;
import com.deltawalker.IStructElement;
import com.deltawalker.IStructPropertyProvider;
import com.deltawalker.InputStreamUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.Relation;
import com.deltawalker.ResourceDelta;
import com.deltawalker.StructProperty;
import com.deltawalker.differencer.range.RangeDiff;
import com.deltawalker.differencer.range.RangeDifferencer;
import com.deltawalker.interfaces.IDiffNode;
import com.deltawalker.interfaces.IEncodedStreamContentAccessor;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.ITextFilter;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.Delta;
import com.deltawalker.script.Role;
import com.deltawalker.structure.IStructComparator;
import com.deltawalker.text.DocumentLineComparator;
import com.deltopia.AdaptableUtil;
import com.deltopia.eclipse.util.AttributesFormatter;
import com.deltopia.eclipse.util.SizeFormatter;
import com.deltopia.eclipse.util.TimeFormatter;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.IO;
import com.deltopia.io.IStreamProvider;
import com.deltopia.io.StreamUtil;
import com.deltopia.io.VfsUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Differencer {
    private static final long HOUR_MILLIS = 3600000L;
    private static final Logger LOG = LoggerFactory.getLogger(Differencer.class);
    private static final int UNKNOWN_DIFF_COUNT = 1;
    private static final int UNSUPPORTED_DIFF_COUNT = -1;
    private final long bbbThreshold;
    private final boolean byContent;
    private String charset;
    private final boolean compareBbb;
    private final long dateThreshold;
    private final List<ITextFilter> filters = new ArrayList<ITextFilter>();
    private final boolean ignoreCase;
    private final boolean ignoreDaylight;
    private final boolean ignoreTimezone;
    private final Set<Comparison.Method> method;
    private final IPreferenceStore prefs;
    private RangeDifferencer rgDifferencer;
    private final Set<Comparison.Method> umMethod;

    public static Reader getContents(Object object, String string) throws IOException {
        CharSequence charSequence = (CharSequence)AdaptableUtil.getAdapter((Object)object, CharSequence.class);
        if (charSequence != null) {
            return new StringReader(charSequence.toString());
        }
        Reader reader = null;
        try (InputStream inputStream = null;){
            String string2 = null;
            if (object instanceof DifferencerInput) {
                DifferencerInput differencerInput = (DifferencerInput)object;
                inputStream = differencerInput.getInputStream();
                string2 = differencerInput.getCharset();
            } else {
                IStreamContentAccessor iStreamContentAccessor = (IStreamContentAccessor)AdaptableUtil.getAdapter((Object)object, IStreamContentAccessor.class);
                if (iStreamContentAccessor != null) {
                    inputStream = iStreamContentAccessor.getContents();
                    if (iStreamContentAccessor instanceof IEncodedStreamContentAccessor) {
                        try {
                            string2 = ((IEncodedStreamContentAccessor)iStreamContentAccessor).getEncoding().charset();
                        }
                        catch (CoreException coreException) {
                            IOException iOException = new IOException();
                            iOException.initCause(coreException);
                            throw iOException;
                        }
                    }
                }
            }
            if (inputStream != null) {
                reader = InputStreamUtil.getReader(inputStream, string2, string);
            }
        }
        return reader;
    }

    public static String getDeltaDetailAsString(IDiffNode iDiffNode, Relation relation) {
        DeltaNodeDetail deltaNodeDetail = iDiffNode.detail(relation);
        if (deltaNodeDetail != null && deltaNodeDetail.total > 0) {
            Set<Comparison.Method> set = deltaNodeDetail.method;
            if (set.contains((Object)Comparison.Method.AS_TEXT)) {
                return Integer.toString(deltaNodeDetail.total);
            }
            return DiffMethodUtil.format(set);
        }
        return "";
    }

    public static String getPropertyValueAsString(IStructPropertyProvider iStructPropertyProvider, StructProperty structProperty) {
        if (iStructPropertyProvider == null) {
            return "";
        }
        Object object = iStructPropertyProvider.getValue(structProperty);
        if (object == null) {
            return "";
        }
        switch (structProperty) {
            case ATTRIBUTES: {
                Object object2 = iStructPropertyProvider.getValue(StructProperty.RESOURCE_FORK_SIZE);
                long l = ((Number)object2).longValue();
                return AttributesFormatter.format(((Number)object).intValue(), l > 0L);
            }
            case DATE_CREATED: 
            case DATE_MODIFIED: 
            case DATE_OPENED: {
                return TimeFormatter.formatShort(((Number)object).longValue());
            }
            case SIZE: {
                return SizeFormatter.format(((Number)object).longValue(), 2);
            }
            case OWNER: {
                return object.toString();
            }
            case GROUP: {
                return object.toString();
            }
        }
        return object.toString();
    }

    public Differencer(Set<Comparison.Method> set, IPreferenceStore iPreferenceStore, IFilters iFilters) {
        if (set == null) {
            throw new NullPointerException("method");
        }
        if (iPreferenceStore == null) {
            throw new NullPointerException("prefs");
        }
        if (iFilters == null) {
            throw new NullPointerException("filters");
        }
        this.prefs = iPreferenceStore;
        this.method = EnumSet.copyOf(set);
        this.umMethod = Collections.unmodifiableSet(set);
        this.compareBbb = iPreferenceStore.getBoolean(PrefKey.D_COMP_BBB_THRESHOLD_ON.toString());
        this.byContent = iPreferenceStore.getBoolean(PrefKey.D_COMP_BY_CONTENT.toString());
        this.bbbThreshold = 1024L * (long)iPreferenceStore.getInt(PrefKey.D_COMP_BBB_THRESHOLD.toString());
        this.dateThreshold = iPreferenceStore.getBoolean(PrefKey.D_COMP_DATE_THRESHOLD_ON.toString()) ? iPreferenceStore.getLong(PrefKey.D_COMP_DATE_THRESHOLD.toString()) : 0L;
        this.ignoreDaylight = iPreferenceStore.getBoolean(PrefKey.D_COMP_IGNORE_DAYLIGHT_DIFFS.toString());
        this.ignoreTimezone = iPreferenceStore.getBoolean(PrefKey.D_COMP_IGNORE_TIMEZONE_DIFFS.toString());
        this.ignoreCase = iPreferenceStore.getBoolean(PrefKey.C_IGNORE_CHAR_CASE.toString());
        if (iFilters != null) {
            List<IFilter> list = iFilters.getAllAsList();
            for (IFilter iFilter : list) {
                if (!(iFilter instanceof ITextFilter)) continue;
                this.filters.add((ITextFilter)iFilter);
            }
        }
        this.charset = EncodingUtil.getEncoding(iPreferenceStore);
    }

    public ResourceDelta compare(boolean bl, IStructPropertyProvider iStructPropertyProvider, IStructPropertyProvider iStructPropertyProvider2, IStructPropertyProvider iStructPropertyProvider3, IProgressMonitor iProgressMonitor) throws IOException {
        EnumMap<Relation, Delta.Kind> enumMap = new EnumMap<Relation, Delta.Kind>(Relation.class);
        EnumMap<Relation, DeltaNodeDetail> enumMap2 = new EnumMap<Relation, DeltaNodeDetail>(Relation.class);
        boolean bl2 = false;
        if (bl) {
            if (iStructPropertyProvider == null) {
                if (iStructPropertyProvider2 == null) {
                    if (iStructPropertyProvider3 == null) {
                        assert (false);
                    } else {
                        enumMap.put(Relation.REF_TWO, Delta.Kind.ADDED);
                        enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
                        enumMap.put(Relation.ONE_TWO, Delta.Kind.ADDED);
                    }
                } else if (iStructPropertyProvider3 == null) {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.ADDED);
                    enumMap.put(Relation.REF_TWO, Delta.Kind.SAME);
                    enumMap.put(Relation.ONE_TWO, Delta.Kind.ADDED);
                } else {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.ADDED);
                    enumMap.put(Relation.REF_TWO, Delta.Kind.ADDED);
                    DeltaNodeDetail deltaNodeDetail = this.compareTwoWay(iStructPropertyProvider2, iStructPropertyProvider3, iProgressMonitor);
                    enumMap2.put(Relation.ONE_TWO, deltaNodeDetail);
                    Delta.Kind kind = deltaNodeDetail.total == 0 ? Delta.Kind.SAME : Delta.Kind.CHANGED;
                    enumMap.put(Relation.ONE_TWO, kind);
                }
            } else if (iStructPropertyProvider2 == null) {
                enumMap.put(Relation.REF_ONE, Delta.Kind.DELETED);
                if (iStructPropertyProvider3 == null) {
                    enumMap.put(Relation.REF_TWO, Delta.Kind.DELETED);
                    enumMap.put(Relation.ONE_TWO, Delta.Kind.SAME);
                } else {
                    DeltaNodeDetail deltaNodeDetail = this.compareTwoWay(iStructPropertyProvider, iStructPropertyProvider3, iProgressMonitor);
                    enumMap2.put(Relation.REF_TWO, deltaNodeDetail);
                    if (deltaNodeDetail.total == 0) {
                        enumMap.put(Relation.REF_TWO, Delta.Kind.SAME);
                        enumMap.put(Relation.ONE_TWO, Delta.Kind.DELETED);
                    } else {
                        enumMap.put(Relation.REF_TWO, Delta.Kind.CHANGED);
                        enumMap.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
                        bl2 = true;
                    }
                }
            } else if (iStructPropertyProvider3 == null) {
                enumMap.put(Relation.REF_TWO, Delta.Kind.DELETED);
                DeltaNodeDetail deltaNodeDetail = this.compareTwoWay(iStructPropertyProvider, iStructPropertyProvider2, iProgressMonitor);
                enumMap2.put(Relation.REF_ONE, deltaNodeDetail);
                if (deltaNodeDetail.total == 0) {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
                    enumMap.put(Relation.ONE_TWO, Delta.Kind.DELETED);
                } else {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.CHANGED);
                    enumMap.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
                    bl2 = true;
                }
            } else {
                boolean bl3;
                int n = 0;
                DeltaNodeDetail deltaNodeDetail = this.compareTwoWay(iStructPropertyProvider, iStructPropertyProvider2, iProgressMonitor);
                enumMap2.put(Relation.REF_ONE, deltaNodeDetail);
                if (deltaNodeDetail.method.contains((Object)Comparison.Method.AS_TEXT)) {
                    ++n;
                }
                boolean bl4 = deltaNodeDetail.total == 0;
                DeltaNodeDetail deltaNodeDetail2 = this.compareTwoWay(iStructPropertyProvider, iStructPropertyProvider3, iProgressMonitor);
                enumMap2.put(Relation.REF_TWO, deltaNodeDetail2);
                if (deltaNodeDetail2.method.contains((Object)Comparison.Method.AS_TEXT)) {
                    ++n;
                }
                boolean bl5 = bl3 = deltaNodeDetail2.total == 0;
                if (bl4 && !bl3) {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
                    enumMap.put(Relation.REF_TWO, Delta.Kind.CHANGED);
                    enumMap.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
                } else if (!bl4 && bl3) {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.CHANGED);
                    enumMap.put(Relation.REF_TWO, Delta.Kind.SAME);
                    enumMap.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
                } else if (!bl4 && !bl3) {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.CHANGED);
                    enumMap.put(Relation.REF_TWO, Delta.Kind.CHANGED);
                    DeltaNodeDetail deltaNodeDetail3 = this.compareTwoWay(iStructPropertyProvider2, iStructPropertyProvider3, iProgressMonitor);
                    enumMap2.put(Relation.ONE_TWO, deltaNodeDetail3);
                    if (deltaNodeDetail3.method.contains((Object)Comparison.Method.AS_TEXT)) {
                        ++n;
                    }
                    if (deltaNodeDetail3.total == 0) {
                        enumMap.put(Relation.ONE_TWO, Delta.Kind.SAME);
                    } else if (n == 3) {
                        bl2 = this.hasTrueConflicts(iStructPropertyProvider, iStructPropertyProvider2, iStructPropertyProvider3);
                        enumMap.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
                    } else {
                        bl2 = true;
                        enumMap.put(Relation.ONE_TWO, Delta.Kind.CHANGED);
                    }
                } else {
                    enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
                    enumMap.put(Relation.REF_TWO, Delta.Kind.SAME);
                    enumMap.put(Relation.ONE_TWO, Delta.Kind.SAME);
                }
            }
        } else if (iStructPropertyProvider == null) {
            if (iStructPropertyProvider2 != null) {
                enumMap.put(Relation.REF_ONE, Delta.Kind.ADDED);
            } else assert (false);
        } else if (iStructPropertyProvider2 == null) {
            enumMap.put(Relation.REF_ONE, Delta.Kind.DELETED);
        } else {
            DeltaNodeDetail deltaNodeDetail = this.compareTwoWay(iStructPropertyProvider, iStructPropertyProvider2, iProgressMonitor);
            enumMap2.put(Relation.REF_ONE, deltaNodeDetail);
            if (deltaNodeDetail.total != 0) {
                enumMap.put(Relation.REF_ONE, Delta.Kind.CHANGED);
            } else {
                enumMap.put(Relation.REF_ONE, Delta.Kind.SAME);
            }
        }
        return new ResourceDelta(enumMap, enumMap2, bl2);
    }

    private DeltaNodeDetail compareAsText(Object object, Object object2) {
        if (object == null || object2 == null) {
            assert (false);
            return new DeltaNodeDetail(EnumSet.of(Comparison.Method.AS_TEXT), 1);
        }
        RangeDiff[] rangeDiffArray = this.findDiffs(object, object2, null);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        RangeDiff[] rangeDiffArray2 = rangeDiffArray;
        int n4 = rangeDiffArray.length;
        int n5 = 0;
        while (n5 < n4) {
            RangeDiff rangeDiff = rangeDiffArray2[n5];
            if (rangeDiff.isAdded()) {
                ++n;
            } else if (rangeDiff.isDeleted()) {
                ++n2;
            } else if (rangeDiff.isChanged()) {
                ++n3;
            } else assert (false);
            ++n5;
        }
        return new DeltaNodeDetail(EnumSet.of(Comparison.Method.AS_TEXT), n, n2, n3);
    }

    private boolean compareBbbUsingDataInputStream(InputStream inputStream, InputStream inputStream2, IProgressMonitor iProgressMonitor) throws IOException {
        int n;
        if (inputStream == null && inputStream2 == null) {
            return true;
        }
        if (inputStream == null || inputStream2 == null) {
            return false;
        }
        byte[] byArray = new byte[16384];
        byte[] byArray2 = new byte[16384];
        DataInputStream dataInputStream = new DataInputStream(inputStream2);
        while ((n = inputStream.read(byArray)) > 0) {
            if (iProgressMonitor.isCanceled()) {
                return false;
            }
            dataInputStream.readFully(byArray2, 0, n);
            int n2 = 0;
            while (n2 < n) {
                if (byArray[n2] != byArray2[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        return dataInputStream.read() < 0;
    }

    private boolean compareBbbUsingFileChannel(InputStream inputStream, InputStream inputStream2, IProgressMonitor iProgressMonitor) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        ReadableByteChannel readableByteChannel2 = Channels.newChannel(inputStream2);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(65536);
        try {
            while (true) {
                if (iProgressMonitor.isCanceled()) {
                    return false;
                }
                int n = readableByteChannel.read(byteBuffer);
                int n2 = readableByteChannel2.read(byteBuffer2);
                if (n == -1 || n2 == -1) {
                    boolean bl = n == n2;
                    return bl;
                }
                byteBuffer.flip();
                byteBuffer2.flip();
                int n3 = 0;
                if (n3 < Math.min(n, n2)) {
                }
                byteBuffer.compact();
                byteBuffer2.compact();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
    }

    private DeltaNodeDetail compareTwoWay(IStructPropertyProvider iStructPropertyProvider, IStructPropertyProvider iStructPropertyProvider2, IProgressMonitor iProgressMonitor) throws IOException {
        DeltaNodeDetail deltaNodeDetail;
        boolean bl;
        if (iStructPropertyProvider == iStructPropertyProvider2 || iStructPropertyProvider == null && iStructPropertyProvider2 == null) {
            return new DeltaNodeDetail(this.method, 0);
        }
        if (iStructPropertyProvider == null || iStructPropertyProvider2 == null) {
            return new DeltaNodeDetail(this.method, 1);
        }
        IStructElement iStructElement = ((IStructComparator)iStructPropertyProvider).getElement();
        IStructElement iStructElement2 = ((IStructComparator)iStructPropertyProvider2).getElement();
        IResource iResource = null;
        IResource iResource2 = null;
        if (iStructElement instanceof IResource) {
            iResource = (IResource)iStructElement;
            iResource2 = (IResource)iStructElement2;
            if (iResource.isDirectory() || iResource2.isDirectory()) {
                return new DeltaNodeDetail(this.method, 0);
            }
        } else {
            Object object = iStructPropertyProvider.getValue(StructProperty.VALUE);
            Object object2 = iStructPropertyProvider2.getValue(StructProperty.VALUE);
            if (object != null && object2 != null) {
                return new DeltaNodeDetail(EnumSet.of(Comparison.Method.AS_TEXT), object.equals(object2) ? 0 : 1);
            }
            return new DeltaNodeDetail(EnumSet.of(Comparison.Method.AS_TEXT), 0);
        }
        if (!this.byContent) {
            DeltaNodeDetail deltaNodeDetail2 = this.quickCompare(iStructPropertyProvider, iStructPropertyProvider2);
            if (deltaNodeDetail2.total != -1) {
                return new DeltaNodeDetail(deltaNodeDetail2.method, deltaNodeDetail2.total, deltaNodeDetail2.timeDelta);
            }
        }
        if ((bl = this.method.contains((Object)Comparison.Method.BYTE_BY_BYTE)) && iResource.getSize() != iResource2.getSize()) {
            return new DeltaNodeDetail(EnumSet.of(Comparison.Method.BYTE_BY_BYTE), 1);
        }
        String string = iResource.getUri();
        String string2 = iResource2.getUri();
        boolean bl2 = VfsUtil.hasVfsScheme((String)string);
        boolean bl3 = VfsUtil.hasVfsScheme((String)string2);
        DifferencerInput differencerInput = new DifferencerInput(iStructPropertyProvider);
        DifferencerInput differencerInput2 = new DifferencerInput(iStructPropertyProvider2);
        if (!bl) {
            bl = this.shouldCompareBbb(differencerInput, differencerInput2, bl2, bl3);
        }
        InputStream inputStream = null;
        try {
            inputStream = this.obtainInputStream(differencerInput);
            InputStream inputStream2 = null;
            try {
                inputStream2 = this.obtainInputStream(differencerInput2);
                if (bl) {
                    boolean bl4 = false;
                    if (!bl2 && !bl3) {
                        File file = new File(string);
                        File file2 = new File(string2);
                        bl4 = IO.fileSystem().compareByteByByte(file, file2, iProgressMonitor);
                        if (bl4) {
                            long l;
                            long l2 = iResource.resourceForkSize();
                            if (l2 != (l = iResource2.resourceForkSize())) {
                                bl4 = false;
                            } else if (l2 > 0L || l > 0L) {
                                file = new File(String.valueOf(string) + "/..namedfork/rsrc");
                                file2 = new File(String.valueOf(string2) + "/..namedfork/rsrc");
                                bl4 = IO.fileSystem().compareByteByByte(file, file2, iProgressMonitor);
                            }
                        }
                    } else {
                        bl4 = this.compareBbbUsingDataInputStream(inputStream, inputStream2, iProgressMonitor);
                    }
                    int n = bl4 ? 0 : 1;
                    deltaNodeDetail = new DeltaNodeDetail(EnumSet.of(Comparison.Method.BYTE_BY_BYTE), n);
                } else {
                    deltaNodeDetail = this.compareAsText(differencerInput, differencerInput2);
                }
            }
            finally {
                StreamUtil.closeSilently((Closeable)inputStream2);
            }
        }
        finally {
            StreamUtil.closeSilently((Closeable)inputStream);
            StreamUtil.closeSilently((Closeable)differencerInput.inputStream);
            StreamUtil.closeSilently((Closeable)differencerInput2.inputStream);
        }
        return deltaNodeDetail;
    }

    private RangeDiff[] findDiffs(Object object, Object object2, Object object3) {
        DocumentLineComparator documentLineComparator = null;
        DocumentLineComparator documentLineComparator2 = null;
        DocumentLineComparator documentLineComparator3 = null;
        try {
            if (object != null) {
                documentLineComparator = new DocumentLineComparator(Differencer.getContents(object, this.charset), this.filters, this.ignoreCase);
            }
            if (object2 != null) {
                documentLineComparator2 = new DocumentLineComparator(Differencer.getContents(object2, this.charset), this.filters, this.ignoreCase);
            }
            if (object3 != null) {
                documentLineComparator3 = new DocumentLineComparator(Differencer.getContents(object3, this.charset), this.filters, this.ignoreCase);
            }
        }
        catch (IOException iOException) {
            LOG.error("findDiffs failed: " + iOException);
        }
        if (documentLineComparator == null || documentLineComparator2 == null) {
            return RangeDiff.EMPTY_ARRAY;
        }
        if (this.rgDifferencer == null) {
            this.rgDifferencer = new RangeDifferencer(this.prefs);
        }
        EnumMap<Role, DocumentLineComparator> enumMap = new EnumMap<Role, DocumentLineComparator>(Role.class);
        enumMap.put(Role.REF, documentLineComparator);
        enumMap.put(Role.ONE, documentLineComparator2);
        enumMap.put(Role.TWO, documentLineComparator3);
        return this.rgDifferencer.findTrueDeltas(null, enumMap, RangeDifferencer.Target.LINES);
    }

    private boolean hasTrueConflicts(Object object, Object object2, Object object3) {
        RangeDiff[] rangeDiffArray;
        RangeDiff[] rangeDiffArray2 = rangeDiffArray = this.findDiffs(object, object2, object3);
        int n = rangeDiffArray.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDiff rangeDiff = rangeDiffArray2[n2];
            if (rangeDiff.isConflict() && !rangeDiff.isPseudoConflict()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isBinary(DifferencerInput differencerInput, InputStream inputStream) throws IOException {
        if (differencerInput == null) {
            throw new NullPointerException("di");
        }
        if (inputStream == null) {
            throw new NullPointerException("is");
        }
        IStructPropertyProvider iStructPropertyProvider = differencerInput.getStructurePropertyProvider();
        String string = (String)iStructPropertyProvider.getValue(StructProperty.NAME);
        long l = (Long)iStructPropertyProvider.getValue(StructProperty.SIZE);
        ContentType contentType = App.instance().contentTypeBoss().detectType(inputStream, FileUtil.getExtension((String)string), l);
        return contentType.isBinary();
    }

    private boolean isSizeOverBbbThreshold(DifferencerInput differencerInput) {
        IStructPropertyProvider iStructPropertyProvider = differencerInput.getStructurePropertyProvider();
        IResource iResource = (IResource)((IStructComparator)iStructPropertyProvider).getElement();
        return iResource != null && iResource.getSize() >= this.bbbThreshold;
    }

    public Set<Comparison.Method> method() {
        return this.umMethod;
    }

    private InputStream obtainInputStream(DifferencerInput differencerInput) throws IOException {
        Object object;
        IStructPropertyProvider iStructPropertyProvider = differencerInput.getStructurePropertyProvider();
        if (iStructPropertyProvider != null && (object = AdaptableUtil.getAdapter((Object)iStructPropertyProvider, IStreamProvider.class)) instanceof IStreamProvider) {
            return ((IStreamProvider)object).createInputStream(false);
        }
        return null;
    }

    private DeltaNodeDetail quickCompare(IStructPropertyProvider iStructPropertyProvider, IStructPropertyProvider iStructPropertyProvider2) {
        Object object;
        Object object2;
        long l = 0L;
        EnumSet<Comparison.Method> enumSet = EnumSet.noneOf(Comparison.Method.class);
        if (this.method.contains((Object)Comparison.Method.SIZE)) {
            object2 = iStructPropertyProvider.getValue(StructProperty.SIZE);
            object = iStructPropertyProvider2.getValue(StructProperty.SIZE);
            if (object2 != null && object != null && !object2.equals(object)) {
                enumSet.add(Comparison.Method.SIZE);
            }
        }
        if (this.method.contains((Object)Comparison.Method.DATE_MODIFIED)) {
            object2 = iStructPropertyProvider.getValue(StructProperty.DATE_MODIFIED);
            object = iStructPropertyProvider2.getValue(StructProperty.DATE_MODIFIED);
            if (object2 != null && object != null) {
                l = Math.abs((Long)object2 - (Long)object);
                if (this.ignoreDaylight && l > 0L && l >= 3600000L - this.dateThreshold && l <= 3600000L + this.dateThreshold) {
                    l = Math.abs(l - 3600000L);
                }
                if (this.ignoreTimezone && l > 0L) {
                    int n = this.ignoreDaylight ? 26 : 25;
                    int n2 = 1;
                    while (n2 <= n) {
                        if (l >= (long)n2 * 3600000L - this.dateThreshold && l <= (long)n2 * 3600000L + this.dateThreshold) {
                            l = Math.abs(l - (long)n2 * 3600000L);
                        }
                        ++n2;
                    }
                }
                if (l > this.dateThreshold) {
                    enumSet.add(Comparison.Method.DATE_MODIFIED);
                }
            }
        }
        if (this.method.contains((Object)Comparison.Method.ATTRIBUTES)) {
            object2 = iStructPropertyProvider.getValue(StructProperty.ATTRIBUTES);
            object = iStructPropertyProvider2.getValue(StructProperty.ATTRIBUTES);
            if (object2 != null && object != null && !object2.equals(object)) {
                enumSet.add(Comparison.Method.ATTRIBUTES);
            }
        }
        return new DeltaNodeDetail(enumSet, enumSet.isEmpty() ? 0 : 1, l);
    }

    private boolean shouldCompareBbb(DifferencerInput differencerInput, DifferencerInput differencerInput2, boolean bl, boolean bl2) throws IOException {
        boolean bl3;
        if (this.method.contains((Object)Comparison.Method.BYTE_BY_BYTE)) {
            return true;
        }
        if (this.method.contains((Object)Comparison.Method.AS_TEXT) && this.compareBbb && (this.isSizeOverBbbThreshold(differencerInput) || this.isSizeOverBbbThreshold(differencerInput2))) {
            return true;
        }
        InputStream inputStream = null;
        try {
            inputStream = !bl ? this.obtainInputStream(differencerInput) : this.obtainInputStream(differencerInput2);
            bl3 = this.isBinary(differencerInput, inputStream);
        }
        catch (Throwable throwable) {
            StreamUtil.closeSilently(inputStream);
            throw throwable;
        }
        StreamUtil.closeSilently((Closeable)inputStream);
        return bl3;
    }

    private static class DifferencerInput
    implements IAdaptable {
        private String charset;
        private final IStructPropertyProvider input;
        private InputStream inputStream;
        private boolean querySca = true;

        public DifferencerInput(IStructPropertyProvider iStructPropertyProvider) {
            this.input = iStructPropertyProvider;
        }

        public Object getAdapter(Class clazz) {
            return AdaptableUtil.getAdapter((Object)this.input, (Class)clazz);
        }

        public String getCharset() {
            if (this.charset == null) {
                this.queryStreamContentAccessor();
            }
            return this.charset;
        }

        public InputStream getInputStream() {
            if (this.inputStream == null) {
                this.queryStreamContentAccessor();
            }
            return this.inputStream;
        }

        public IStructPropertyProvider getStructurePropertyProvider() {
            return this.input;
        }

        private void queryStreamContentAccessor() {
            if (!this.querySca) {
                return;
            }
            IStreamContentAccessor iStreamContentAccessor = (IStreamContentAccessor)AdaptableUtil.getAdapter((Object)this.input, IStreamContentAccessor.class);
            if (iStreamContentAccessor != null) {
                if (iStreamContentAccessor instanceof IEncodedStreamContentAccessor) {
                    try {
                        this.charset = ((IEncodedStreamContentAccessor)iStreamContentAccessor).getEncoding().charset();
                    }
                    catch (CoreException coreException) {}
                }
                try {
                    this.inputStream = iStreamContentAccessor.getContents();
                }
                catch (IOException iOException) {}
            }
            this.querySca = false;
        }
    }
}

