/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.DocType;
import com.deltawalker.Pre;
import com.deltawalker.Relation;
import com.deltawalker.StateBoss;
import com.deltawalker.UriInfo;
import com.deltawalker.script.Role;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.io.FileUtil;
import com.deltopia.io.UriInfoKey;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UriInfoUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UriInfoUtil.class);

    public static void addTitles(Map<Role, UriInfo> map, String[] stringArray) {
        for (Map.Entry<Role, UriInfo> entry : map.entrySet()) {
            UriInfo uriInfo = entry.getValue();
            entry.setValue(uriInfo.cloneUpdateTitle(stringArray[entry.getKey().toInt()]));
        }
    }

    public static UriInfo clearSnapshotProperties(UriInfo uriInfo) {
        uriInfo = uriInfo.cloneUpdateSnapshotPath("");
        uriInfo = uriInfo.cloneUpdateSnapshotTrees(Collections.emptyMap());
        return uriInfo;
    }

    public static UriInfo fromScript(com.deltawalker.script.UriInfo uriInfo) {
        Map<String, String> map = uriInfo.properties();
        HashMap<UriInfoKey, Object> hashMap = null;
        if (!map.isEmpty()) {
            hashMap = new HashMap<UriInfoKey, Object>();
            for (Map.Entry object2 : map.entrySet()) {
                String string = (String)object2.getKey();
                UriInfoKey uriInfoKey = UriInfoKey.fromScript((String)string);
                if (uriInfoKey == null) {
                    throw new IllegalArgumentException("Invalid UriInfo property name: " + string);
                }
                String string2 = (String)object2.getValue();
                hashMap.put(uriInfoKey, string2);
            }
        }
        String string = FileUtil.resolvePath((String)uriInfo.getUri(), null);
        UriInfo uriInfo2 = new UriInfo(string, null, hashMap);
        return uriInfo2;
    }

    public static ContentType guessContentType(Map<Role, UriInfo> map) {
        if (map == null) {
            throw new NullPointerException("uriInfos");
        }
        for (UriInfo uriInfo : map.values()) {
            ContentType contentType;
            if (uriInfo == null || (contentType = uriInfo.contentType()).isUnknown()) continue;
            return contentType;
        }
        return ContentType.UNKNOWN;
    }

    public static FileType guessFileType(Map<Role, UriInfo> map) {
        return UriInfoUtil.guessFileType(map, null);
    }

    public static FileType guessFileType(Map<Role, UriInfo> map, FileType fileType) {
        if (map == null) {
            throw new NullPointerException("uriInfos");
        }
        if (map.isEmpty()) {
            throw new IllegalArgumentException("uriInfos");
        }
        for (UriInfo uriInfo : map.values()) {
            FileType fileType2;
            if (uriInfo == null || (fileType2 = uriInfo.fileType()).isUnknown()) continue;
            return fileType2;
        }
        return fileType != null ? fileType : FileType.UNKNOWN;
    }

    public static boolean hasError(Map<Role, UriInfo> map) {
        for (UriInfo uriInfo : map.values()) {
            if (!uriInfo.hasError()) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Map<Role, UriInfo> map) {
        boolean bl = true;
        for (UriInfo uriInfo : map.values()) {
            if (uriInfo.isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isThreeWay(Map<Role, UriInfo> map) {
        boolean bl = false;
        if (map.containsKey((Object)Role.TWO)) {
            UriInfo uriInfo = map.get((Object)Role.TWO);
            bl = !uriInfo.isEmpty() && !uriInfo.hasError();
        }
        return bl;
    }

    public static void log(Map<Role, UriInfo> map) {
        if (!LOG.isInfoEnabled()) {
            return;
        }
        for (Map.Entry<Role, UriInfo> entry : map.entrySet()) {
            UriInfo uriInfo = entry.getValue();
            if (uriInfo.uri().isEmpty()) continue;
            LOG.info((Object)((Object)entry.getKey()) + ": " + uriInfo.toString());
        }
    }

    public static void makeUriInfosSafe(Map<Role, UriInfo> map, FileType fileType) {
        if (map == null) {
            throw new NullPointerException("uriInfos");
        }
        Set<Role> set = Relation.roles(true);
        for (Role role : set) {
            if (map.get((Object)role) != null) continue;
            map.put(role, new UriInfo("", fileType));
        }
    }

    private static Map<UriInfoKey, Object> readProps(JsonReader jsonReader) throws IOException {
        EnumMap<UriInfoKey, Object> enumMap = null;
        jsonReader.beginObject();
        if (jsonReader.hasNext()) {
            enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
        }
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            UriInfoKey uriInfoKey = UriInfoKey.fromJson((String)string);
            assert (uriInfoKey != null);
            Object object = uriInfoKey.fromJsonReader(jsonReader);
            if (object != null) {
                enumMap.put(uriInfoKey, object);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn("Unknown UriInfoKey: " + string);
        }
        jsonReader.endObject();
        return enumMap;
    }

    public static UriInfo readUriInfo(JsonReader jsonReader) throws IOException {
        String string = null;
        DocType docType = DocType.UNKNOWN;
        Map<UriInfoKey, Object> map = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            if (string2.equals("uri")) {
                string = jsonReader.nextString();
                continue;
            }
            if (string2.equals("dtp")) {
                docType = DocType.fromJson(jsonReader.nextString());
                continue;
            }
            if (string2.equals("ps")) {
                map = UriInfoUtil.readProps(jsonReader);
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string2);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return new UriInfo(string, docType.fileType(), docType.contentType(), null, map);
    }

    /*
     * Unable to fully structure code
     */
    public static Map<Role, UriInfo> readUriInfos(JsonReader var0) throws IOException {
        block14: {
            var1_1 = null;
            var2_2 = null;
            var3_3 = null;
            var4_4 = new EnumMap<Role, UriInfo>(Role.class);
            var0.beginObject();
            if (var0 == null || !var0.hasNext()) break block14;
            if (!StateBoss.is(Pre.V_20)) ** GOTO lbl41
            while (var0.hasNext()) {
                var5_5 = var0.nextName();
                if (var5_5.equals("ancestor")) {
                    var1_1 = UriInfoUtil.readUriInfo(var0);
                    continue;
                }
                if (var5_5.equals("first")) {
                    var2_2 = UriInfoUtil.readUriInfo(var0);
                    continue;
                }
                if (var5_5.equals("second")) {
                    var3_3 = UriInfoUtil.readUriInfo(var0);
                    continue;
                }
                if (UriInfoUtil.LOG.isWarnEnabled()) {
                    UriInfoUtil.LOG.warn("Unknown JSON key: " + var5_5);
                }
                var0.skipValue();
            }
            if (var1_1 != null) break block14;
            var1_1 = var2_2;
            var2_2 = var3_3;
            var3_3 = null;
            break block14;
lbl-1000:
            // 1 sources

            {
                var5_5 = var0.nextName();
                if (var5_5.equals(Role.REF.toString())) {
                    var1_1 = UriInfoUtil.readUriInfo(var0);
                    continue;
                }
                if (var5_5.equals(Role.ONE.toString())) {
                    var2_2 = UriInfoUtil.readUriInfo(var0);
                    continue;
                }
                if (var5_5.equals(Role.TWO.toString())) {
                    var3_3 = UriInfoUtil.readUriInfo(var0);
                    continue;
                }
                if (UriInfoUtil.LOG.isWarnEnabled()) {
                    UriInfoUtil.LOG.warn("Unknown JSON key: " + var5_5);
                }
                var0.skipValue();
lbl41:
                // 5 sources

                ** while (var0.hasNext())
            }
        }
        var0.endObject();
        var4_4.put(Role.REF, var1_1);
        var4_4.put(Role.ONE, var2_2);
        var4_4.put(Role.TWO, var3_3);
        var5_5 = FileType.UNKNOWN;
        for (UriInfo var6_7 : var4_4.values()) {
            if (var6_7 == null || var6_7.fileType() == FileType.UNKNOWN) continue;
            var5_5 = var6_7.fileType();
            break;
        }
        UriInfoUtil.makeUriInfosSafe(var4_4, (FileType)var5_5);
        return var4_4;
    }

    public static void replaceDisplayWithEmptyUris(Map<Role, UriInfo> map) {
        for (Map.Entry<Role, UriInfo> entry : map.entrySet()) {
            UriInfo uriInfo = entry.getValue();
            if (!uriInfo.hasHintUri()) continue;
            entry.setValue(uriInfo.cloneUpdateUri("", true));
        }
    }

    public static com.deltawalker.script.UriInfo toScript(UriInfo uriInfo) {
        Map.Entry<UriInfoKey, Object> entry2;
        Map<UriInfoKey, Object> map = uriInfo.properties();
        HashMap<String, String> hashMap = null;
        if (map != null && !map.isEmpty()) {
            hashMap = new HashMap<String, String>();
            for (Map.Entry<UriInfoKey, Object> entry2 : map.entrySet()) {
                UriInfoKey uriInfoKey = (UriInfoKey)entry2.getKey();
                String string = uriInfoKey.toScript();
                if (string == null) {
                    throw new IllegalArgumentException("Invalid UriInfo property name: " + uriInfoKey);
                }
                Object v = entry2.getValue();
                if (v == null) continue;
                hashMap.put(string, v.toString());
            }
        }
        entry2 = new com.deltawalker.script.UriInfo(uriInfo.uri(), hashMap);
        return entry2;
    }

    public static void writeUriInfos(JsonWriter jsonWriter, Map<Role, UriInfo> map, Set<Role> set) throws IOException {
        jsonWriter.beginObject();
        for (Role role : set) {
            UriInfo uriInfo = map.get((Object)role);
            if (uriInfo.isEmpty()) continue;
            jsonWriter.name(role.toString());
            uriInfo.toJson(jsonWriter);
        }
        jsonWriter.endObject();
    }
}

