/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.EncodingUtil;
import com.deltawalker.Msg;
import com.deltawalker.Relation;
import com.deltawalker.resources.ResourceFactory;
import com.deltawalker.script.Role;
import com.deltawalker.ui.UIMsg;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.io.BomHeader;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.io.StructFileInfo;
import com.deltopia.io.TextEncoding;
import com.deltopia.io.UriInfoKey;
import com.deltopia.io.VfsUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriInfo {
    protected static final Logger LOG = LoggerFactory.getLogger(UriInfo.class);
    public static final String MRU_URI = "MRU_URI";
    private final ContentType cType;
    private final Throwable error;
    private final FileType fType;
    private final Map<UriInfoKey, Object> props;
    private final Map<UriInfoKey, Object> umProps;
    private final String uri;

    public static String constructMruName(String string) {
        return "MRU_URI." + string;
    }

    public static boolean isHintUri(String string) {
        if (string.startsWith(Msg.Doc_untitled)) {
            int n = string.length();
            int n2 = Msg.Doc_untitled.length();
            while (n2 < n) {
                if (!Character.isDigit(string.charAt(n2))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return UriInfo.isTypeDisplayUri(string, FileType.FILE) || UriInfo.isTypeDisplayUri(string, FileType.FOLDER);
    }

    private static boolean isTypeDisplayUri(String string, FileType fileType) {
        String string2 = fileType.toString();
        if (string.equals(string2)) {
            return true;
        }
        return string.endsWith(string2) && (string.startsWith(UIMsg.Role_ref) || string.startsWith(UIMsg.Role_one) || string.startsWith(UIMsg.Role_two) || string.startsWith(UIMsg.Role_modified) || string.startsWith(UIMsg.Role_oneModified) || string.startsWith(UIMsg.Role_twoModified));
    }

    public static Map<Role, UriInfo> processCmdLineArgs(List<String> list) {
        if (list == null) {
            LOG.warn("'args' == null");
        }
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<Role, UriInfo> enumMap = new EnumMap<Role, UriInfo>(Role.class);
        int n = list.size() - 1;
        int n2 = 0;
        while (n2 < Role.count()) {
            Role role = Relation.argToRole(n2, list.size());
            int n3 = n - n2;
            if (n3 >= 0) {
                enumMap.put(role, new UriInfo(list.get(n3), true));
            } else {
                enumMap.put(role, new UriInfo());
            }
            ++n2;
        }
        return enumMap;
    }

    public UriInfo() {
        this("", false);
    }

    public UriInfo(String string) {
        this(string, FileType.UNKNOWN);
    }

    public UriInfo(String string, boolean bl) {
        this(string, FileType.UNKNOWN, ContentType.UNKNOWN, null, null, bl);
    }

    public UriInfo(String string, FileType fileType) {
        this(string, fileType, ContentType.UNKNOWN, null, null);
    }

    public UriInfo(String string, FileType fileType, ContentType contentType, Throwable throwable, Map<UriInfoKey, Object> map) {
        this(string, fileType, contentType, throwable, map, true);
    }

    public UriInfo(String string, FileType fileType, ContentType contentType, Throwable throwable, Map<UriInfoKey, Object> map, boolean bl) {
        this.uri = StringUtil.makeSafe((String)string);
        if (fileType == null) {
            fileType = FileType.UNKNOWN;
        }
        if (!fileType.isUnknown() || !bl) {
            this.fType = fileType;
            this.error = throwable;
        } else if (throwable == null) {
            IOException iOException = null;
            if (!StringUtil.isEmpty((String)string)) {
                try {
                    fileType = ResourceFactory.staticGetResourceType(new UriInfo(string, fileType, contentType, throwable, map, false));
                }
                catch (IOException iOException2) {
                    fileType = FileType.UNKNOWN;
                    iOException = iOException2;
                }
            }
            this.fType = fileType;
            this.error = iOException;
        } else {
            this.fType = fileType;
            this.error = throwable;
        }
        ContentType contentType2 = this.cType = contentType != null ? contentType : ContentType.UNKNOWN;
        if (map != null && !map.isEmpty()) {
            this.props = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            this.props.putAll(map);
            this.umProps = Collections.unmodifiableMap(this.props);
        } else {
            this.props = null;
            this.umProps = null;
        }
    }

    public UriInfo(String string, FileType fileType, Map<UriInfoKey, Object> map) {
        this(string, fileType, ContentType.UNKNOWN, null, map);
    }

    public UriInfo(UriInfo uriInfo) {
        this(uriInfo.uri, uriInfo.fType, uriInfo.cType, uriInfo.error, uriInfo.props);
    }

    public String accountId() {
        return (String)this.property(UriInfoKey.ACCOUNT_ID, "");
    }

    public boolean allowSecureAccess(boolean bl) throws IOException {
        return App.instance().trustedPathsBoss().allowSecureAccess(this.uri(), bl);
    }

    public String authToken() {
        return (String)this.property(UriInfoKey.AUTH_TOKEN, "");
    }

    public String bookmark() {
        return (String)this.property(UriInfoKey.BOOKMARK, "");
    }

    public byte[] bookmarkAsBytes() {
        return Base64.decodeBase64((String)this.bookmark());
    }

    public UriInfo cloneUpdateContentType(ContentType contentType) {
        if (this.cType != contentType) {
            FileType fileType = DocType.fromJson(contentType.docTypeKey()).fileType();
            return new UriInfo(this.uri, fileType, contentType, this.error, this.props, false);
        }
        return this;
    }

    public UriInfo cloneUpdateEncoding(TextEncoding textEncoding) {
        if (!ObjectUtil.areEqual((Object)textEncoding, (Object)this.textEncoding())) {
            Object object;
            EnumMap<UriInfoKey, Object> enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            if (this.props != null && !this.props.isEmpty()) {
                enumMap.putAll(this.props);
            }
            if (textEncoding == null) {
                enumMap.remove(UriInfoKey.ENCODING);
                enumMap.remove(UriInfoKey.BOM);
            } else {
                enumMap.put(UriInfoKey.ENCODING, (Object)textEncoding.charset());
                object = textEncoding.bom();
                if (object != null) {
                    enumMap.put(UriInfoKey.BOM, object);
                } else {
                    enumMap.remove(UriInfoKey.BOM);
                }
                enumMap.put(UriInfoKey.LOCALE, (Object)null);
            }
            object = new UriInfo(this.uri, this.fType, this.cType, this.error, enumMap, false);
            return object;
        }
        return this;
    }

    public UriInfo cloneUpdateError(Throwable throwable) {
        if (this.error != throwable) {
            return new UriInfo(this.uri, throwable != null ? FileType.UNKNOWN : this.fType, throwable != null ? this.cType : ContentType.UNKNOWN, throwable, this.props, false);
        }
        return this;
    }

    public UriInfo cloneUpdateFileType(FileType fileType) {
        ContentType contentType = fileType.isUnknown() ? ContentType.UNKNOWN : this.cType;
        return new UriInfo(this.uri, fileType, contentType, this.error, this.props, false);
    }

    public UriInfo cloneUpdateLineEnding(String string) {
        if (!ObjectUtil.areEqual((Object)string, (Object)this.lineEnding())) {
            EnumMap<UriInfoKey, Object> enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            if (this.props != null && !this.props.isEmpty()) {
                enumMap.putAll(this.props);
            }
            if (StringUtil.isEmpty((String)string)) {
                enumMap.remove(UriInfoKey.LINE_ENDING);
            } else {
                enumMap.put(UriInfoKey.LINE_ENDING, (Object)string);
            }
            return new UriInfo(this.uri, this.fType, this.cType, this.error, enumMap, false);
        }
        return this;
    }

    public UriInfo cloneUpdateLocale(Locale locale) {
        String string = "";
        if (locale != null) {
            string = EncodingUtil.getEncoding(locale);
        }
        if (!ObjectUtil.areEqual((Object)locale, (Object)this.locale())) {
            EnumMap<UriInfoKey, Object> enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            if (this.props != null && !this.props.isEmpty()) {
                enumMap.putAll(this.props);
            }
            if (locale == null) {
                enumMap.remove(UriInfoKey.LOCALE);
            } else {
                enumMap.put(UriInfoKey.LOCALE, (Object)locale);
                enumMap.put(UriInfoKey.ENCODING, (Object)string);
                enumMap.remove(UriInfoKey.BOM);
            }
            return new UriInfo(this.uri, this.fType, this.cType, this.error, enumMap, false);
        }
        return this;
    }

    public UriInfo cloneUpdateProperties(Map<UriInfoKey, Object> map) {
        if (this.props != null && !this.props.isEmpty()) {
            EnumMap<UriInfoKey, Object> enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            if (this.props != null && !this.props.isEmpty()) {
                enumMap.putAll(this.props);
            }
            enumMap.putAll(map);
            return new UriInfo(this.uri, this.fType, this.cType, this.error, enumMap, false);
        }
        return new UriInfo(this.uri, this.fType, this.cType, this.error, map, false);
    }

    public UriInfo cloneUpdateSnapshotPath(String string) {
        if (!ObjectUtil.areEqual((Object)string, (Object)this.snapshotPath())) {
            EnumMap<UriInfoKey, Object> enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            if (this.props != null && !this.props.isEmpty()) {
                enumMap.putAll(this.props);
            }
            if (StringUtil.isEmpty((String)string)) {
                enumMap.remove(UriInfoKey.SNAPSHOT_PATH);
            } else {
                enumMap.put(UriInfoKey.SNAPSHOT_PATH, (Object)string);
            }
            return new UriInfo(this.uri, this.fType, this.cType, this.error, enumMap, false);
        }
        return this;
    }

    public UriInfo cloneUpdateSnapshotTrees(Map<Role, StructFileInfo> map) {
        if (!ObjectUtil.areEqual(map, this.snapshotTrees())) {
            EnumMap<UriInfoKey, Object> enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            if (this.props != null && !this.props.isEmpty()) {
                enumMap.putAll(this.props);
            }
            if (map == null || map.isEmpty()) {
                enumMap.remove(UriInfoKey.SNAPSHOT_TREE);
            } else {
                enumMap.put(UriInfoKey.SNAPSHOT_TREE, (Object)map);
            }
            return new UriInfo(this.uri, this.fType, this.cType, this.error, enumMap, false);
        }
        return this;
    }

    public UriInfo cloneUpdateTitle(String string) {
        if (!ObjectUtil.areEqual((Object)string, (Object)this.title())) {
            EnumMap<UriInfoKey, Object> enumMap = new EnumMap<UriInfoKey, Object>(UriInfoKey.class);
            if (this.props != null && !this.props.isEmpty()) {
                enumMap.putAll(this.props);
            }
            enumMap.put(UriInfoKey.TITLE, (Object)string);
            return new UriInfo(this.uri, this.fType, this.cType, this.error, enumMap, false);
        }
        return this;
    }

    public UriInfo cloneUpdateUri(String string, boolean bl) {
        Throwable throwable = bl || !this.uri.equals(string) ? null : this.error;
        return new UriInfo(string, this.fType, this.cType, throwable, this.props, false);
    }

    public ContentType contentType() {
        return this.cType;
    }

    public String displayUri() {
        return (String)this.property(UriInfoKey.DISPLAY_URI, this.uri());
    }

    public String email() {
        return (String)this.property(UriInfoKey.EMAIL, "");
    }

    public TextEncoding textEncoding() {
        BomHeader bomHeader = (BomHeader)this.property(UriInfoKey.BOM, null);
        if (bomHeader != null) {
            return TextEncoding.fromBomHeader((BomHeader)bomHeader);
        }
        String string = (String)this.property(UriInfoKey.ENCODING, null);
        return !StringUtil.isEmpty((String)string) ? TextEncoding.fromCharset((String)string) : null;
    }

    public boolean equals(Object object) {
        String string;
        if (this == object) {
            return true;
        }
        if (!(object instanceof UriInfo)) {
            return false;
        }
        UriInfo uriInfo = (UriInfo)object;
        String string2 = this.uri;
        if (UriInfo.isHintUri(string2) || string2.length() == 0) {
            string2 = null;
        }
        if (UriInfo.isHintUri(string = uriInfo.uri) || string.length() == 0) {
            string = null;
        }
        return ObjectUtil.areEqual((Object)string2, (Object)string);
    }

    public Throwable error() {
        return this.error;
    }

    public FileType fileType() {
        if (!this.cType.isUnknown()) {
            return DocType.fromJson(this.cType.docTypeKey()).fileType();
        }
        return this.fType;
    }

    public boolean hasArchiveUri() {
        boolean bl = this.contentType().isArchive() ? true : VfsUtil.hasArchiveExtension((String)this.uri());
        return bl;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean hasHintUri() {
        return UriInfo.isHintUri(this.uri);
    }

    public boolean isEmpty() {
        return StringUtil.isEmpty((String)this.uri) || this.hasHintUri();
    }

    public boolean isExplicitMode() {
        return (Boolean)this.property(UriInfoKey.EXPLICIT_MODE, true);
    }

    public boolean isPassiveMode() {
        return (Boolean)this.property(UriInfoKey.PASSIVE_MODE, true);
    }

    public boolean isUserDirRoot() {
        return (Boolean)this.property(UriInfoKey.USER_DIR_IS_ROOT, true);
    }

    public String lineEnding() {
        return (String)this.property(UriInfoKey.LINE_ENDING, "");
    }

    public Locale locale() {
        return (Locale)this.property(UriInfoKey.LOCALE, null);
    }

    public String password() {
        return (String)this.property(UriInfoKey.PASSWORD, "");
    }

    public Map<UriInfoKey, Object> properties() {
        if (this.umProps != null) {
            return this.umProps;
        }
        return Collections.emptyMap();
    }

    public synchronized Object property(UriInfoKey uriInfoKey, Object object) {
        if (this.props == null || this.props.isEmpty()) {
            return object;
        }
        Object object2 = this.props.get(uriInfoKey);
        return object2 != null ? object2 : object;
    }

    public String snapshotPath() {
        return (String)this.property(UriInfoKey.SNAPSHOT_PATH, "");
    }

    public Map<Role, StructFileInfo> snapshotTrees() {
        Map map = (Map)this.property(UriInfoKey.SNAPSHOT_TREE, Collections.emptyMap());
        return Collections.unmodifiableMap(map);
    }

    public String sshKey() {
        return (String)this.property(UriInfoKey.SSH_KEY, "");
    }

    public String sshPassphrase() {
        return (String)this.property(UriInfoKey.SSH_PASSPHRASE, "");
    }

    public String title() {
        return (String)this.property(UriInfoKey.TITLE, "");
    }

    public synchronized void toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        jsonWriter.name("uri").value(this.uri());
        jsonWriter.name("dtp").value(this.cType.docTypeKey());
        jsonWriter.name("ps");
        this.writeProps(jsonWriter);
        jsonWriter.endObject();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.props != null && !this.props.isEmpty()) {
            stringBuilder.append(" [");
            for (Map.Entry<UriInfoKey, Object> entry : this.props.entrySet()) {
                stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append(" ");
            }
            stringBuilder.append(']');
        }
        stringBuilder.append(" cType:").append(this.cType);
        if (this.error != null) {
            stringBuilder.append(" ex: ").append(this.error.getMessage());
        }
        return String.valueOf(this.uri) + stringBuilder.toString();
    }

    public String uri() {
        return this.uri;
    }

    public String username() {
        return (String)this.property(UriInfoKey.USERNAME, "");
    }

    private synchronized void writeProps(JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginObject();
        if (this.props != null && !this.props.isEmpty()) {
            for (Map.Entry<UriInfoKey, Object> entry : this.props.entrySet()) {
                UriInfoKey uriInfoKey = entry.getKey();
                if (!uriInfoKey.isSavable()) continue;
                uriInfoKey.toJsonWriter(jsonWriter, entry.getValue());
            }
        }
        jsonWriter.endObject();
    }

    public static enum Field {
        ALL,
        BOOKMARK,
        ENCODING,
        ERROR,
        LINE_ENDING,
        LOCALE,
        URI;

    }
}

