/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.Msg;
import com.deltawalker.interfaces.ITrustedPathsBoss;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.io.FileUtil;
import com.deltopia.io.UrlEx;
import com.deltopia.io.VfsUtil;
import com.deltopia.util.OS;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TrustedPathsBoss implements ITrustedPathsBoss,
IJsonState
{
    INSTANCE;

    private static final Logger LOG;
    private final ConcurrentMap<String, String> paths = new ConcurrentHashMap<String, String>();
    private final Set<String> umPaths = Collections.unmodifiableSet(this.paths.keySet());

    static {
        LOG = LoggerFactory.getLogger(TrustedPathsBoss.class);
    }

    @Override
    public boolean addPath(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        String string2 = Platform.getInstanceLocation().getURL().getPath();
        if (string.isEmpty() || string.startsWith(string2) || this.paths.containsKey(string)) {
            return false;
        }
        if (this.isSubpath(string)) {
            return false;
        }
        String string3 = (String)this.paths.get(string);
        if (string3 == null && !VfsUtil.hasVfsScheme((String)string)) {
            UrlEx urlEx = null;
            try {
                urlEx = UrlEx.fromPath((String)string);
                byte[] byArray = urlEx.toBookmark();
                String string4 = Base64.encodeBase64String((byte[])byArray);
                this.paths.putIfAbsent(string, string4);
                this.pruneSubpaths(string);
                return true;
            }
            catch (IOException iOException) {
                LOG.error("Couldn't convert " + string + " to a bookmark.", (Throwable)iOException);
                if (!VfsUtil.hasRemoteScheme((String)string) && iOException.getMessage().contains(" be opened.")) {
                    throw new IOException(NLS.bind((String)Msg.TrustedPathBoss_prompt, (Object)string));
                }
                throw iOException;
            }
            finally {
                if (urlEx != null) {
                    urlEx.release();
                }
            }
        }
        return false;
    }

    @Override
    public boolean allowSecureAccess(String string, boolean bl) throws IOException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        return false;
    }

    @Override
    public void clearPaths() throws IOException {
        Iterator iterator = this.paths.entrySet().iterator();
        while (iterator.hasNext()) {
            this.allowSecureAccess((String)iterator.next().getKey(), false);
            iterator.remove();
        }
    }

    @Override
    public boolean containsPath(String string) {
        return this.paths.containsKey(string);
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
        }
        while (jsonReader.hasNext()) {
            this.readEntry(jsonReader);
        }
        if (jsonReader.peek() == JsonToken.END_ARRAY) {
            jsonReader.endArray();
        }
    }

    private boolean isSubpath(String string) {
        Iterator iterator = this.paths.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            if (!string.regionMatches(!OS.LINUX, 0, string2 = (String)iterator.next(), 0, string2.length())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> paths() {
        return this.umPaths;
    }

    private void pruneSubpaths(String string) {
        Iterator iterator = this.paths.entrySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next().getKey();
            if (!string2.regionMatches(!OS.LINUX, 0, string, 0, string.length()) || string.length() == string2.length()) continue;
            iterator.remove();
        }
    }

    private void readEntry(JsonReader jsonReader) throws IOException {
        Object object;
        String string = null;
        String string2 = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            object = jsonReader.nextName();
            if (((String)object).equals("tpk")) {
                string = jsonReader.nextString();
                continue;
            }
            if (((String)object).equals("tpv")) {
                string2 = jsonReader.nextString();
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + (String)object);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        if (string != null && FileUtil.absolutelyExists((File)(object = new File(string)))) {
            this.paths.put(string, string2);
            this.allowSecureAccess(string, true);
        }
    }

    @Override
    public boolean removePath(String string) throws IOException {
        String string2 = null;
        if (this.paths.containsKey(string)) {
            this.allowSecureAccess(string, false);
            string2 = (String)this.paths.remove(string);
        }
        return string2 != null;
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.beginArray();
        for (Map.Entry entry : this.paths.entrySet()) {
            jsonWriter.beginObject();
            jsonWriter.name("tpk").value((String)entry.getKey());
            jsonWriter.name("tpv").value((String)entry.getValue());
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
    }
}

