/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.Msg;
import com.deltawalker.Pre;
import com.deltawalker.PrefUtil;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IStateBoss;
import com.deltawalker.ui.AppWindowLayout;
import com.deltawalker.ui.UIUtil;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.io.IO;
import com.deltopia.io.StreamUtil;
import com.deltopia.util.Checker;
import com.deltopia.util.Const;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PerspectiveHelper;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.ViewSashContainer;
import org.eclipse.ui.internal.ViewStack;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.intro.IIntroManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StateBoss implements IStateBoss
{
    INSTANCE;

    private static final Logger LOG;
    private static String oldVersion;
    private static final String STATE_FILE_NAME = "state.dws";
    private static boolean PRE_1993;
    private static boolean PRE_1997;
    private static boolean PRE_20;
    private static boolean PRE_21;
    public static final boolean PRETTY_PRINT = false;
    private File stateFile;
    private IWorkbenchWindow wbWnd;
    private AppWindowLayout wndLayout = new AppWindowLayout();

    static {
        LOG = LoggerFactory.getLogger(StateBoss.class);
        oldVersion = "";
    }

    public static JsonReader getJsonReader(File file) {
        Object object;
        block6: {
            try {
                object = file.getCanonicalFile();
                if (((File)object).isFile()) {
                    file = object;
                    break block6;
                }
                LOG.info(NLS.bind((String)"Couldn't find {0}.", (Object)file));
                return null;
            }
            catch (IOException iOException) {
                LOG.error(NLS.bind((String)"Couldn't canonicalize {0}.", (Object)file), (Throwable)iOException);
                return null;
            }
        }
        if (file.length() == 0L) {
            return null;
        }
        object = null;
        JsonReader jsonReader = null;
        try {
            object = new FileInputStream(file);
            jsonReader = new JsonReader((Reader)new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8")));
            return jsonReader;
        }
        catch (Throwable throwable) {
            UIUtil.showError(NLS.bind((String)Msg.StateBoss_readError, (Object)throwable.getMessage()));
            LOG.error("Couldn't load: " + file, throwable);
            StreamUtil.closeSilently((Closeable)jsonReader);
            return null;
        }
    }

    private static void initializeVersions() {
        PRE_1993 = StateBoss.isOldVersionOlderThan(1.993);
        PRE_1997 = PRE_1993 ? true : StateBoss.isOldVersionOlderThan(1.997);
        PRE_20 = PRE_1997 ? true : StateBoss.isOldVersionOlderThan(2.0);
        PRE_21 = PRE_20 ? true : StateBoss.isOldVersionOlderThan(2.1);
    }

    public static boolean is(Pre pre) {
        switch (pre) {
            case V_1993: {
                return PRE_1993;
            }
            case V_1997: {
                return PRE_1997;
            }
            case V_20: {
                return PRE_20;
            }
            case V_21: {
                return PRE_21;
            }
        }
        throw new IllegalArgumentException("ver");
    }

    public static boolean isOldVersionOlderThan(double d) {
        return StateBoss.isVersionOlderThan(oldVersion, d);
    }

    public static boolean isVersionOlderThan(String string, double d) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        double d2 = StateBoss.versionStringToDouble(string);
        return d2 < d;
    }

    public static double versionStringToDouble(String string) {
        double d = 1.0;
        if (StringUtil.isEmpty((String)string)) {
            string = Double.toString(d);
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            int n = 0;
            while (n < string.length()) {
                block8: {
                    char c;
                    block7: {
                        c = string.charAt(n);
                        if ((c < '0' || c > '9') && c != '.') break;
                        if (c != '.') break block7;
                        if (!bl) break block8;
                        bl = false;
                    }
                    stringBuilder.append(c);
                }
                ++n;
            }
            d = Double.parseDouble(stringBuilder.toString());
        }
        catch (Throwable throwable) {
            LOG.error("Cannot parse version string: " + string, throwable);
        }
        return d;
    }

    @Override
    public AppWindowLayout appWindowLayout() {
        return this.wndLayout;
    }

    @Override
    public synchronized void loadState(File file, IWorkbenchWindow iWorkbenchWindow) {
        this.wbWnd = iWorkbenchWindow != null ? iWorkbenchWindow : UIUtil.getActiveWindow();
        JsonReader jsonReader = StateBoss.getJsonReader(file);
        try {
            try {
                if (jsonReader != null && jsonReader.hasNext()) {
                    IApp iApp = App.instance();
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String string = jsonReader.nextName();
                        if (string.equals("ver")) {
                            oldVersion = jsonReader.nextString();
                            StateBoss.initializeVersions();
                            continue;
                        }
                        if (string.equals("wnd")) {
                            this.readWindowLayout(jsonReader);
                            continue;
                        }
                        if (string.equals("prefs")) {
                            IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
                            PrefUtil.readPrefs(jsonReader, iPreferenceStore);
                            continue;
                        }
                        if (string.equals("sessions")) {
                            ((IJsonState)iApp.docBoss()).fromJson(jsonReader);
                            continue;
                        }
                        if (string.equals("scripts")) {
                            ((IJsonState)iApp.scriptBoss()).fromJson(jsonReader);
                            continue;
                        }
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Unknown JSON key: " + string);
                        }
                        jsonReader.skipValue();
                    }
                    jsonReader.endObject();
                }
            }
            catch (Throwable throwable) {
                LOG.error("Error loading JSON state " + file, throwable);
                StreamUtil.closeSilently((Closeable)jsonReader);
            }
        }
        finally {
            StreamUtil.closeSilently((Closeable)jsonReader);
        }
    }

    @Override
    public void loadState(IWorkbenchWindow iWorkbenchWindow) {
        this.loadState(this.stateFile(), iWorkbenchWindow);
    }

    private Rectangle readCompareView(JsonReader jsonReader) throws IOException {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("x")) {
                rectangle.x = jsonReader.nextInt();
                continue;
            }
            if (string.equals("y")) {
                rectangle.x = jsonReader.nextInt();
                continue;
            }
            if (string.equals("w")) {
                rectangle.width = jsonReader.nextInt();
                continue;
            }
            if (string.equals("h")) {
                rectangle.height = jsonReader.nextInt();
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return rectangle;
    }

    private Rectangle readConsoleView(JsonReader jsonReader) throws IOException {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("x")) {
                rectangle.x = jsonReader.nextInt();
                continue;
            }
            if (string.equals("y")) {
                rectangle.x = jsonReader.nextInt();
                continue;
            }
            if (string.equals("w")) {
                rectangle.width = jsonReader.nextInt();
                continue;
            }
            if (string.equals("h")) {
                rectangle.height = jsonReader.nextInt();
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return rectangle;
    }

    private void readWindowLayout(JsonReader jsonReader) throws IOException {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("x")) {
                rectangle.x = jsonReader.nextInt();
                continue;
            }
            if (string.equals("y")) {
                rectangle.y = jsonReader.nextInt();
                continue;
            }
            if (string.equals("w")) {
                rectangle.width = jsonReader.nextInt();
                continue;
            }
            if (string.equals("h")) {
                rectangle.height = jsonReader.nextInt();
                continue;
            }
            if (string.equals("we")) {
                this.wndLayout.hasIntro = jsonReader.nextBoolean();
                continue;
            }
            if (string.equals("ee")) {
                this.wndLayout.hasEmptyCompareEditor = jsonReader.nextBoolean();
                continue;
            }
            if (string.equals("ev")) {
                this.wndLayout.hasEmptyCompareView = jsonReader.nextBoolean();
                continue;
            }
            if (string.equals("ese")) {
                this.wndLayout.hasEmptyScriptEditor = jsonReader.nextBoolean();
                continue;
            }
            if (string.equals("cmv")) {
                this.wndLayout.setCompareViewBounds(this.readCompareView(jsonReader));
                continue;
            }
            if (string.equals("cnv")) {
                this.wndLayout.setConsoleViewBounds(this.readConsoleView(jsonReader));
                continue;
            }
            if (string.equals("mxd")) {
                this.wndLayout.maximized = jsonReader.nextBoolean();
                continue;
            }
            if (string.equals("mnd")) {
                this.wndLayout.minimized = jsonReader.nextBoolean();
                continue;
            }
            if (string.equals("fs")) {
                this.wndLayout.fullScreen = jsonReader.nextBoolean();
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        LOG.info("rcAppWnd=" + rectangle);
        this.wndLayout.setAppWindowBounds(rectangle);
    }

    @Override
    public void saveState() {
        try {
            this.saveState(this.stateFile(), false);
        }
        catch (Throwable throwable) {
            LOG.error(null, throwable);
        }
    }

    @Override
    public void saveState(File file, boolean bl) {
        try {
            this.saveStateImpl(file, bl);
        }
        catch (Throwable throwable) {
            LOG.error("Couldn't save state file: " + file, throwable);
        }
    }

    public synchronized void saveStateImpl(File file, boolean bl) throws IOException {
        Checker.notNull((Object)file, (String)"file");
        Path path = file.toPath();
        Path path2 = path.resolveSibling("tmp_" + path.getFileName().toString());
        try {
            try {
                this.saveStateInFile(path2, bl);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Replace JSON state: " + path);
                }
                Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException iOException) {
                LOG.error("Error saving state " + path, (Throwable)iOException);
                IO.fileSystem().delete(path2.toFile(), false);
            }
        }
        finally {
            IO.fileSystem().delete(path2.toFile(), false);
        }
    }

    private void saveStateInFile(Path path, boolean bl) throws IOException {
        long l = 0L;
        if (LOG.isInfoEnabled()) {
            l = System.currentTimeMillis();
            LOG.info("-> Saving JSON state: " + path);
        }
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)bufferedWriter);
            try {
                if (bl) {
                    jsonWriter.setIndent("  ");
                }
                jsonWriter.beginObject();
                IApp iApp = App.instance();
                jsonWriter.name("ver").value(iApp.version());
                this.saveWindowState(jsonWriter);
                IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
                jsonWriter.name("prefs");
                PrefUtil.writePrefs(jsonWriter, iPreferenceStore);
                jsonWriter.name("sessions");
                ((IJsonState)iApp.docBoss()).toJson(jsonWriter);
                jsonWriter.name("scripts");
                ((IJsonState)iApp.scriptBoss()).toJson(jsonWriter);
                jsonWriter.endObject();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Saved JSON state: " + (System.currentTimeMillis() - l) + " ms");
                }
            }
            finally {
                StreamUtil.closeSilently((Closeable)jsonWriter);
            }
        }
        finally {
            StreamUtil.closeSilently((Closeable)bufferedWriter);
        }
    }

    private void saveWindowState(final JsonWriter jsonWriter) throws IOException {
        StartupThreading.runWithoutExceptions((StartupThreading.StartupRunnable)new StartupThreading.StartupRunnable(){

            public void runWithException() {
                if (StateBoss.this.wbWnd != null && StateBoss.this.wbWnd.getShell() != null && !StateBoss.this.wbWnd.getShell().isDisposed()) {
                    StateBoss.this.wbWnd.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                StateBoss.this.saveWindowStateImpl(jsonWriter);
                            }
                            catch (IOException iOException) {
                                LOG.error("Error saving window state", (Throwable)iOException);
                            }
                        }
                    });
                }
            }
        });
    }

    private void saveWindowStateImpl(JsonWriter jsonWriter) throws IOException {
        Rectangle rectangle = this.wndLayout.getAppWindowBounds();
        try {
            jsonWriter.name("wnd");
            jsonWriter.beginObject();
            jsonWriter.name("x").value((long)rectangle.x);
            jsonWriter.name("y").value((long)rectangle.y);
            jsonWriter.name("w").value((long)rectangle.width);
            jsonWriter.name("h").value((long)rectangle.height);
            Shell shell = this.wbWnd.getShell();
            jsonWriter.name("mxd").value(shell.getMaximized());
            jsonWriter.name("mnd").value(shell.getMinimized());
            jsonWriter.name("fs").value(shell.getFullScreen());
            IIntroManager iIntroManager = this.wbWnd.getWorkbench().getIntroManager();
            jsonWriter.name("we").value(iIntroManager.getIntro() != null);
            jsonWriter.name("ee").value(UIUtil.hasSingleEmptyDeltaEditor(this.wbWnd));
            jsonWriter.name("ev").value(UIUtil.hasSingleEmptyDeltaView(this.wbWnd));
            jsonWriter.name("ese").value(UIUtil.hasSingleEmptyScriptEditor(this.wbWnd));
            WorkbenchPage workbenchPage = (WorkbenchPage)this.wbWnd.getActivePage();
            PerspectiveHelper perspectiveHelper = workbenchPage.getPerspectivePresentation();
            perspectiveHelper.updateBoundsMap();
            ViewSashContainer viewSashContainer = perspectiveHelper.getLayout();
            LayoutPart[] layoutPartArray = viewSashContainer.getChildren();
            int n = 0;
            while (n < layoutPartArray.length) {
                if (layoutPartArray[n] instanceof ViewStack) {
                    ViewStack viewStack = (ViewStack)layoutPartArray[n];
                    PartPane partPane = viewStack.getSelection();
                    if (partPane != null) {
                        String string = partPane.getID();
                        boolean bl = string.equals(UIUtil.COMPARE_VIEW_ID);
                        boolean bl2 = string.equals("org.eclipse.ui.console.ConsoleView");
                        if (bl || bl2) {
                            jsonWriter.name(bl ? "cmv" : "cnv");
                            jsonWriter.beginObject();
                            Rectangle rectangle2 = viewStack.getBounds();
                            jsonWriter.name("x").value((long)rectangle2.x);
                            jsonWriter.name("y").value((long)rectangle2.y);
                            jsonWriter.name("w").value((long)rectangle2.width);
                            jsonWriter.name("h").value((long)rectangle2.height);
                            jsonWriter.endObject();
                        }
                    }
                } else {
                    boolean cfr_ignored_0 = layoutPartArray[n] instanceof EditorSashContainer;
                }
                ++n;
            }
            Rectangle rectangle3 = perspectiveHelper.getCachedBoundsFor("folderComparisons");
            if (rectangle3 != null) {
                int n2 = rectangle3.width > rectangle3.height ? 256 : 512;
                LOG.info(String.valueOf(UIUtil.COMPARE_VIEW_ID) + "   rcStack=" + rectangle3 + "   orientation=" + n2);
            }
        }
        finally {
            jsonWriter.endObject();
        }
    }

    @Override
    public final synchronized File stateFile() {
        if (this.stateFile == null) {
            File file;
            File file2;
            File file3 = new File(Platform.getInstanceLocation().getURL().getFile());
            this.stateFile = new File(file3, STATE_FILE_NAME);
            if (!this.stateFile.isFile() && (file2 = new File(file = new File(Const.USER_HOME, ".deltawalker"), STATE_FILE_NAME)).isFile()) {
                try {
                    IO.fileSystem().copyFile(file2.getCanonicalPath(), this.stateFile.getCanonicalPath(), null);
                    File file4 = new File(Const.USER_HOME, ".deltawalker/dw_log.properties");
                    File file5 = new File(file3, "dw_log.properties");
                    if (file4.isFile()) {
                        IO.fileSystem().copyFile(file4.getCanonicalPath(), file5.getCanonicalPath(), null);
                    }
                    IO.fileSystem().delete(file, true);
                }
                catch (IOException iOException) {
                    LOG.error("Couldn't copy old state file" + iOException);
                }
            }
        }
        return this.stateFile;
    }
}

