/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.internal.script.App;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.ShowConsoleAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptRunner.class);
    public static final String GROOVY = "application/x-groovy";
    public static final String JS = "application/javascript";
    private static final boolean RECREATE_ENGINE = false;
    private ScriptEngine engine;
    private final String mimeType;

    public ScriptRunner(String string) {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        this.mimeType = string;
    }

    private ScriptEngine engine() {
        if (this.engine == null) {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            this.engine = scriptEngineManager.getEngineByMimeType(this.mimeType);
            if (this.engine == null) {
                throw new IllegalArgumentException("Cannot find engine: " + this.mimeType);
            }
            if (!(this.engine instanceof Invocable)) {
                throw new IllegalArgumentException(String.valueOf(this.mimeType) + " dos not support javax.script.Invocable");
            }
            App app = App.instance();
            this.engine.put("App", app);
        }
        return this.engine;
    }

    public final void evaluate(File file) throws FileNotFoundException, ScriptException {
        block14: {
            if (file == null) {
                throw new NullPointerException("file");
            }
            ShowConsoleAction.console().clearConsole();
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                try {
                    InputStreamReader inputStreamReader;
                    try {
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new IllegalStateException(unsupportedEncodingException);
                    }
                    this.engine().eval(inputStreamReader);
                }
                catch (Throwable throwable) {
                    UIUtil.showError(throwable.getMessage());
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public final void evaluate(final String string) throws ScriptException {
        ShowConsoleAction.console().clearConsole();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("-> Run script:\n" + string);
                    }
                    ScriptRunner.this.engine().eval(string);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("<- Run script:\n" + string);
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ScriptException) {
                        if (LOG.isInfoEnabled()) {
                            LOG.error("Script error:", throwable);
                        } else {
                            LOG.error("Script error: " + throwable.getMessage());
                        }
                    }
                    LOG.error("Internal error on script run:", throwable);
                }
            }
        }).start();
    }

    public <T> T getGlobalInterface(Class<T> clazz) throws ClassNotFoundException {
        T t = this.getInvocable().getInterface(clazz);
        if (t == null) {
            throw new ClassNotFoundException("Cannot find interface " + clazz);
        }
        return t;
    }

    public <T> T getGlobalObjectAsInterface(String string, Class<T> clazz) throws ScriptException, NoSuchMethodException, NoSuchFieldException {
        Object object = this.engine().get(string);
        if (object == null) {
            throw new NoSuchFieldException("Cannot find object '" + string + '\'');
        }
        T t = this.getInvocable().getInterface(object, clazz);
        return t;
    }

    protected Invocable getInvocable() {
        return (Invocable)((Object)this.engine());
    }

    public Object invokeGlobalFunction(String string, Object ... objectArray) throws ScriptException, NoSuchMethodException {
        return this.getInvocable().invokeFunction(string, objectArray);
    }

    public Object invokeGlobalObjectMethod(String string, String string2, Object ... objectArray) throws ScriptException, NoSuchMethodException, NoSuchFieldException {
        Object object = this.engine().get(string);
        if (object == null) {
            throw new NoSuchFieldException("Cannot find object '" + string + '\'');
        }
        return this.getInvocable().invokeMethod(object, string2, objectArray);
    }
}

