/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.DocBase;
import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltawalker.ScriptRunner;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IScriptBoss;
import com.deltawalker.interfaces.IScriptDoc;
import com.deltawalker.internal.script.Comparison;
import com.deltawalker.internal.script.doc.ScriptDoc;
import com.deltawalker.internal.script.ui.ScriptEditor;
import com.deltawalker.script.App;
import com.deltawalker.script.Comparison;
import com.deltawalker.script.ComparisonEvent;
import com.deltawalker.ui.UIMsg;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.actions.ShowConsoleAction;
import com.deltopia.StringUtil;
import com.deltopia.interfaces.IJsonState;
import com.deltopia.ui.concurrency.GuiExecutor;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptBoss
extends Enum<ScriptBoss>
implements IScriptBoss,
IJsonState {
    public static final /* enum */ ScriptBoss INSTANCE = new ScriptBoss();
    private static final IApp app;
    private static final Logger LOG;
    private static final int MAX_HISTORY_SIZE = 10;
    private final List<IScriptDoc> docs = Collections.synchronizedList(new LinkedList());
    private int maxHistorySize;
    private final Map<String, ScriptRunner> runners = new HashMap<String, ScriptRunner>();
    private static final /* synthetic */ ScriptBoss[] ENUM$VALUES;

    static {
        ENUM$VALUES = new ScriptBoss[]{INSTANCE};
        app = com.deltawalker.App.instance();
        LOG = LoggerFactory.getLogger(ScriptBoss.class);
    }

    private ScriptBoss() {
        IPreferenceStore iPreferenceStore = PrefUtil.getGlobalPrefs();
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (PrefKey.C_MAX_HISTORY_SIZE.toString().equals(string)) {
                    ScriptBoss.this.setMaxHistorySize(((IPreferenceStore)propertyChangeEvent.getSource()).getInt(string));
                }
            }
        });
        this.setMaxHistorySize(iPreferenceStore.getInt(PrefKey.C_MAX_HISTORY_SIZE.toString()));
    }

    private boolean add(IScriptDoc iScriptDoc) {
        boolean bl = this.docs.add(iScriptDoc);
        if (bl) {
            this.removeSimilar(iScriptDoc);
            Collections.sort(this.docs);
            this.ensureMaxSize();
            if (LOG.isInfoEnabled()) {
                LOG.info("Adding: " + iScriptDoc.toString() + "   added: " + bl + "     size: " + this.docs.size());
            }
        }
        return bl;
    }

    @Override
    public int count() {
        int n = 0;
        for (IScriptDoc iScriptDoc : this.docs) {
            if (iScriptDoc.isEmpty()) continue;
            ++n;
        }
        return n;
    }

    private void ensureMaxSize() {
        assert (this.maxHistorySize >= 0);
        int n = this.docs.size();
        int n2 = this.docs.size() - 1;
        while (n2 >= 0 && n > this.maxHistorySize) {
            IScriptDoc iScriptDoc = this.docs.get(n2);
            this.remove(iScriptDoc);
            --n;
            --n2;
        }
    }

    @Override
    public void fireEvent(final Event event, final PropertyChangeEvent propertyChangeEvent, final IDiffDoc iDiffDoc) {
        if (!this.isRunning("application/javascript")) {
            return;
        }
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Comparison comparison = (Comparison)iDiffDoc.getHistoryEntry();
                    if (comparison == null) {
                        return;
                    }
                    switch (event) {
                        case COMPARE_STARTED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.COMPARE_STARTED, comparison));
                            break;
                        }
                        case WORKING: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.WORKING, comparison));
                            break;
                        }
                        case COMPARE_ENDED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.COMPARE_ENDED, comparison));
                            comparison.done();
                            break;
                        }
                        case COMPARISON_CLOSED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.CLOSED, comparison));
                            break;
                        }
                        case MERGE_STARTED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.MERGE_STARTED, comparison));
                            break;
                        }
                        case MERGE_ENDED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.MERGE_ENDED, comparison));
                            comparison.done();
                            break;
                        }
                        case PRINT_STARTED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.PRINT_STARTED, comparison));
                            break;
                        }
                        case PRINT_ENDED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.PRINT_ENDED, comparison));
                            comparison.done();
                            break;
                        }
                        case REPORT_STARTED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.REPORT_STARTED, comparison));
                            break;
                        }
                        case REPORT_ENDED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.REPORT_ENDED, comparison));
                            comparison.done();
                            break;
                        }
                        case SYNC_STARTED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.SYNC_STARTED, comparison));
                            break;
                        }
                        case SYNC_ENDED: {
                            comparison.fireComparisonChanged(new ComparisonEvent(Comparison.State.SYNC_ENDED, comparison));
                            comparison.done();
                            break;
                        }
                        case SETTING_CHANGED: {
                            ((com.deltawalker.internal.script.App)ScriptBoss.this.scriptApp()).fireSettingChanged(propertyChangeEvent, comparison);
                        }
                    }
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
                    if (throwable != null) {
                        System.err.println(throwable.toString());
                    } else {
                        System.err.println("Undeclared variable inside the ComparisonListener body.");
                    }
                }
                catch (Throwable throwable) {
                    System.err.println(throwable.getMessage());
                }
            }
        });
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            this.readScriptDoc(jsonReader);
        }
        jsonReader.endArray();
    }

    @Override
    public boolean isRunning(String string) {
        return this.runners.containsKey(string);
    }

    @Override
    public IScriptDoc openScript(String string, boolean bl) {
        ScriptDoc scriptDoc = new ScriptDoc();
        if (!StringUtil.isEmpty((String)string)) {
            scriptDoc.doLoad(string, null);
        }
        this.viewDoc(scriptDoc, bl);
        this.add(scriptDoc);
        return scriptDoc;
    }

    @Override
    public void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ScriptEditor) {
            ScriptEditor scriptEditor = (ScriptEditor)iWorkbenchPart;
            ScriptDoc scriptDoc = scriptEditor.getEditorInput();
            if (scriptDoc.resource() == null) {
                this.remove(scriptDoc);
                scriptDoc.dispose();
            } else {
                scriptDoc.reduceToSession();
            }
            iWorkbenchPart.dispose();
        }
    }

    private synchronized void readScriptDoc(JsonReader jsonReader) throws IOException {
        ScriptDoc scriptDoc = new ScriptDoc(jsonReader);
        this.add(scriptDoc);
    }

    public boolean remove(IScriptDoc iScriptDoc) {
        if (iScriptDoc == null) {
            throw new NullPointerException("sDoc");
        }
        boolean bl = this.docs.remove(iScriptDoc);
        if (bl) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Removing: " + iScriptDoc.toString() + "   removed: " + bl + "     size: " + this.docs.size());
            }
            app.stateBoss().saveState();
        }
        return bl;
    }

    private void removeSimilar(IScriptDoc iScriptDoc) {
        int n = this.docs.size() - 1;
        while (n >= 0) {
            IScriptDoc iScriptDoc2 = this.docs.get(n);
            if (iScriptDoc2 != iScriptDoc && ((ScriptDoc)iScriptDoc).uriInfo().uri().equals(((ScriptDoc)iScriptDoc2).uriInfo().uri())) {
                this.docs.remove(n);
            }
            --n;
        }
    }

    @Override
    public ScriptRunner runner(String string) {
        ScriptRunner scriptRunner = this.runners.get(string);
        if (scriptRunner == null) {
            scriptRunner = new ScriptRunner(string);
            this.runners.put(string, scriptRunner);
        }
        return scriptRunner;
    }

    @Override
    public App scriptApp() {
        return com.deltawalker.internal.script.App.instance();
    }

    @Override
    public TreeSet<IScriptDoc> scriptDocs() {
        TreeSet<IScriptDoc> treeSet = new TreeSet<IScriptDoc>();
        for (IScriptDoc iScriptDoc : this.docs) {
            if (((DocBase)((Object)iScriptDoc)).uriInfo().isEmpty()) continue;
            treeSet.add(iScriptDoc);
        }
        return treeSet;
    }

    public void setMaxHistorySize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maxSize");
        }
        if (this.maxHistorySize != n) {
            this.maxHistorySize = Math.min(10, n);
            this.ensureMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(JsonWriter jsonWriter) throws IOException {
        List<IScriptDoc> list = this.docs;
        synchronized (list) {
            jsonWriter.beginArray();
            for (IScriptDoc iScriptDoc : this.docs) {
                if (iScriptDoc.isEmpty()) continue;
                ((IJsonState)iScriptDoc).toJson(jsonWriter);
            }
            jsonWriter.endArray();
        }
    }

    @Override
    public void viewDoc(IScriptDoc iScriptDoc, boolean bl) {
        if (iScriptDoc == null) {
            throw new NullPointerException("sDoc");
        }
        try {
            IWorkbenchPage iWorkbenchPage = UIUtil.getActiveWindow().getActivePage();
            IEditorPart iEditorPart = iWorkbenchPage.openEditor((IEditorInput)iScriptDoc, ScriptEditor.ID);
            ShowConsoleAction.showConsole(iWorkbenchPage, false);
            iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
        }
        catch (PartInitException partInitException) {
            ErrorDialog.openError(null, null, (String)UIMsg.MvcBoss_errOpenFileComparison, (IStatus)partInitException.getStatus());
        }
    }

    public static ScriptBoss[] values() {
        ScriptBoss[] scriptBossArray = ENUM$VALUES;
        int n = scriptBossArray.length;
        ScriptBoss[] scriptBossArray2 = new ScriptBoss[n];
        System.arraycopy(ENUM$VALUES, 0, scriptBossArray2, 0, n);
        return scriptBossArray2;
    }

    public static ScriptBoss valueOf(String string) {
        return Enum.valueOf(ScriptBoss.class, string);
    }

    public static enum Event {
        COMPARE_ENDED,
        COMPARE_STARTED,
        COMPARISON_CLOSED,
        FILTERS_CHANGED,
        MERGE_ENDED,
        MERGE_STARTED,
        PRINT_ENDED,
        PRINT_STARTED,
        REPORT_ENDED,
        REPORT_STARTED,
        SETTING_CHANGED,
        SYNC_ENDED,
        SYNC_STARTED,
        WORKING;

    }
}

