/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.Relation;
import com.deltawalker.script.Delta;
import com.deltopia.util.BitUtil;
import com.deltopia.util.Checker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RelationKindCombs {
    private static final short[][] BITS;
    private static final Logger LOG;
    private static final boolean toLOG = false;
    private static final boolean toCACHE = true;
    private static final Cache CACHE;
    private static final Set<Delta.Kind> ALL_KINDS;

    static {
        LOG = LoggerFactory.getLogger(RelationKindCombs.class);
        CACHE = new Cache();
        Set<Relation> set = Relation.getNormList();
        Delta.Kind[] kindArray = Delta.Kind.values();
        ALL_KINDS = Collections.unmodifiableSet(new LinkedHashSet<Delta.Kind>(Arrays.asList(kindArray)));
        short[][] sArray = new short[set.size()][kindArray.length];
        for (Relation relation : set) {
            int n = relation.toNormInt();
            Delta.Kind[] kindArray2 = kindArray;
            int n2 = kindArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Delta.Kind kind = kindArray2[n3];
                int n4 = n * Delta.Kind.COUNT + kind.ordinal();
                if (n4 > 16) {
                    throw new IllegalStateException();
                }
                int n5 = 1 << n4;
                sArray[relation.toNormInt()][kind.ordinal()] = (short)n5;
                ++n3;
            }
        }
        BITS = sArray;
    }

    RelationKindCombs() {
    }

    static final Delta.Kind getKind(short s, Relation relation) {
        Checker.notNull((Object)((Object)relation), (String)"relation");
        int n = relation.toNormInt();
        for (Delta.Kind kind : ALL_KINDS) {
            short s2 = BITS[n][kind.ordinal()];
            if (!BitUtil.areBitsSet((short)s, (short)s2)) continue;
            return kind;
        }
        return null;
    }

    static final Map<Relation, Delta.Kind> getKinds(short s) {
        if (s == 0) {
            return Collections.emptyMap();
        }
        Map<Relation, Delta.Kind> map = CACHE.get(s);
        return map;
    }

    static final short setKind(short s, Relation relation, Delta.Kind kind) {
        Checker.notNull((Object)((Object)relation), (String)"relation");
        Checker.notNull((Object)((Object)kind), (String)"kind");
        int n = relation.toNormInt();
        short s2 = BITS[n][kind.ordinal()];
        short s3 = BitUtil.addBits((short)s, (short)s2);
        return s3;
    }

    static final short setKinds(Map<Relation, Delta.Kind> map) {
        Checker.notEmpty(map, (String)"map relations-kinds");
        short s = 0;
        for (Map.Entry<Relation, Delta.Kind> entry : map.entrySet()) {
            s = RelationKindCombs.setKind(s, entry.getKey(), entry.getValue());
        }
        return s;
    }

    private static final Map<Relation, Delta.Kind> createKinds(short s) {
        HashMap<Relation, Delta.Kind> hashMap = new HashMap<Relation, Delta.Kind>();
        Set<Relation> set = Relation.getNormList();
        for (Relation relation : set) {
            Delta.Kind kind = RelationKindCombs.getKind(s, relation);
            if (kind == null) continue;
            hashMap.put(relation, kind);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static final class Cache {
        private final Map<Short, Map<Relation, Delta.Kind>> map = new ConcurrentHashMap<Short, Map<Relation, Delta.Kind>>();

        private Cache() {
        }

        synchronized Map<Relation, Delta.Kind> get(short s) {
            Short s2 = s;
            Map map = this.map.get(s2);
            if (map == null) {
                map = RelationKindCombs.createKinds(s);
                this.map.put(s2, map);
            }
            return map;
        }
    }
}

