/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.script.Role;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Relation
extends Enum<Relation> {
    public static final /* enum */ Relation ONE_REF = new Relation(1, 0);
    public static final /* enum */ Relation ONE_TWO = new Relation(3, 2);
    public static final /* enum */ Relation REF_ONE = new Relation(0, 0);
    public static final /* enum */ Relation REF_TWO = new Relation(2, 1);
    private static final Relation[] AS_NORM_INT;
    private static final Set<Relation> AS_NORM_LIST;
    public static final String OLD_ONE_NAME = "first";
    public static final String OLD_REF_NAME = "ancestor";
    public static final String OLD_TWO_NAME = "second";
    private static final Set<Role> ONE_REF_TWO;
    private final int intVal;
    private final int normIntVal;
    private final Set<Role> setVal;
    private static final /* synthetic */ Relation[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Relation[]{ONE_REF, ONE_TWO, REF_ONE, REF_TWO};
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>();
        linkedHashSet.add(Role.ONE);
        linkedHashSet.add(Role.REF);
        linkedHashSet.add(Role.TWO);
        ONE_REF_TWO = Collections.unmodifiableSet(linkedHashSet);
        Relation[] relationArray = Relation.values();
        AS_NORM_INT = new Relation[relationArray.length];
        LinkedHashMap<Integer, Relation> linkedHashMap = new LinkedHashMap<Integer, Relation>(3);
        Relation[] relationArray2 = relationArray;
        int n = relationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Relation relation = relationArray2[n2];
            linkedHashMap.put(relation.normIntVal, relation);
            Relation.AS_NORM_INT[relation.normIntVal] = relation;
            ++n2;
        }
        AS_NORM_LIST = Collections.unmodifiableSet(new LinkedHashSet(linkedHashMap.values()));
    }

    public static Role argToRole(int n, int n2) {
        if (n2 == 1) {
            if (n == 0) {
                return Role.REF;
            }
            if (n == 1) {
                return Role.ONE;
            }
            if (n == 2) {
                return Role.TWO;
            }
        } else if (n2 == 2) {
            if (n == 0) {
                return Role.ONE;
            }
            if (n == 1) {
                return Role.REF;
            }
            if (n == 2) {
                return Role.TWO;
            }
        } else if (n2 >= 3) {
            if (n == 0) {
                return Role.REF;
            }
            if (n == 1) {
                return Role.TWO;
            }
            if (n == 2) {
                return Role.ONE;
            }
        }
        throw new IllegalArgumentException("argIx=" + n + ", argCount=" + n2);
    }

    public static Set<Role> copyOf(Set<Role> set) {
        return new LinkedHashSet<Role>(set);
    }

    public static Relation first(boolean bl) {
        return bl ? ONE_REF : REF_ONE;
    }

    public static Role firstRole(boolean bl) {
        return bl ? Role.ONE : Role.REF;
    }

    public static Relation fromArray(Role[] roleArray) throws NullPointerException, IllegalArgumentException {
        Set<Role> set = Relation.roleArrayToSet(roleArray);
        if (set.equals(REF_ONE.toSet())) {
            return REF_ONE;
        }
        if (set.equals(ONE_TWO.toSet())) {
            return ONE_TWO;
        }
        if (set.equals(REF_TWO.toSet())) {
            return REF_TWO;
        }
        throw new IllegalArgumentException("roles");
    }

    public static final Relation fromNormInt(int n) {
        if (n >= AS_NORM_INT.length || n < 0) {
            throw new IllegalArgumentException("Invalid relation index: " + n);
        }
        return AS_NORM_INT[n];
    }

    public static Relation fromRole(Role role, boolean bl) {
        if (bl) {
            if (role == Role.ONE) {
                return REF_ONE;
            }
            return REF_TWO;
        }
        return REF_ONE;
    }

    public static Relation fromRoles(Role role, Role role2) {
        if (role == null) {
            throw new NullPointerException("src");
        }
        if (role2 == null) {
            throw new NullPointerException("dst");
        }
        if (role == role2) {
            throw new IllegalArgumentException("'src' and 'dst' must be different");
        }
        if (role == Role.REF) {
            return role2 == Role.ONE ? REF_ONE : REF_TWO;
        }
        if (role == Role.ONE) {
            return role2 == Role.REF ? REF_ONE : ONE_TWO;
        }
        assert (role == Role.TWO);
        return role2 == Role.REF ? REF_TWO : ONE_TWO;
    }

    public static final Set<Relation> getNormList() {
        return AS_NORM_LIST;
    }

    public static Relation last(boolean bl) {
        return bl ? REF_TWO : REF_ONE;
    }

    public static Role lastRole(boolean bl) {
        return bl ? Role.TWO : Role.ONE;
    }

    public static String oldRoleName(Role role) {
        if (role == null) {
            throw new NullPointerException("role");
        }
        switch (role) {
            case REF: {
                return OLD_REF_NAME;
            }
            case ONE: {
                return OLD_ONE_NAME;
            }
            case TWO: {
                return OLD_TWO_NAME;
            }
        }
        throw new IllegalArgumentException("role");
    }

    public static Set<Role> others(Role role, boolean bl) {
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>(bl ? 2 : 1);
        for (Role role2 : ONE_REF_TWO) {
            if (!bl && role2 == Role.TWO || role2 == role) continue;
            linkedHashSet.add(role2);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public static Set<Role> readRoles(JsonReader jsonReader) throws IOException {
        EnumSet<Role> enumSet = EnumSet.noneOf(Role.class);
        jsonReader.beginArray();
        while (jsonReader.hasNext() && jsonReader.peek() != JsonToken.NULL) {
            String string = jsonReader.nextString();
            if (string.equals(Role.REF.toString())) {
                enumSet.add(Role.REF);
                continue;
            }
            if (string.equals(Role.ONE.toString())) {
                enumSet.add(Role.ONE);
                continue;
            }
            if (string.equals(Role.TWO.toString())) {
                enumSet.add(Role.TWO);
                continue;
            }
            assert (false);
        }
        jsonReader.endArray();
        return enumSet;
    }

    public static Set<Role> roleArrayToSet(Role[] roleArray) {
        if (roleArray == null) {
            throw new NullPointerException("roles");
        }
        if (roleArray.length == 0) {
            throw new IllegalArgumentException("'roles' cannot be empty");
        }
        EnumSet<Role> enumSet = EnumSet.noneOf(Role.class);
        if (roleArray != null) {
            Role[] roleArray2 = roleArray;
            int n = roleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Role role = roleArray2[n2];
                if (role != null) {
                    enumSet.add(role);
                }
                ++n2;
            }
        }
        return enumSet;
    }

    public static Set<Role> roles(boolean bl) {
        return bl ? ONE_REF_TWO : REF_ONE.toSet();
    }

    private Relation(int n2, int n3) {
        this.intVal = n2;
        this.normIntVal = n3;
        LinkedHashSet<Role> linkedHashSet = new LinkedHashSet<Role>();
        switch (n2) {
            case 0: {
                linkedHashSet = new LinkedHashSet();
                linkedHashSet.add(Role.REF);
                linkedHashSet.add(Role.ONE);
                this.setVal = Collections.unmodifiableSet(linkedHashSet);
                break;
            }
            case 1: {
                linkedHashSet = new LinkedHashSet();
                linkedHashSet.add(Role.ONE);
                linkedHashSet.add(Role.REF);
                this.setVal = Collections.unmodifiableSet(linkedHashSet);
                break;
            }
            case 2: {
                linkedHashSet = new LinkedHashSet();
                linkedHashSet.add(Role.REF);
                linkedHashSet.add(Role.TWO);
                this.setVal = Collections.unmodifiableSet(linkedHashSet);
                break;
            }
            case 3: {
                linkedHashSet = new LinkedHashSet();
                linkedHashSet.add(Role.ONE);
                linkedHashSet.add(Role.TWO);
                this.setVal = Collections.unmodifiableSet(linkedHashSet);
                break;
            }
            default: {
                throw new IllegalArgumentException("intVal");
            }
        }
    }

    public boolean contains(Role role) {
        return this.setVal.contains((Object)role);
    }

    public Role firstRole() {
        switch (this) {
            case REF_ONE: {
                return Role.REF;
            }
            case ONE_REF: {
                return Role.ONE;
            }
            case REF_TWO: {
                return Role.REF;
            }
            case ONE_TWO: {
                return Role.ONE;
            }
        }
        throw new IllegalStateException("A relation that's unaccounted for.");
    }

    public Role lastRole() {
        switch (this) {
            case REF_ONE: {
                return Role.ONE;
            }
            case ONE_REF: {
                return Role.REF;
            }
            case REF_TWO: {
                return Role.TWO;
            }
            case ONE_TWO: {
                return Role.TWO;
            }
        }
        throw new IllegalStateException("A relation that's unaccounted for.");
    }

    public int toInt() {
        return this.intVal;
    }

    public int toNormInt() {
        return this.normIntVal;
    }

    public Set<Role> toSet() {
        return this.setVal;
    }

    public String toString() {
        return this.setVal.toString();
    }

    public static Relation[] values() {
        Relation[] relationArray = ENUM$VALUES;
        int n = relationArray.length;
        Relation[] relationArray2 = new Relation[n];
        System.arraycopy(ENUM$VALUES, 0, relationArray2, 0, n);
        return relationArray2;
    }

    public static Relation valueOf(String string) {
        return Enum.valueOf(Relation.class, string);
    }
}

