/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.JobBoss;
import com.deltawalker.ScriptBoss;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IPrintBoss;
import com.deltawalker.internal.ui.printing.PageRangePrinter;
import com.deltawalker.ui.DiffView;
import com.deltawalker.ui.UIUtil;
import com.deltawalker.ui.printing.IPrintable;
import com.deltawalker.ui.printing.IPrinter;
import com.deltawalker.ui.printing.PageSetup;
import com.deltawalker.ui.printing.PrintPreviewWindow;
import com.deltawalker.ui.printing.PrinterPrinter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PrintBoss implements IPrintBoss
{
    INSTANCE;

    private static final Logger LOG;
    private PageSetup pageSetup;
    private PrintPreviewWindow preview;
    private PrinterData printerData = Printer.getDefaultPrinterData();

    static {
        LOG = LoggerFactory.getLogger(PrintBoss.class);
    }

    @Override
    public PageSetup getPageSetup() {
        if (this.pageSetup == null) {
            this.pageSetup = new PageSetup(true);
        }
        return this.pageSetup;
    }

    @Override
    public PrinterData getPrinterData(boolean bl) {
        PrinterData printerData;
        if (this.printerData != null) {
            return this.printerData;
        }
        if (LOG.isInfoEnabled()) {
            long l = System.currentTimeMillis();
            Printer.getDefaultPrinterData();
            l = System.currentTimeMillis() - l;
            LOG.info("Printer.getDefaultPrinterData()=" + l);
            l = System.currentTimeMillis();
            Printer.getPrinterList();
            l = System.currentTimeMillis() - l;
            LOG.info("Printer.getPrinterList()=" + l);
        }
        if ((printerData = Printer.getDefaultPrinterData()) == null && !bl) {
            throw new IllegalStateException("No default printer installed or set");
        }
        return printerData;
    }

    @Override
    public PrintPreviewWindow previewWindow() {
        return this.preview;
    }

    @Override
    public void print(final IPrintable iPrintable, final IProgressMonitor iProgressMonitor, boolean bl) {
        PageSetup pageSetup;
        IApp iApp;
        if (bl) {
            iApp = new PrintDialog(UIUtil.getActiveWindowShell(), 0x10008000);
            iApp.setPrinterData(this.getPrinterData(true));
            pageSetup = iApp.open();
            if (pageSetup == null) {
                return;
            }
            this.printerData = pageSetup;
        }
        iApp = App.instance();
        pageSetup = this.getPageSetup();
        PrinterPrinter printerPrinter = new PrinterPrinter(pageSetup);
        final IPrinter iPrinter = this.printerData.scope == 1 ? new PageRangePrinter(printerPrinter, this.printerData.startPage, this.printerData.endPage) : printerPrinter;
        final IDiffDoc iDiffDoc = ((DiffView)((Object)iPrintable)).getInput();
        Job job = new Job("Printing"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                IStatus iStatus;
                iApp.scriptBoss().fireEvent(ScriptBoss.Event.PRINT_STARTED, null, iDiffDoc);
                try {
                    iPrintable.print(iPrinter, iProgressMonitor);
                    iStatus = iProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
                catch (OperationCanceledException operationCanceledException) {
                    iStatus = Status.CANCEL_STATUS;
                }
                return iStatus;
            }
        };
        job.setUser(false);
        job.addJobChangeListener(JobBoss.INSTANCE.jobListener());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                iProgressMonitor.done();
                iPrinter.dispose();
                iApp.scriptBoss().fireEvent(ScriptBoss.Event.PRINT_ENDED, null, iDiffDoc);
                IStatus iStatus = iJobChangeEvent.getResult();
                if (!iStatus.isOK()) {
                    LOG.error("Error printing.", iStatus.getException());
                }
            }
        });
        job.schedule();
    }

    @Override
    public PrinterData[] printers() {
        return Printer.getPrinterList();
    }

    @Override
    public void printPreview(IPrintable iPrintable, final IAction iAction, final IAction iAction2) {
        try {
            if (this.preview == null) {
                this.preview = new PrintPreviewWindow(UIUtil.getActiveWindowShell(), iPrintable){

                    @Override
                    protected IAction createButtonAction(int n) {
                        switch (n) {
                            case 2: {
                                return iAction;
                            }
                            case 4: {
                                return iAction2;
                            }
                        }
                        return super.createButtonAction(n);
                    }
                };
            }
            this.preview.open();
        }
        finally {
            this.preview = null;
        }
    }

    @Override
    public void setPageSetup(PageSetup pageSetup) {
        if (this.pageSetup != pageSetup) {
            this.pageSetup = pageSetup;
            App.instance().stateBoss().saveState();
        }
    }

    @Override
    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }
}

