/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.PrefKey;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.internal.ChainedPrefStore;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.internal.SessionPrefStore;
import com.deltopia.interfaces.IJsonState;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrefUtil {
    private static final IPreferenceStore globalPrefs;
    private static final Logger LOG;
    private static boolean runOnce;

    static {
        Bundle[] bundleArray;
        LOG = LoggerFactory.getLogger(PrefUtil.class);
        runOnce = false;
        final Bundle bundle = DeltaWalkerPlugin.getDefault().getBundle();
        final BundleContext bundleContext = bundle.getBundleContext();
        final ChainedPrefStore chainedPrefStore = new ChainedPrefStore();
        bundleContext.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                Bundle bundle2 = bundleEvent.getBundle();
                switch (bundleEvent.getType()) {
                    case 2: {
                        PrefUtil.updatePrefChaining(bundle2, true, chainedPrefStore);
                        break;
                    }
                    case 256: {
                        PrefUtil.updatePrefChaining(bundle2, false, chainedPrefStore);
                        if (!bundle.equals(bundle2)) break;
                        bundleContext.removeBundleListener((BundleListener)this);
                    }
                }
            }
        });
        Bundle[] bundleArray2 = bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle2 = bundleArray2[n2];
            PrefUtil.updatePrefChaining(bundle2, true, chainedPrefStore);
            ++n2;
        }
        globalPrefs = chainedPrefStore;
    }

    public static IPreferenceStore cloneSessionPrefs(IPreferenceStore iPreferenceStore) {
        return new SessionPrefStore(iPreferenceStore);
    }

    public static PreferenceDialog createPrefDialogOn(Shell shell, String string, String[] stringArray) {
        if (!runOnce) {
            PrefUtil.removePrefPages();
            runOnce = true;
        }
        return PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)string, (String[])stringArray, null);
    }

    public static IPreferenceStore createSessionPrefs() {
        return new SessionPrefStore();
    }

    public static IPreferenceStore getGlobalPrefs() {
        return globalPrefs;
    }

    public static IPreferenceStore getPrefStore() {
        return DeltaWalkerPlugin.getDefault().getPreferenceStore();
    }

    public static int openPrefDialogOn(Shell shell, String string, String[] stringArray) {
        PreferenceDialog preferenceDialog = PrefUtil.createPrefDialogOn(shell, string, stringArray);
        preferenceDialog.getTreeViewer().expandAll();
        return preferenceDialog.open();
    }

    public static void readPrefs(JsonReader jsonReader, IPreferenceStore iPreferenceStore) throws IOException {
        IApp iApp = App.instance();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals("contentTypes")) {
                ((IJsonState)iApp.contentTypeBoss()).fromJson(jsonReader);
                continue;
            }
            if (string.equals("filters")) {
                ((IJsonState)iApp.filterBoss()).fromJson(jsonReader);
                continue;
            }
            PrefKey prefKey = PrefKey.fromString(string);
            if (prefKey != null) {
                String string2 = PrefKey.deminify(prefKey, jsonReader.nextString()).toString();
                iPreferenceStore.putValue(string, string2);
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown PrefKey: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    private static void removePrefPages() {
        IPreferenceNode iPreferenceNode;
        int n;
        int n2;
        IPreferenceNode iPreferenceNode22;
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode iPreferenceNode3 = preferenceManager.getRootSubNodes();
        IPreferenceNode iPreferenceNode4 = preferenceManager.find("org.eclipse.ui.preferencePages.Workbench");
        IPreferenceNode iPreferenceNode5 = preferenceManager.find("com.deltawalker.GeneralPrefPage");
        if (LOG.isInfoEnabled()) {
            iPreferenceNode22 = iPreferenceNode3;
            n2 = ((IPreferenceNode[])iPreferenceNode22).length;
            n = 0;
            while (n < n2) {
                iPreferenceNode = iPreferenceNode22[n];
                LOG.info(iPreferenceNode.getId());
                ++n;
            }
        }
        if (iPreferenceNode4 != null) {
            iPreferenceNode3 = iPreferenceNode4.getSubNodes();
            if (LOG.isInfoEnabled()) {
                iPreferenceNode22 = iPreferenceNode3;
                n2 = ((IPreferenceNode[])iPreferenceNode22).length;
                n = 0;
                while (n < n2) {
                    iPreferenceNode = iPreferenceNode22[n];
                    LOG.info(iPreferenceNode.getId());
                    ++n;
                }
            }
            iPreferenceNode4.remove("org.eclipse.ui.preferencePages.Editors");
            iPreferenceNode4.remove("org.eclipse.ui.preferencePages.Workspace");
            iPreferenceNode4.remove("org.eclipse.ui.preferencePages.ContentTypes");
            iPreferenceNode4.remove("org.eclipse.ui.preferencePages.Perspectives");
            iPreferenceNode4.remove("org.eclipse.ui.preferencePages.NewKeys");
            iPreferenceNode5.remove("com.deltawalker.TrustedPathsPrefPage");
            iPreferenceNode = iPreferenceNode4.findSubNode("org.eclipse.ui.preferencePages.Keys");
            iPreferenceNode5.add(iPreferenceNode);
            iPreferenceNode4.remove(iPreferenceNode);
            IPreferenceNode iPreferenceNode6 = iPreferenceNode4.findSubNode("org.eclipse.ui.preferencePages.Views");
            iPreferenceNode3 = iPreferenceNode6.getSubNodes();
            if (LOG.isInfoEnabled()) {
                IPreferenceNode iPreferenceNode7 = iPreferenceNode3;
                int n3 = ((IPreferenceNode[])iPreferenceNode7).length;
                int n4 = 0;
                while (n4 < n3) {
                    IPreferenceNode iPreferenceNode8 = iPreferenceNode7[n4];
                    LOG.info(iPreferenceNode8.getId());
                    ++n4;
                }
            }
            IPreferenceNode iPreferenceNode9 = iPreferenceNode6.findSubNode("org.eclipse.ui.preferencePages.ColorsAndFonts");
            iPreferenceNode5.add(iPreferenceNode9);
            iPreferenceNode4.remove(iPreferenceNode6);
            iPreferenceNode22 = iPreferenceNode4.findSubNode("org.eclipse.equinox.security.ui.category");
            if (iPreferenceNode22 != null) {
                iPreferenceNode4.remove("org.eclipse.equinox.security.ui.category");
            }
            iPreferenceNode4.remove("org.eclipse.compare.internal.ComparePreferencePage");
        }
        preferenceManager.remove(iPreferenceNode4);
        iPreferenceNode = preferenceManager.remove("org.eclipse.help.ui.browsersPreferencePage");
        if (iPreferenceNode != null) {
            preferenceManager.remove("org.eclipse.help.ui.contentPreferencePage");
        }
        preferenceManager.remove(iPreferenceNode);
        IPreferenceNode iPreferenceNode10 = preferenceManager.find("com.deltawalker.text.TextPrefPage/org.eclipse.ui.preferencePages.GeneralTextEditor");
        if (iPreferenceNode10 != null) {
            iPreferenceNode10.remove("org.eclipse.ui.editors.preferencePages.Annotations");
            iPreferenceNode10.remove("org.eclipse.ui.editors.preferencePages.QuickDiff");
            iPreferenceNode10.remove("org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage");
            iPreferenceNode10.remove("org.eclipse.ui.editors.preferencePages.Accessibility");
            iPreferenceNode10.remove("org.eclipse.ui.editors.preferencePages.Spelling");
            iPreferenceNode10.remove("org.eclipse.ui.editors.preferencePages.HyperlinkDetectorsPreferencePage");
        }
        if (LOG.isInfoEnabled()) {
            List list = preferenceManager.getElements(0);
            LOG.info("REMAINING PREFERENCE PAGES:");
            for (IPreferenceNode iPreferenceNode22 : list) {
                LOG.info(iPreferenceNode22.getId());
            }
        }
    }

    private static void updatePrefChaining(Bundle bundle, boolean bl, ChainedPrefStore chainedPrefStore) {
        IPreferenceStore iPreferenceStore;
        Method method;
        Class clazz;
        if (bundle.getState() != 32) {
            return;
        }
        String string = bundle.getSymbolicName();
        if (!string.startsWith("com.deltawalker")) {
            return;
        }
        String string2 = (String)bundle.getHeaders().get("Bundle-Activator");
        if (string2 == null) {
            return;
        }
        try {
            clazz = bundle.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz == null) {
            return;
        }
        try {
            method = clazz.getMethod("getDefault", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        if (method == null) {
            return;
        }
        Object object = null;
        try {
            object = method.invoke(null, null);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (object instanceof AbstractUIPlugin && (iPreferenceStore = ((AbstractUIPlugin)object).getPreferenceStore()) != null) {
            if (bl) {
                chainedPrefStore.addPreferenceStore(iPreferenceStore, string);
            } else {
                chainedPrefStore.removePreferenceStore(iPreferenceStore, string);
            }
        }
    }

    public static void writePrefs(JsonWriter jsonWriter, IPreferenceStore iPreferenceStore) throws IOException {
        IApp iApp = App.instance();
        jsonWriter.beginObject();
        PrefKey[] prefKeyArray = PrefKey.values();
        int n = prefKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrefKey prefKey = prefKeyArray[n2];
            String string = prefKey.toString();
            prefKey.toJsonWriter(jsonWriter, iPreferenceStore.getString(string));
            ++n2;
        }
        jsonWriter.name("filters");
        ((IJsonState)iApp.filterBoss()).toJson(jsonWriter);
        jsonWriter.name("contentTypes");
        ((IJsonState)iApp.contentTypeBoss()).toJson(jsonWriter);
        jsonWriter.endObject();
    }

    private PrefUtil() {
    }
}

