/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.PrefKey;
import com.deltopia.StringUtil;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.preference.IPreferenceStore;

public final class LocaleUtil {
    private static final Map<String, Locale> dispLoc2Loc;
    private static Locale locale;

    static {
        Locale[] localeArray;
        dispLoc2Loc = new TreeMap<String, Locale>();
        Locale[] localeArray2 = localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray2[n2];
            String string = locale.getDisplayName();
            dispLoc2Loc.put(string, locale);
            ++n2;
        }
    }

    public static String[] getDisplayLocaleNames() {
        return dispLoc2Loc.keySet().toArray(new String[dispLoc2Loc.size()]);
    }

    public static Locale getLocale(IPreferenceStore iPreferenceStore) {
        String string = iPreferenceStore.getString(PrefKey.T_ENCODING_LOCALE.toString());
        return LocaleUtil.getLocale(string);
    }

    public static synchronized Locale getLocale(String string) {
        if (!StringUtil.isEmpty((String)string)) {
            if (locale != null && locale.toString().equals(string)) {
                return locale;
            }
            Object[] objectArray = string.split("_");
            if (objectArray.length > 0) {
                String string2 = objectArray[0];
                if (objectArray.length == 1) {
                    locale = new Locale(string2);
                } else {
                    String string3 = objectArray[1];
                    if (objectArray.length == 2) {
                        locale = new Locale(string2, string3);
                    } else {
                        String string4 = StringUtil.join((Object[])objectArray, (int)2, (int)objectArray.length, (String)"_");
                        locale = new Locale(string2, string3, string4);
                    }
                }
                return locale;
            }
        }
        return null;
    }

    public static Locale getLocaleFromDisplayName(String string) {
        return dispLoc2Loc.get(string);
    }

    private LocaleUtil() {
    }
}

