/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.PrefKey;
import com.deltawalker.PrefUtil;
import com.deltopia.util.Const;

public final class LineEndingUtil {
    public static final String MACOS9_ENDING = "\r";
    private static final String MACOS9_ENDING_NAME = "Mac OS 9";
    public static final String OS_ENDING_NAME = LineEndingUtil.nameFromEnding(Const.LINE_ENDING);
    public static final String UNIX_ENDING = "\n";
    private static final String UNIX_ENDING_NAME = "Unix";
    public static final String WINDOWS_ENDING = "\r\n";
    private static final String WINDOWS_ENDING_NAME = "Windows";

    public static String[] endingNames() {
        return new String[]{WINDOWS_ENDING_NAME, UNIX_ENDING_NAME, MACOS9_ENDING_NAME};
    }

    public static String fromName(String string) {
        if (UNIX_ENDING_NAME.equals(string)) {
            return UNIX_ENDING;
        }
        if (WINDOWS_ENDING_NAME.equals(string)) {
            return WINDOWS_ENDING;
        }
        if (MACOS9_ENDING_NAME.equals(string)) {
            return MACOS9_ENDING;
        }
        assert (false);
        return LineEndingUtil.fromPreferences();
    }

    public static String fromPreferences() {
        return LineEndingUtil.fromName(PrefUtil.getGlobalPrefs().getString(PrefKey.T_LINE_ENDING.toString()));
    }

    public static String nameFromEnding(String string) {
        if (UNIX_ENDING.equals(string)) {
            return UNIX_ENDING_NAME;
        }
        if (WINDOWS_ENDING.equals(string)) {
            return WINDOWS_ENDING_NAME;
        }
        if (MACOS9_ENDING.equals(string)) {
            return MACOS9_ENDING_NAME;
        }
        throw new IllegalArgumentException("ending");
    }
}

