/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.ImageConst;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.UIUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageCache {
    private static ImageRegistry imgRegistry;
    private static final Map<String, Map<EnumSet<Type>, Image>> procImgCache;

    static {
        procImgCache = new HashMap<String, Map<EnumSet<Type>, Image>>();
    }

    public static Image getImage(String string) {
        return ImageCache.getImage(DeltaWalkerPlugin.getPluginId(), string);
    }

    public static Image getImage(String string, String string2) {
        ImageRegistry imageRegistry = ImageCache.getImageRegistry();
        Image image = imageRegistry.get(string2);
        if (image == null) {
            ImageCache.registerImage(string, string2);
        }
        return imageRegistry.get(string2);
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return ImageCache.getImageDescriptor(DeltaWalkerPlugin.getPluginId(), string);
    }

    public static ImageDescriptor getImageDescriptor(String string, String string2) {
        ImageRegistry imageRegistry = ImageCache.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(string2);
        if (imageDescriptor == null) {
            ImageCache.registerImage(string, string2);
        }
        return imageRegistry.getDescriptor(string2);
    }

    public static ImageRegistry getImageRegistry() {
        if (imgRegistry == null) {
            imgRegistry = new ImageRegistry(UIUtil.display());
        }
        return imgRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getProcessedImage(Image image, String string, EnumSet<Type> enumSet) {
        Image image2;
        Map<EnumSet<Type>, Image> map;
        if (image == null) {
            throw new NullPointerException("image");
        }
        if (string == null) {
            throw new NullPointerException("key");
        }
        if (enumSet == null || enumSet.size() == 0) {
            return image;
        }
        Image image3 = procImgCache;
        synchronized (image3) {
            map = procImgCache.get(string);
            if (map == null) {
                map = new HashMap<EnumSet<Type>, Image>(1);
                procImgCache.put(string, map);
            }
        }
        image3 = map.get(enumSet);
        if (image3 != null) {
            return image3;
        }
        image3 = image;
        if (enumSet.contains((Object)Type.NO_PERMISSION)) {
            image2 = ImageCache.getImage(ImageConst.NO_ACCESS_OVR);
            image3 = image.createOverlayCopy(image2, 132096, 1.0, 0.9);
        }
        if (enumSet.contains((Object)Type.SYM_LINK)) {
            image2 = ImageCache.getImage(ImageConst.SYM_LINK);
            image3 = image.createOverlayCopy(image2, 17408, 1.0, 0.9);
        }
        map.put(enumSet, image3);
        return image3;
    }

    public static final Image getProcessedImage(String string, EnumSet<Type> enumSet) {
        if (string == null) {
            throw new NullPointerException("imagePath");
        }
        Image image = ImageCache.getImage(string);
        if (image == null) {
            throw new IllegalArgumentException("Unknown image path " + string);
        }
        return ImageCache.getProcessedImage(image, "/" + string, enumSet);
    }

    public static final void registerImage(String string, String string2) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)string, (String)string2);
        imgRegistry.put(string2, imageDescriptor);
    }

    public static enum Type {
        NO_PERMISSION,
        SYM_LINK;

    }
}

