/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilters;
import com.deltopia.util.OS;
import java.util.List;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class FilterTable
extends Composite {
    public static final int DEFAULT_WIDTH = 450;
    private final CheckboxTableViewer tableViewer;
    protected final TableColumnLayout tcLayout = new TableColumnLayout();

    public static void increaseFontSize(Control control) {
        if (OS.OSX) {
            Font font = control.getFont();
            FontData[] fontDataArray = font.getFontData();
            fontDataArray[0].height += 2.0f;
            control.setFont(new Font((Device)control.getDisplay(), fontDataArray));
        }
    }

    public FilterTable(Composite composite, int n, IFilters iFilters) {
        super(composite, n);
        Table table = new Table((Composite)this, n | 0x800 | 0x20 | 0x10000 | 4);
        table.setHeaderVisible(true);
        this.setLayout((Layout)this.tcLayout);
        this.setupTable(table);
        this.tableViewer = new CheckboxTableViewer(table){

            protected void doUpdateItem(Widget widget, Object object, boolean bl) {
                super.doUpdateItem(widget, object, bl);
                ((TableItem)widget).setChecked(((IFilter)object).isEnabled());
            }

            protected void handleDispose(DisposeEvent disposeEvent) {
                try {
                    FilterTable.this.handleDispose(disposeEvent);
                }
                finally {
                    super.handleDispose(disposeEvent);
                }
            }

            protected void preservingSelection(Runnable runnable) {
                super.preservingSelection(runnable);
                Object object = this.getInput();
                if (object != null) {
                    Object[] objectArray;
                    Object[] objectArray2 = objectArray = ((IStructuredContentProvider)this.getContentProvider()).getElements(this.getInput());
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object2 = objectArray2[n2];
                        this.setChecked(object2, ((IFilter)object2).isEnabled());
                        ++n2;
                    }
                }
            }
        };
        this.tableViewer.setContentProvider((IContentProvider)new FilterContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                IFilter iFilter = (IFilter)checkStateChangedEvent.getElement();
                FilterTable.this.checkStateChanged(iFilter, FilterTable.this.indexOf(iFilter), checkStateChangedEvent.getChecked());
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13) {
                    FilterTable.this.tableViewer.getTable().getShell().close();
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = (TableItem)selectionEvent.item;
                FilterTable.this.checkStateChanged(FilterTable.this.getSelection(), ((Table)selectionEvent.widget).indexOf(tableItem), !tableItem.getChecked());
            }
        });
        this.tableViewer.setInput((Object)iFilters);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.tableViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    protected void checkFilter(IFilter iFilter, boolean bl) {
        this.tableViewer.setChecked((Object)iFilter, bl);
    }

    protected void checkStateChanged(IFilter iFilter, int n, boolean bl) {
        IFilters iFilters = (IFilters)this.tableViewer.getInput();
        iFilters.updateEnabled(iFilter, bl);
        this.checkFilter(iFilter, bl);
    }

    protected int computeWidth(String string) {
        int n;
        GC gC = new GC((Drawable)this);
        try {
            n = gC.textExtent((String)string).x;
        }
        finally {
            gC.dispose();
        }
        return n + 15;
    }

    protected abstract String getColumnText(Object var1, int var2);

    protected Object[] getFilterElements(List<IFilter> list) {
        return list.toArray();
    }

    public IFilter getSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.tableViewer.getSelection();
        return iStructuredSelection.isEmpty() ? null : (IFilter)iStructuredSelection.getFirstElement();
    }

    public int getSelectionIndex() {
        return this.tableViewer.getTable().getSelectionIndex();
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        this.setFilters(null);
    }

    private int indexOf(IFilter iFilter) {
        Table table = this.tableViewer.getTable();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (tableItemArray[n2].getData() == iFilter) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void refresh(IFilter iFilter) {
        this.tableViewer.refresh((Object)iFilter);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tableViewer.getTable().setEnabled(bl);
    }

    public void setFilters(IFilters iFilters) {
        IFilters iFilters2 = (IFilters)this.tableViewer.getInput();
        if (iFilters != iFilters2) {
            this.tableViewer.setInput((Object)iFilters);
            this.tableViewer.refresh();
        }
    }

    public void setSelection(IFilter iFilter) {
        if (iFilter == null) {
            throw new NullPointerException("filter");
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)iFilter);
        this.tableViewer.setSelection((ISelection)structuredSelection, true);
    }

    public void setSelectionIndex(int n) {
        Table table = this.tableViewer.getTable();
        int n2 = table.getItemCount();
        if (n >= n2) {
            n = n2 - 1;
        }
        if (n > 0) {
            this.tableViewer.getTable().setSelection(n);
        }
    }

    protected abstract void setupTable(Table var1);

    public Table table() {
        return this.tableViewer.getTable();
    }

    private class FilterContentProvider
    implements IStructuredContentProvider {
        private FilterContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return FilterTable.this.getFilterElements(((IFilters)object).getAllAsList());
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private class FilterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FilterLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            return FilterTable.this.getColumnText(object, n);
        }
    }
}

