/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.interfaces.IFilter;
import com.deltawalker.interfaces.IFilterBoss;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.interfaces.IFiltersListener;
import com.deltawalker.text.Filters;
import com.deltopia.interfaces.IJsonState;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FilterBoss implements IFilterBoss,
IJsonState
{
    INSTANCE;

    private static final Logger LOG;
    Map<DocType, IFilters> defFilters = new Hashtable<DocType, IFilters>(2);
    Map<DocType, IFilters> factoryFilters = new Hashtable<DocType, IFilters>(2);
    Map<UUID, IFiltersListener> filterListeners = new Hashtable<UUID, IFiltersListener>();
    Map<UUID, IFilters> sessionFilters = new Hashtable<UUID, IFilters>();

    static {
        LOG = LoggerFactory.getLogger(FilterBoss.class);
    }

    @Override
    public void addSessionFilters(IFilters iFilters) {
        if (iFilters == null) {
            throw new NullPointerException("filters");
        }
        UUID uUID = iFilters.id();
        this.sessionFilters.put(uUID, iFilters);
        if (LOG.isInfoEnabled()) {
            LOG.info("Adding session filters: " + uUID + " size:" + this.sessionFilters.size());
        }
        IFiltersListener iFiltersListener = new IFiltersListener(){

            @Override
            public void filtersChanged(Set<? extends IFilter> set) {
                App.instance().stateBoss().saveState();
            }
        };
        iFilters.addFilterListener(iFiltersListener);
        this.filterListeners.put(uUID, iFiltersListener);
    }

    @Override
    public IFilters cloneSessionFilters(IFilters iFilters, DocType docType) {
        Filters filters = new Filters(iFilters.getAllAsList(), docType);
        this.addSessionFilters(filters);
        return filters;
    }

    @Override
    public IFilters createSessionFilters(DocType docType) {
        Filters filters = new Filters((Filters)this.getDefaultFilters(docType));
        this.addSessionFilters(filters);
        return filters;
    }

    public void fromJson(JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string = jsonReader.nextName();
            if (string.equals(DocType.FOLDER.toJson())) {
                this.defFilters.put(DocType.FOLDER, new Filters(jsonReader, DocType.FOLDER));
                continue;
            }
            if (string.equals(DocType.TEXT.toJson())) {
                this.defFilters.put(DocType.TEXT, new Filters(jsonReader, DocType.TEXT));
                continue;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unknown JSON key: " + string);
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    @Override
    public IFilters getDefaultFilters(DocType docType) {
        if (docType == null) {
            throw new NullPointerException("docType");
        }
        IFilters iFilters = this.defFilters.get((Object)docType);
        if (docType.isStructure() && iFilters != null) {
            IFilters iFilters2 = this.defFilters.get((Object)DocType.TEXT);
            iFilters.updateAllOfType(iFilters2.getAllAsList(), DocType.TEXT);
        }
        return iFilters;
    }

    @Override
    public IFilters getFactoryDefaultFilters(DocType docType) {
        return this.factoryFilters.get((Object)docType);
    }

    @Override
    public IFilters getSessionFilters(UUID uUID) {
        return uUID != null ? this.sessionFilters.get(uUID) : null;
    }

    @Override
    public boolean removeSessionFilters(IFilters iFilters) {
        return this.removeSessionFilters(iFilters.id());
    }

    @Override
    public boolean removeSessionFilters(UUID uUID) {
        IFilters iFilters = this.sessionFilters.get(uUID);
        if (iFilters != null) {
            IFiltersListener iFiltersListener = this.filterListeners.get(uUID);
            iFilters.removeFilterListener(iFiltersListener);
            this.filterListeners.remove(uUID);
            this.sessionFilters.remove(uUID);
            if (LOG.isInfoEnabled()) {
                LOG.info("Removing session filters: " + uUID + " size:" + this.sessionFilters.size());
            }
            return true;
        }
        return false;
    }

    @Override
    public void setDefaultFilters(IFilters iFilters) {
        this.defFilters.put(iFilters.docType(), iFilters);
    }

    @Override
    public void setFactoryDefaultFilters(IFilters iFilters) {
        DocType docType = iFilters.docType();
        this.factoryFilters.put(docType, iFilters);
        if (!this.defFilters.containsKey((Object)docType)) {
            this.defFilters.put(docType, new Filters((Filters)iFilters));
        }
    }

    public void toJson(JsonWriter jsonWriter) throws IOException {
        IFilters iFilters = null;
        jsonWriter.beginObject();
        try {
            iFilters = this.getDefaultFilters(DocType.FOLDER);
            if (iFilters != null) {
                jsonWriter.name(DocType.FOLDER.toJson());
                ((IJsonState)iFilters).toJson(jsonWriter);
            }
            if ((iFilters = this.getDefaultFilters(DocType.TEXT)) != null) {
                jsonWriter.name(DocType.TEXT.toJson());
                ((IJsonState)iFilters).toJson(jsonWriter);
            }
        }
        finally {
            jsonWriter.endObject();
        }
    }
}

