/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.LocaleUtil;
import com.deltawalker.PrefKey;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.io.BomHeader;
import com.deltopia.io.TextEncoding;
import com.deltopia.util.OS;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeSet;
import org.apache.turbine.services.mimetype.util.CharSetMap;
import org.eclipse.jface.preference.IPreferenceStore;

public final class EncodingUtil {
    public static final Charset DEFAULT_ENCODING = Charset.forName(OS.OSX ? "UTF-8" : System.getProperty("file.encoding"));
    private static String encoding;
    private static final CharSetMap locale2Encoding;
    private static String strLocale;
    private static boolean useLocale;

    static {
        locale2Encoding = new CharSetMap(){

            public String getDefaultCharSet() {
                return "";
            }
        };
    }

    public static String[] getCharsets() {
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        TreeSet<String> treeSet = new TreeSet<String>(sortedMap.keySet());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.contains("-BOM")) continue;
            iterator.remove();
        }
        treeSet.addAll(BomHeader.getUiCharsets());
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public static String getEncoding(IPreferenceStore iPreferenceStore) {
        if (encoding != null && iPreferenceStore != null && useLocale == iPreferenceStore.getBoolean(PrefKey.T_USE_LOCALE.toString()) && ObjectUtil.areEqual((Object)strLocale, (Object)iPreferenceStore.getString(PrefKey.T_ENCODING_LOCALE.toString()))) {
            return encoding;
        }
        if (iPreferenceStore != null && iPreferenceStore.getBoolean(PrefKey.T_USE_LOCALE.toString())) {
            String string;
            Locale locale = LocaleUtil.getLocale(iPreferenceStore);
            String string2 = string = locale != null ? EncodingUtil.getEncoding(locale) : null;
            if (!StringUtil.isEmpty((String)string)) {
                useLocale = true;
                strLocale = iPreferenceStore.getString(PrefKey.T_ENCODING_LOCALE.toString());
                encoding = string;
                return string;
            }
        }
        return DEFAULT_ENCODING.name();
    }

    public static String getEncoding(Locale locale) {
        return locale2Encoding.getCharSet(locale);
    }

    public static TextEncoding getTextEncoding(IPreferenceStore iPreferenceStore) {
        String string = EncodingUtil.getEncoding(iPreferenceStore);
        return TextEncoding.fromCharset((String)string);
    }

    private EncodingUtil() {
    }
}

