/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.ImageCache;
import com.deltawalker.ImageConst;
import com.deltawalker.Msg;
import com.deltawalker.script.Comparison;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DocType
extends Enum<DocType> {
    public static final /* enum */ DocType ARCHIVE;
    public static final /* enum */ DocType BINARY;
    public static final /* enum */ DocType FOLDER;
    public static final /* enum */ DocType HTML;
    public static final /* enum */ DocType IMAGE;
    public static final /* enum */ DocType IWORK;
    public static final /* enum */ DocType OFFICE;
    public static final /* enum */ DocType PDF;
    public static final /* enum */ DocType PREVIEW;
    public static final /* enum */ DocType RTF;
    public static final /* enum */ DocType SCRIPT;
    public static final /* enum */ DocType TEXT;
    public static final /* enum */ DocType UNKNOWN;
    public static final /* enum */ DocType XML;
    private static final Map<Integer, DocType> int2Enum;
    private static final Logger LOG;
    private static final Set<DocType> ORDERED;
    private static final Map<String, DocType> str2Enum;
    private final String ctDisplayName;
    private final ContentType cType;
    private final String displayName;
    private final String docFactoryId;
    private final String imageId;
    private final int index;
    private final String jsonText;
    private final String viewFactoryId;
    private static final /* synthetic */ DocType[] ENUM$VALUES;

    static {
        Object object;
        ARCHIVE = new DocType(Msg.DocType_archive, ContentType.ARCHIVE, Msg.DocType_ctArchive, ImageConst.PLAIN_TEXT, "a", 5, "com.deltawalker.structure.folderDocFactory", "com.deltawalker.structure.folderViewFactory");
        BINARY = new DocType(Msg.DocType_binary, ContentType.BINARY, Msg.DocType_ctBinary, ImageConst.PLAIN_TEXT, "b", 1, "com.deltawalker.text.textDocFactory", "com.deltawalker.bin.binViewFactory");
        FOLDER = new DocType(Msg.DocType_folder, ContentType.FOLDER, "", ImageConst.FOLDER, "d", -1, "com.deltawalker.structure.folderDocFactory", "com.deltawalker.structure.folderViewFactory");
        HTML = new DocType(Msg.DocType_html, ContentType.TEXT_HTML, Msg.DocType_ctHtml, ImageConst.HTML, "h", 3, "com.deltawalker.html.htmlDocFactory", "com.deltawalker.html.htmlViewFactory");
        IMAGE = new DocType(Msg.DocType_image, ContentType.IMAGE, Msg.DocType_ctImage, ImageConst.IMAGE, "i", 2, "com.deltawalker.image.imageDocFactory", "com.deltawalker.image.imageViewFactory");
        IWORK = new DocType(Msg.DocType_iwork, ContentType.IWORK, Msg.DocType_ctiWork, ImageConst.PLAIN_TEXT, "iw", 6, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        OFFICE = new DocType(Msg.DocType_office, ContentType.OFFICE, Msg.DocType_ctOffice, ImageConst.PLAIN_TEXT, "o", 6, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        PDF = new DocType(Msg.DocType_pdf, ContentType.PDF, Msg.DocType_ctPdf, "", "p", 7, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        PREVIEW = new DocType(Msg.DocType_preview, null, "", "", "pr", -1, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        RTF = new DocType(Msg.DocType_text, ContentType.OFFICE, Msg.DocType_ctRtf, ImageConst.PLAIN_TEXT, "r", 9, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        SCRIPT = new DocType(Msg.DocType_script, ContentType.TEXT, Msg.DocType_ctText, ImageConst.PLAIN_TEXT, "s", 0, null, null);
        TEXT = new DocType(Msg.DocType_text, ContentType.TEXT, Msg.DocType_ctText, ImageConst.PLAIN_TEXT, "t", 0, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        UNKNOWN = new DocType(Msg.DocType_unknown, ContentType.UNKNOWN, "", ImageConst.PLAIN_TEXT, "u", -1, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        XML = new DocType(Msg.DocType_xml, ContentType.TEXT_XML, Msg.DocType_ctXml, ImageConst.XML_STRUCTURE, "x", 4, "com.deltawalker.text.textDocFactory", "com.deltawalker.text.textViewFactory");
        ENUM$VALUES = new DocType[]{ARCHIVE, BINARY, FOLDER, HTML, IMAGE, IWORK, OFFICE, PDF, PREVIEW, RTF, SCRIPT, TEXT, UNKNOWN, XML};
        int2Enum = new HashMap<Integer, DocType>(10);
        LOG = LoggerFactory.getLogger(DocType.class);
        str2Enum = new HashMap<String, DocType>(20);
        DocType[] docTypeArray = DocType.values();
        int n = docTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = docTypeArray[n2];
            str2Enum.put(((DocType)((Object)object)).ctDisplayName, (DocType)((Object)object));
            str2Enum.put(((DocType)((Object)object)).jsonText, (DocType)((Object)object));
            int2Enum.put(((DocType)((Object)object)).index, (DocType)((Object)object));
            ++n2;
        }
        object = new LinkedHashSet(10);
        object.add(TEXT);
        object.add(BINARY);
        object.add(IMAGE);
        object.add(HTML);
        object.add(XML);
        object.add(ARCHIVE);
        object.add(OFFICE);
        object.add(PDF);
        ORDERED = Collections.unmodifiableSet(object);
    }

    public static DocType fromIndex(int n) {
        assert (int2Enum.containsKey(n));
        return int2Enum.get(n);
    }

    public static DocType fromJson(String string) {
        assert (str2Enum.containsKey(string));
        return str2Enum.get(string);
    }

    public static DocType fromScript(Comparison.Type type) {
        switch (type) {
            case FOLDER: {
                return FOLDER;
            }
            case IMAGE: {
                return IMAGE;
            }
        }
        return TEXT;
    }

    public static DocType fromString(String string) {
        DocType docType = str2Enum.get(string);
        if (docType != null) {
            return docType;
        }
        if (string.equals("bin")) {
            return BINARY;
        }
        if (string.equals("txt")) {
            return TEXT;
        }
        LOG.error("Couldn't map " + string + " to a DocType enum value.");
        return UNKNOWN;
    }

    public static Set<DocType> orderedTypes() {
        return ORDERED;
    }

    private DocType(String string2, ContentType contentType, String string3, String string4, String string5, int n2, String string6, String string7) {
        assert (string2 != null);
        assert (string3 != null);
        assert (string4 != null);
        assert (string5 != null);
        this.displayName = string2;
        this.cType = contentType;
        this.ctDisplayName = string3;
        this.imageId = string4;
        this.jsonText = string5;
        this.index = n2;
        this.docFactoryId = string6;
        this.viewFactoryId = string7;
    }

    public String contentDisplayName() {
        return this.ctDisplayName;
    }

    public ContentType contentType() {
        return this.cType;
    }

    public String displayName() {
        return this.displayName;
    }

    public String factoryId() {
        return this.docFactoryId;
    }

    public FileType fileType() {
        switch (this) {
            case FOLDER: {
                return FileType.FOLDER;
            }
            case UNKNOWN: {
                return FileType.UNKNOWN;
            }
        }
        return FileType.FILE;
    }

    public Image image() {
        return ImageCache.getImage(this.imageId);
    }

    public int index() {
        return this.index;
    }

    public boolean isArchive() {
        return this == ARCHIVE;
    }

    public boolean isBinary() {
        return this == BINARY || this == IMAGE;
    }

    public boolean isCompoundDoc() {
        return this == OFFICE || this == PDF || this == RTF || this == IWORK;
    }

    public boolean isImage() {
        return this == IMAGE;
    }

    public boolean isStructure() {
        return this == FOLDER || this == ARCHIVE;
    }

    public boolean isText() {
        return this == TEXT || this == HTML || this == XML || this.isCompoundDoc() || this == PREVIEW;
    }

    public String toJson() {
        return this.jsonText;
    }

    public String toString() {
        return this.ctDisplayName;
    }

    public String viewFactoryId() {
        return this.viewFactoryId;
    }

    public static DocType[] values() {
        DocType[] docTypeArray = ENUM$VALUES;
        int n = docTypeArray.length;
        DocType[] docTypeArray2 = new DocType[n];
        System.arraycopy(ENUM$VALUES, 0, docTypeArray2, 0, n);
        return docTypeArray2;
    }

    public static DocType valueOf(String string) {
        return Enum.valueOf(DocType.class, string);
    }
}

