/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.DiffDoc;
import com.deltawalker.DocType;
import com.deltawalker.UriInfo;
import com.deltawalker.UriInfoUtil;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDocFactory;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltopia.eclipse.util.FactoryFinder;
import com.deltopia.eclipse.util.FactoryInfo;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.util.ArrayUtil;
import java.util.Map;

public abstract class DocFactory
implements IDocFactory {
    public static void ensureTextFactoryFirst(IDocFactory[] iDocFactoryArray) {
        IDocFactory[] iDocFactoryArray2 = iDocFactoryArray;
        int n = iDocFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocFactory iDocFactory = iDocFactoryArray2[n2];
            if (iDocFactory.id().equals("com.deltawalker.text.textDocFactory")) {
                IDocFactory iDocFactory2 = DocFactory.getFactory("com.deltawalker.text.textDocFactory");
                int n3 = ArrayUtil.indexOf((Object[])iDocFactoryArray, (Object)iDocFactory2);
                if (n3 <= 0) break;
                IDocFactory iDocFactory3 = iDocFactoryArray[0];
                iDocFactoryArray[0] = iDocFactoryArray[n3];
                iDocFactoryArray[n3] = iDocFactory3;
                break;
            }
            ++n2;
        }
    }

    public static IDocFactory[] getFactories(ContentType contentType) {
        FactoryInfo[] factoryInfoArray = FactoryFinder.getFactories("com.deltawalker.docFactories", contentType);
        int n = factoryInfoArray.length;
        IDocFactory[] iDocFactoryArray = new IDocFactory[n];
        int n2 = 0;
        while (n2 < n) {
            iDocFactoryArray[n2] = (IDocFactory)factoryInfoArray[n2].getFactory();
            ++n2;
        }
        DocFactory.ensureTextFactoryFirst(iDocFactoryArray);
        return iDocFactoryArray;
    }

    public static IDocFactory[] getFactories(Map<Role, UriInfo> map, IResource[] iResourceArray, boolean bl, FileType fileType) {
        Object[] objectArray = FactoryFinder.getFactories("com.deltawalker.docFactories", map, iResourceArray, bl);
        IDocFactory[] iDocFactoryArray = new IDocFactory[objectArray.length];
        System.arraycopy(objectArray, 0, iDocFactoryArray, 0, objectArray.length);
        if (iDocFactoryArray.length == 0) {
            ContentType contentType = UriInfoUtil.guessContentType(map);
            DocType docType = !contentType.isUnknown() ? DocType.fromJson(contentType.docTypeKey()) : (fileType == FileType.FOLDER ? DocType.FOLDER : DocType.TEXT);
            iDocFactoryArray = new IDocFactory[]{DocFactory.getFactory(docType.factoryId())};
        } else {
            DocFactory.ensureTextFactoryFirst(iDocFactoryArray);
        }
        return iDocFactoryArray;
    }

    public static IDocFactory getFactory(String string) {
        return (IDocFactory)FactoryFinder.getFactory("com.deltawalker.docFactories", string);
    }

    @Override
    public IDiffDoc createDiffDoc(DiffDoc.Builder builder) {
        return builder.build();
    }

    @Override
    public IDiffModel createDiffModel(IDiffDoc iDiffDoc) {
        return null;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

