/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.DocType;
import com.deltawalker.IStorageNotifier;
import com.deltawalker.Msg;
import com.deltawalker.NotifyUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.UriInfo;
import com.deltawalker.resources.IPersistableResource;
import com.deltawalker.resources.IResource;
import com.deltawalker.resources.ResourceFactory;
import com.deltopia.ObjectUtil;
import com.deltopia.StringUtil;
import com.deltopia.eclipse.util.IPropertyChangeNotifier;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.io.IStorageListener;
import com.deltopia.io.StorageEvent;
import com.deltopia.util.Checker;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocBase
extends EventManager
implements IMvcModel,
IPropertyChangeNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(DocBase.class);
    protected static final boolean LOG_DBG = LOG.isDebugEnabled();
    private static int nameCounter = 1;
    private String name;
    private String oldName = "";
    private final ResourceListener onResource = new ResourceListener();
    private IResource resource;
    private String untitled;
    private boolean stgEventsOn = true;

    @Override
    public void addPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Doc#addPropertyChangeListener for " + this.hashCode() + " with " + this.getListeners().length + " so far");
        }
        this.addListenerObject(iPropertyChangeListener);
    }

    public void clear() {
        this.setResource(null);
        this.name = "";
        this.oldName = "";
    }

    public abstract DocType docType();

    protected void firePropertyChanged(String string, Object object, Object object2) {
        if (!ObjectUtil.areEqual((Object)object2, (Object)object)) {
            NotifyUtil.firePropertyChange(this.getListeners(), new PropertyChangeEvent((Object)this, string, object, object2));
        }
    }

    protected void fireStoragePropertyChanged(StorageEvent storageEvent) {
        NotifyUtil.firePropertyChange(this.getListeners(), new PropertyChangeEvent((Object)this, "STORAGE", null, (Object)storageEvent));
    }

    protected void fireUriInfoChanged(String string) {
        NotifyUtil.firePropertyChange(this.getListeners(), new PropertyChangeEvent((Object)this, "URI_INFO", null, (Object)string));
        App.instance().stateBoss().saveState();
    }

    public void dispose() {
    }

    public String getName() {
        Object object;
        String string;
        String string2 = string = this.resource != null && !this.resource.getName().isEmpty() ? this.resource.getName() : this.uriInfo().uri();
        if (!StringUtil.isEmpty((String)string)) {
            this.name = string;
            if (!this.name.equals(this.oldName)) {
                String string3 = this.oldName;
                this.oldName = this.name;
                this.firePropertyChanged("NAME", string3, this.name);
            }
            return this.name;
        }
        if (this.isModified() && StringUtil.isEmpty((String)this.untitled)) {
            this.untitled = String.valueOf(Msg.Doc_untitled) + nameCounter;
            object = this.docType();
            if (object == DocType.TEXT || object == DocType.SCRIPT) {
                ++nameCounter;
            }
        }
        String string4 = object = this.isModified() ? this.untitled : this.docType().fileType().toString();
        if (!object.equals(this.oldName)) {
            String string5 = this.oldName;
            this.oldName = object;
            this.firePropertyChanged("NAME", string5, object);
        }
        return object;
    }

    protected boolean hasResource() {
        return this.resource != null;
    }

    public boolean isEmpty() {
        return this.resource == null && !this.isModified();
    }

    public boolean isModified() {
        return false;
    }

    public boolean isWritable() {
        IResource iResource = this.resource();
        return iResource != null ? iResource.isWritable() : true;
    }

    public abstract IPreferenceStore preferences();

    protected void propertyChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals("READ_ONLY")) {
            this.firePropertyChanged("READ_ONLY", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    @Override
    public void removePropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("removePropertyChangeListener for " + this.hashCode() + " with " + this.getListeners().length + " so far");
        }
        this.removeListenerObject(iPropertyChangeListener);
    }

    public IResource resource() {
        UriInfo uriInfo = this.uriInfo();
        if (this.resource == null && !uriInfo.isEmpty() && !uriInfo.hasError()) {
            try {
                this.setResource(ResourceFactory.staticCreateResource(uriInfo, false, this.preferences().getBoolean(PrefKey.C_FOLLOW_SYMLINKS.toString())));
            }
            catch (IOException iOException) {
                uriInfo = uriInfo.cloneUpdateError(iOException);
                LOG.error("Failed creating resource: ", (Throwable)iOException);
            }
        }
        return this.resource;
    }

    public void setName(String string) {
        throw new UnsupportedOperationException();
    }

    protected void setResource(IResource iResource) {
        if (this.resource == iResource) {
            return;
        }
        if (this.resource != null) {
            if (this.resource instanceof IPropertyChangeNotifier) {
                ((IPropertyChangeNotifier)((Object)this.resource)).removePropertyListener(this.onResource);
            }
            if (this.resource instanceof IStorageNotifier) {
                ((IStorageNotifier)((Object)this.resource)).removeStorageListener(this.onResource);
            }
        }
        this.resource = iResource;
        if (iResource != null) {
            if (iResource instanceof IPropertyChangeNotifier) {
                ((IPropertyChangeNotifier)((Object)iResource)).addPropertyListener(this.onResource);
            }
            if (iResource instanceof IStorageNotifier) {
                ((IStorageNotifier)((Object)iResource)).addStorageListener(this.onResource);
            }
        }
    }

    private final synchronized void enableStorageEvents(boolean bl) {
        if (LOG_DBG) {
            LOG.debug(String.valueOf(bl ? "Enable" : "Disable") + " notifications");
        }
        this.stgEventsOn = bl;
    }

    private final synchronized boolean areStorageEventsEnabled() {
        return this.stgEventsOn;
    }

    private final void storageChanged(StorageEvent storageEvent) {
        if (!this.areStorageEventsEnabled()) {
            if (LOG_DBG) {
                LOG.debug("Notifications disabled: " + this.getName());
            }
            return;
        }
        IResource iResource = this.resource;
        if (((IStorageNotifier)((Object)iResource)).shouldFireStorageEvents()) {
            IPath iPath = Path.fromOSString((String)iResource.getPath());
            if (storageEvent.isForPath(iPath)) {
                storageEvent = new StorageEvent((Object)iResource, storageEvent.type, new Object[]{iResource});
                this.fireStoragePropertyChanged(storageEvent);
            } else if (LOG.isInfoEnabled()) {
                LOG.info("Skip notification event for path " + iPath + ": " + storageEvent);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public UriInfo uriInfo() {
        String string = this.resource != null ? this.resource.getPath() : "";
        return new UriInfo(string);
    }

    protected final IResource saveByteResourceOpt(UriInfo uriInfo, byte[] byArray, IProgressMonitor iProgressMonitor) throws IOException {
        IResource iResource;
        Checker.notNull((Object)uriInfo, (String)"uriInfo");
        Checker.notNull((Object)byArray, (String)"bytes");
        IResource iResource2 = iResource = this.hasResource() ? this.resource() : null;
        if (iResource instanceof IPersistableResource) {
            try {
                this.enableStorageEvents(false);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ((IPersistableResource)((Object)iResource)).save(uriInfo.uri(), byteArrayInputStream, iProgressMonitor);
            }
            finally {
                this.enableStorageEvents(true);
            }
        }
        return iResource;
    }

    private class ResourceListener
    implements IPropertyChangeListener,
    IStorageListener {
        ResourceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DocBase.this.propertyChanged(propertyChangeEvent);
        }

        public void storageChanged(StorageEvent storageEvent) {
            DocBase.this.storageChanged(storageEvent);
        }

        public String toString() {
            return "@" + System.identityHashCode(this) + " " + DocBase.this;
        }
    }

    public final class UriConst {
        public static final String LINE_ENDING = "LINE_ENDING";
        public static final String URI = "URI";
        public static final String ERROR = "ERROR";

        private UriConst() {
        }
    }
}

