/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.DocBase;
import com.deltawalker.DocType;
import com.deltawalker.Msg;
import com.deltawalker.NotifyUtil;
import com.deltawalker.PrefKey;
import com.deltawalker.UriInfo;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDoc;
import com.deltawalker.resources.IResource;
import com.deltawalker.script.Role;
import com.deltopia.ObjectUtil;
import com.deltopia.interfaces.IMvcModel;
import com.deltopia.io.ContentType;
import com.deltopia.io.FileType;
import com.deltopia.io.VfsUtil;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Doc
extends DocBase
implements IDoc,
IMvcModel {
    private static final Logger LOG = LoggerFactory.getLogger(Doc.class);
    private boolean allowEdit;
    private ContentType cType;
    private final IDiffDoc dDoc;
    private UriInfo mergedUI;
    private final Role role;

    public static String constructHint(Role role, FileType fileType, boolean bl) {
        String string = NLS.bind((String)Msg.Doc_hint, (Object)role.getDisplayName(bl), (Object)fileType.displayName());
        return string;
    }

    public Doc(IDiffDoc iDiffDoc, Role role, IResource iResource, ContentType contentType) {
        this.dDoc = iDiffDoc;
        this.role = role;
        this.cType = contentType != null ? contentType : ContentType.UNKNOWN;
        this.setResource(iResource != null ? iResource : this.resource());
        this.allowEdit = this.preferences().getBoolean(PrefKey.F_ALLOW_READONLY_EDIT.toString());
    }

    @Override
    public void allowReadOnlyEdit(boolean bl) {
        this.allowEdit = bl;
    }

    @Override
    public boolean canEverWrite() {
        IResource iResource = this.resource();
        try {
            boolean bl = false;
            if (iResource != null) {
                boolean bl2 = bl = iResource.canEverWrite() && this.contentType() != ContentType.ARCHIVE;
                if (bl) {
                    bl = !this.isSnapshot();
                }
            } else {
                bl = true;
            }
            return bl;
        }
        catch (IOException iOException) {
            LOG.warn("canEverWrite failed", (Throwable)iOException);
            return false;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.cType = ContentType.UNKNOWN;
    }

    @Override
    public ContentType contentType() {
        IResource iResource = this.resource();
        if (this.cType == ContentType.FOLDER && iResource != null && VfsUtil.isArchiveExtension((String)iResource.file().scheme())) {
            this.cType = ContentType.ARCHIVE;
        }
        return this.cType;
    }

    protected IDiffDoc deltaDoc() {
        return this.dDoc;
    }

    @Override
    public void dispose() {
        this.clear();
    }

    @Override
    public DocType docType() {
        return DocType.fromJson(this.cType.docTypeKey());
    }

    @Override
    protected void fireUriInfoChanged(String string) {
        NotifyUtil.firePropertyChange(this.getListeners(), new PropertyChangeEvent((Object)this, "URI_INFO", null, (Object)string));
        App.instance().stateBoss().saveState();
    }

    @Override
    public Image getImage() {
        IResource iResource = this.resource();
        return iResource != null ? iResource.getImage() : null;
    }

    @Override
    public UriInfo getMergedUriInfo() {
        return this.mergedUI;
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    @Override
    public boolean isModifiable() {
        return this.allowEdit || this.isWritable();
    }

    @Override
    public boolean isSnapshot() {
        return false;
    }

    @Override
    public IPreferenceStore preferences() {
        return this.dDoc.preferences();
    }

    @Override
    public Role role() {
        return this.role;
    }

    @Override
    public void setMergedUriInfo(UriInfo uriInfo) {
        this.mergedUI = uriInfo;
    }

    @Override
    public void setUriInfoError(Throwable throwable) {
        UriInfo uriInfo = this.uriInfo();
        if (!ObjectUtil.areEqual((Object)throwable, (Object)uriInfo.error())) {
            this.deltaDoc().updateUriInfo(this.role(), UriInfo.Field.ERROR, throwable);
            this.fireUriInfoChanged("ERROR");
        }
    }

    @Override
    public String toString() {
        return (Object)((Object)this.role) + " " + this.getName();
    }

    @Override
    public UriInfo uriInfo() {
        return this.dDoc.uriInfo(this.role);
    }
}

