/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.DiffModelEvent;
import com.deltawalker.interfaces.IDiffModelListener;
import com.deltopia.WorkerPool;
import java.util.LinkedList;
import java.util.List;

public class DiffModelNotifier {
    private final List<IDiffModelListener> listeners = new LinkedList<IDiffModelListener>();
    private WorkerPool pool;

    public DiffModelNotifier() {
        this(false);
    }

    public DiffModelNotifier(boolean bl) {
        this.setAsyncNotify(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IDiffModelListener iDiffModelListener) {
        if (iDiffModelListener == null) {
            throw new NullPointerException("listener");
        }
        DiffModelNotifier diffModelNotifier = this;
        synchronized (diffModelNotifier) {
            if (!this.listeners.contains(iDiffModelListener)) {
                this.listeners.add(iDiffModelListener);
                if (this.pool != null && this.listeners.size() == 1) {
                    this.pool.restart();
                }
            }
        }
    }

    public DiffModelEvent[] getPendingEvents() {
        return this.getPendingEvents(false);
    }

    public DiffModelEvent[] getPendingEvents(boolean bl) {
        WorkerPool workerPool = this.pool;
        if (workerPool == null) {
            return new DiffModelEvent[0];
        }
        Runnable[] runnableArray = workerPool.getAssignments(bl);
        DiffModelEvent[] diffModelEventArray = new DiffModelEvent[runnableArray.length];
        int n = 0;
        while (n < runnableArray.length) {
            diffModelEventArray[n] = ((NotifierRunnable)runnableArray[n]).getEvent();
            ++n;
        }
        return diffModelEventArray;
    }

    public boolean isAsyncNotify() {
        return this.pool != null;
    }

    public void notifyListeners(DiffModelEvent diffModelEvent) {
        this.notifyListeners(diffModelEvent, false);
    }

    public void notifyListeners(DiffModelEvent diffModelEvent, boolean bl) {
        WorkerPool workerPool = this.pool;
        if (!bl && workerPool != null) {
            workerPool.queueAssignment((Runnable)new NotifierRunnable(diffModelEvent));
        } else {
            this.notifyListenersImpl(diffModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersImpl(DiffModelEvent diffModelEvent) {
        IDiffModelListener[] iDiffModelListenerArray;
        Object object = this;
        synchronized (object) {
            iDiffModelListenerArray = this.listeners.toArray(new IDiffModelListener[this.listeners.size()]);
        }
        IDiffModelListener[] iDiffModelListenerArray2 = iDiffModelListenerArray;
        int n = iDiffModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iDiffModelListenerArray2[n2];
            object.handleEvent(diffModelEvent);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IDiffModelListener iDiffModelListener) {
        if (iDiffModelListener == null) {
            throw new NullPointerException("listener");
        }
        DiffModelNotifier diffModelNotifier = this;
        synchronized (diffModelNotifier) {
            this.listeners.remove(iDiffModelListener);
            if (this.pool != null && this.listeners.size() == 0) {
                this.pool.beginShutdown();
            }
        }
    }

    public synchronized void setAsyncNotify(boolean bl) {
        this.pool = bl ? new WorkerPool(1) : null;
    }

    private class NotifierRunnable
    implements Runnable {
        private DiffModelEvent event;

        public NotifierRunnable(DiffModelEvent diffModelEvent) {
            this.event = diffModelEvent;
        }

        public DiffModelEvent getEvent() {
            return this.event;
        }

        @Override
        public void run() {
            DiffModelNotifier.this.notifyListenersImpl(this.event);
        }
    }
}

