/*
 * Decompiled with CFR 0.152.
 */
package com.deltawalker;

import com.deltawalker.App;
import com.deltawalker.DiffModelEvent;
import com.deltawalker.DiffModelNotifier;
import com.deltawalker.JobBoss;
import com.deltawalker.MergeException;
import com.deltawalker.NullStructElement;
import com.deltawalker.ScriptBoss;
import com.deltawalker.interfaces.IApp;
import com.deltawalker.interfaces.IDiffDoc;
import com.deltawalker.interfaces.IDiffModel;
import com.deltawalker.interfaces.IDiffModelListener;
import com.deltawalker.interfaces.IFilters;
import com.deltawalker.internal.DeltaWalkerPlugin;
import com.deltawalker.ui.IDiffSummary;
import com.deltopia.ObjectUtil;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiffModel
extends EventManager
implements IDiffModel {
    private static final Logger LOG = LoggerFactory.getLogger(DiffModel.class);
    private final IApp app = App.instance();
    protected final IDiffDoc dDoc;
    private final DiffModelNotifier dmNotifier = new DiffModelNotifier();
    private IDiffSummary summary;

    public static boolean isNullElement(Object object) {
        return object == null || object instanceof NullStructElement;
    }

    protected DiffModel(IDiffDoc iDiffDoc) {
        this.dDoc = iDiffDoc;
    }

    @Override
    public void addModelListener(IDiffModelListener iDiffModelListener) {
        if (iDiffModelListener == null) {
            throw new NullPointerException("listener");
        }
        this.dmNotifier.addListener(iDiffModelListener);
    }

    @Override
    public void addPropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.addListenerObject(iPropertyChangeListener);
    }

    protected boolean canUpdate() {
        return true;
    }

    public void clearSummary() {
        this.summary = null;
    }

    protected IDiffSummary createSummary() {
        return null;
    }

    @Override
    public IDiffDoc deltaDoc() {
        return this.dDoc;
    }

    public void dispose() {
        this.summary = null;
    }

    @Override
    public IFilters filters() {
        return this.dDoc.filters();
    }

    private void fireEvent(DiffModelEvent diffModelEvent) {
        if (this.canUpdate()) {
            this.dmNotifier.notifyListeners(diffModelEvent);
        }
    }

    public void fireEvent(DiffModelEvent.Type type, Object object) {
        this.fireEvent(new DiffModelEvent(this, type, object));
    }

    public String getName() {
        return "";
    }

    @Override
    public final boolean isThreeWay() {
        return this.dDoc.isThreeWay();
    }

    @Override
    public int roleCount() {
        return this.dDoc.roleCount();
    }

    @Override
    public void mergeNonConflicts() {
        Job job = new Job("Merge non-conflicts"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                IStatus iStatus;
                DiffModel.this.deltaDoc().setWorking(true, "merge");
                DiffModel.this.app.scriptBoss().fireEvent(ScriptBoss.Event.MERGE_STARTED, null, DiffModel.this.deltaDoc());
                try {
                    DiffModel.this.mergeNonConflicts(iProgressMonitor);
                    iStatus = iProgressMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
                catch (MergeException mergeException) {
                    iStatus = new Status(4, DeltaWalkerPlugin.getPluginId(), mergeException.getLocalizedMessage());
                }
                catch (OperationCanceledException operationCanceledException) {
                    iStatus = Status.CANCEL_STATUS;
                }
                return iStatus;
            }
        };
        job.setUser(false);
        job.addJobChangeListener(JobBoss.INSTANCE.jobListener());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent iJobChangeEvent) {
                DiffModel.this.deltaDoc().setWorking(false, null);
                DiffModel.this.app.scriptBoss().fireEvent(ScriptBoss.Event.MERGE_ENDED, null, DiffModel.this.deltaDoc());
                IStatus iStatus = iJobChangeEvent.getResult();
                if (!iStatus.isOK()) {
                    LOG.error("Error merging non-conflicting differences.", iStatus.getException());
                }
            }
        });
        job.schedule();
    }

    protected void mergeNonConflicts(IProgressMonitor iProgressMonitor) throws MergeException {
    }

    @Override
    public void removeModelListener(IDiffModelListener iDiffModelListener) {
        if (iDiffModelListener == null) {
            throw new NullPointerException("listener");
        }
        this.dmNotifier.removeListener(iDiffModelListener);
    }

    @Override
    public void removePropertyListener(IPropertyChangeListener iPropertyChangeListener) {
        this.removeListenerObject(iPropertyChangeListener);
    }

    public void setName(String string) {
    }

    protected void setSummary(IDiffSummary iDiffSummary) {
        if (!ObjectUtil.areEqual((Object)this.summary, (Object)iDiffSummary)) {
            this.summary = iDiffSummary;
        }
    }

    @Override
    public synchronized IDiffSummary summary() {
        return this.summary;
    }
}

